/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.recipe;

import java.util.Collections;
import net.minecraft.util.NonNullList;
import ovh.corail.recycler.recipe.RecyclingManager;
import ovh.corail.recycler.recipe.SimpleStack;

public class RecyclingRecipe {
    protected final SimpleStack itemRecipe;
    protected Boolean isAllowed = null;
    protected Boolean isUnbalanced = null;
    protected boolean isUserDefined = false;
    protected final NonNullList<SimpleStack> itemsList = NonNullList.func_191196_a();

    public RecyclingRecipe(SimpleStack stack) {
        this.itemRecipe = stack;
    }

    public RecyclingRecipe(SimpleStack stackIn, NonNullList<SimpleStack> stacksOut) {
        this.itemRecipe = stackIn;
        this.itemsList.addAll(stacksOut);
    }

    public RecyclingRecipe(SimpleStack stackIn, SimpleStack[] stacksOut) {
        this.itemRecipe = stackIn;
        Collections.addAll(this.itemsList, stacksOut);
    }

    public SimpleStack getItemRecipe() {
        return this.itemRecipe;
    }

    RecyclingRecipe setUnbalanced(boolean state) {
        this.isUnbalanced = state;
        return this;
    }

    public boolean isUnbalanced() {
        if (this.isUnbalanced == null) {
            this.isUnbalanced = RecyclingManager.instance.isUnbalancedRecipe(this);
        }
        return this.isUnbalanced;
    }

    public RecyclingRecipe setUserDefined(boolean state) {
        this.isUserDefined = state;
        return this;
    }

    public boolean isUserDefined() {
        return this.isUserDefined;
    }

    RecyclingRecipe setAllowed(boolean state) {
        this.isAllowed = state;
        return this;
    }

    public boolean isAllowed() {
        if (this.isAllowed == null) {
            this.isAllowed = RecyclingManager.instance.isAllowedRecipe(this);
        }
        return this.isAllowed;
    }

    public Integer getCount() {
        return this.itemsList.size();
    }

    public void addStack(SimpleStack stack) {
        this.itemsList.add((Object)stack);
    }

    public SimpleStack getResult(int index) {
        return (SimpleStack)this.itemsList.get(index);
    }

    public NonNullList<SimpleStack> getResult() {
        return this.itemsList;
    }
}

