/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.registry;

import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.recycler.block.BlockRecycler;
import ovh.corail.recycler.block.ItemBlockRecycler;
import ovh.corail.recycler.gui.ContainerRecycler;
import ovh.corail.recycler.gui.ContainerRecyclingBook;
import ovh.corail.recycler.item.ItemDisk;
import ovh.corail.recycler.item.ItemGeneric;
import ovh.corail.recycler.registry.ModBlocks;
import ovh.corail.recycler.tileentity.TileEntityRecycler;

@Mod.EventBusSubscriber(modid="corail_recycler", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryHandler {
    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)RegistryHandler.withName(new BlockRecycler(), "recycler"));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RegistryHandler.withName(new ItemGeneric("diamond_shard"), "diamond_shard"), RegistryHandler.withName(new ItemDisk("diamond_disk", 5000, -14564133), "diamond_disk"), RegistryHandler.withName(new ItemDisk("steel_disk", 500, -4144960), "steel_disk"), (Item)RegistryHandler.withName(new ItemBlockRecycler(ModBlocks.recycler), ModBlocks.recycler.getRegistryName())});
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{RegistryHandler.fromSound("recycler"), RegistryHandler.fromSound("recycler_working")});
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)RegistryHandler.withName(TileEntityType.Builder.func_223042_a(TileEntityRecycler::new, (Block[])new Block[]{ModBlocks.recycler}).func_206865_a(null), "recycler"));
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new ContainerType[]{RegistryHandler.withName(IForgeContainerType.create(ContainerRecycler::new), "recycler"), RegistryHandler.withName(new ContainerType(ContainerRecyclingBook::new), "recycling_book")});
    }

    private static SoundEvent fromSound(String name) {
        ResourceLocation rl = new ResourceLocation("corail_recycler", name);
        return (SoundEvent)new SoundEvent(rl).setRegistryName(rl);
    }

    private static <T extends IForgeRegistryEntry<T>> T withName(T entry, String name) {
        return (T)((IForgeRegistryEntry)entry.setRegistryName(new ResourceLocation("corail_recycler", name)));
    }

    private static <T extends IForgeRegistryEntry<T>> T withName(T entry, ResourceLocation locName) {
        return (T)((IForgeRegistryEntry)entry.setRegistryName(locName));
    }
}

