/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.util;

import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.recycler.recipe.RecyclingRecipe;

public class Helper {
    public static final Random random = new Random();

    public static int getRandom(int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static boolean isValidPlayer(@Nullable PlayerEntity player) {
        return player != null && Helper.isNotFakePlayer((LivingEntity)player);
    }

    public static boolean isValidServerPlayer(@Nullable PlayerEntity player) {
        return player != null && !player.field_70170_p.field_72995_K && Helper.isNotFakePlayer((LivingEntity)player);
    }

    private static boolean isNotFakePlayer(LivingEntity entity) {
        return !(entity instanceof FakePlayer);
    }

    public static boolean atInterval(long ticksExisted, int tick) {
        return Helper.atInterval(ticksExisted, tick, true);
    }

    public static boolean atInterval(long ticksExisted, int tick, boolean ignoreZero) {
        return (!ignoreZero || ticksExisted > 0L) && ticksExisted % (long)tick == 0L;
    }

    public static boolean atInterval(World world, int tick) {
        return Helper.atInterval(world.func_82737_E(), tick, true);
    }

    public static float[] getRGBColor4F(int color) {
        float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f};
        return rgb;
    }

    public static boolean areItemEqual(ItemStack s1, ItemStack s2) {
        return !s1.func_190926_b() && s1.func_77973_b() == s2.func_77973_b();
    }

    public static boolean isValidRecipe(@Nullable RecyclingRecipe recipe) {
        return recipe != null && !recipe.getResult().isEmpty() && !recipe.getItemRecipe().isEmpty();
    }

    public static boolean isValidRecipe(@Nullable IRecipe<CraftingInventory> recipe) {
        return recipe != null && !recipe.func_192400_c().isEmpty() && !recipe.func_77571_b().func_190926_b() && recipe.func_192400_c().stream().allMatch(i -> i == Ingredient.field_193370_a || i.func_193365_a().length > 0);
    }

    public static NonNullList<ItemStack> mergeStackInList(NonNullList<ItemStack> list) {
        block0: for (int i = 0; i < list.size(); ++i) {
            ItemStack currentStack = (ItemStack)list.get(i);
            if (currentStack.func_190926_b() || !currentStack.func_77985_e() || currentStack.func_190916_E() >= currentStack.func_77976_d()) continue;
            for (int j = i + 1; j < list.size(); ++j) {
                int add;
                ItemStack lookStack = (ItemStack)list.get(j);
                if (lookStack.func_190926_b() || !Helper.areItemEqual(currentStack, lookStack) || (add = Math.min(lookStack.func_190916_E(), currentStack.func_77976_d() - currentStack.func_190916_E())) <= 0) continue;
                lookStack.func_190918_g(add);
                currentStack.func_190917_f(add);
                if (currentStack.func_190916_E() == currentStack.func_77976_d()) continue block0;
            }
        }
        list.removeIf(ItemStack::func_190926_b);
        return list;
    }

    public static boolean canInsertInInventory(IItemHandlerModifiable inventory, NonNullList<ItemStack> items) {
        List slotSizes = IntStream.range(0, inventory.getSlots()).map(slotId -> {
            ItemStack stack = inventory.getStackInSlot(slotId);
            return stack.func_190926_b() ? 0 : stack.func_190916_E();
        }).boxed().collect(Collectors.toList());
        int emptySlots = (int)slotSizes.stream().filter(i -> i == 0).count();
        if (emptySlots >= items.size()) {
            return true;
        }
        int minCount = items.size() - emptySlots;
        block0: for (ItemStack stackIn : items) {
            if (minCount <= 0) {
                return true;
            }
            if (stackIn.func_190926_b()) {
                --minCount;
                continue;
            }
            if (!stackIn.func_77985_e()) continue;
            int left = stackIn.func_190916_E();
            for (int slotId2 = 0; slotId2 < inventory.getSlots(); ++slotId2) {
                int add;
                int stacksize;
                ItemStack currentStack = inventory.getStackInSlot(slotId2);
                if (!Helper.areItemEqual(stackIn, currentStack) || (stacksize = ((Integer)slotSizes.get(slotId2)).intValue()) >= currentStack.func_77976_d() || (add = Math.min(left, currentStack.func_77976_d() - stacksize)) <= 0) continue;
                slotSizes.set(slotId2, stacksize + add);
                if ((left -= add) > 0) continue;
                --minCount;
                continue block0;
            }
        }
        return minCount <= 0;
    }

    public static boolean isPacketToClient(NetworkEvent.Context ctx) {
        return ctx.getDirection().getOriginationSide() == LogicalSide.SERVER && ctx.getDirection().getReceptionSide() == LogicalSide.CLIENT;
    }

    public static boolean isPacketToServer(NetworkEvent.Context ctx) {
        return ctx.getDirection().getOriginationSide() == LogicalSide.CLIENT && ctx.getDirection().getReceptionSide() == LogicalSide.SERVER;
    }

    @Nonnull
    public static <T extends IForgeRegistryEntry> T getDefaultNotNull() {
        return null;
    }
}

