/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.gui;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import ovh.corail.recycler.gui.SlotRecycler;
import ovh.corail.recycler.recipe.RecyclingManager;
import ovh.corail.recycler.recipe.RecyclingRecipe;
import ovh.corail.recycler.registry.ModContainers;

public class ContainerRecyclingBook
extends Container {
    private final IIntArray recyclingBookData;
    private int pageNum = 0;
    private int pageMax = 0;
    private int[] recipe_flags = new int[4];
    private final ItemStackHandler BOOK_INVENTORY = new ItemStackHandler(40);
    private String searchText = "";

    protected ContainerRecyclingBook(ContainerType<? extends ContainerRecyclingBook> containerType, int windowId, PlayerInventory playerInventory) {
        super(containerType, windowId);
        this.recyclingBookData = new RecyclingBookData();
        this.func_216961_a(this.recyclingBookData);
        this.initSlots();
        if (!playerInventory.field_70458_d.field_70170_p.field_72995_K) {
            this.initPage(0);
        }
    }

    public ContainerRecyclingBook(int windowId, PlayerInventory playerInventory) {
        this(ModContainers.RECYCLING_BOOK, windowId, playerInventory);
    }

    public void initPage(int pageNum) {
        NonNullList<RecyclingRecipe> recipes = RecyclingManager.instance.getRecipesForSearch(this.searchText);
        this.setPageMax(recipes.size() / 4);
        this.setPageNum(MathHelper.func_76125_a((int)pageNum, (int)0, (int)this.getPageMax()));
        int skipped = this.getPageNum() * 4;
        int slotId = 0;
        int recipeIdMax = Math.min(skipped + 4, recipes.size());
        for (int recipeId = skipped; recipeId < recipeIdMax; ++recipeId) {
            RecyclingRecipe recipe = (RecyclingRecipe)recipes.get(recipeId);
            this.recyclingBookData.func_221477_a(recipeId - skipped, (recipe.isUserDefined() ? 1 : 0) + (recipe.isUnbalanced() ? 2 : 0) + (!recipe.isAllowed() ? 4 : 0));
            this.BOOK_INVENTORY.setStackInSlot(slotId++, recipe.getItemRecipe().asItemStack());
            for (int i = 0; i < 9; ++i) {
                this.BOOK_INVENTORY.setStackInSlot(slotId++, i < recipe.getCount() ? recipe.getResult(i).asItemStack() : ItemStack.field_190927_a);
            }
        }
        while (slotId < 40) {
            this.BOOK_INVENTORY.setStackInSlot(slotId++, ItemStack.field_190927_a);
        }
    }

    public void updateSearchText(String searchText) {
        this.searchText = searchText;
        this.initPage(0);
    }

    public int getPageNum() {
        return this.recyclingBookData.func_221476_a(4);
    }

    public void setPageNum(int num) {
        this.recyclingBookData.func_221477_a(4, num);
    }

    public int getPageMax() {
        return this.recyclingBookData.func_221476_a(5);
    }

    public void setPageMax(int num) {
        this.recyclingBookData.func_221477_a(5, num);
    }

    public boolean isUserDefinedRecipe(int recipeSquareNum) {
        return (this.recyclingBookData.func_221476_a(recipeSquareNum) & 1) != 0;
    }

    public boolean isUnbalancedRecipe(int recipeSquareNum) {
        return (this.recyclingBookData.func_221476_a(recipeSquareNum) & 2) != 0;
    }

    public boolean isBlacklistRecipe(int recipeSquareNum) {
        return (this.recyclingBookData.func_221476_a(recipeSquareNum) & 4) != 0;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    private void initSlots() {
        int slotId = 0;
        for (int j = 0; j < 2; ++j) {
            int startX = 40;
            int startY = 15 + j * 16 * 3 + 8 * j;
            for (int i = 0; i < 2; ++i) {
                this.func_75146_a((Slot)new SlotRecycler((IItemHandler)this.BOOK_INVENTORY, slotId++, startX, startY + 16, p -> false, false));
                startX += 21;
                for (int caseY = 0; caseY < 3; ++caseY) {
                    for (int caseX = 0; caseX < 3; ++caseX) {
                        this.func_75146_a((Slot)new SlotRecycler((IItemHandler)this.BOOK_INVENTORY, slotId++, startX + caseX * 16, startY + caseY * 16, p -> false, false));
                    }
                }
                startX = 140;
            }
        }
    }

    public class RecyclingBookData
    implements IIntArray {
        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return ContainerRecyclingBook.this.recipe_flags[0];
                }
                case 1: {
                    return ContainerRecyclingBook.this.recipe_flags[1];
                }
                case 2: {
                    return ContainerRecyclingBook.this.recipe_flags[2];
                }
                case 3: {
                    return ContainerRecyclingBook.this.recipe_flags[3];
                }
                case 4: {
                    return ContainerRecyclingBook.this.pageNum;
                }
                case 5: {
                    return ContainerRecyclingBook.this.pageMax;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    ((ContainerRecyclingBook)ContainerRecyclingBook.this).recipe_flags[0] = value;
                    break;
                }
                case 1: {
                    ((ContainerRecyclingBook)ContainerRecyclingBook.this).recipe_flags[1] = value;
                    break;
                }
                case 2: {
                    ((ContainerRecyclingBook)ContainerRecyclingBook.this).recipe_flags[2] = value;
                    break;
                }
                case 3: {
                    ((ContainerRecyclingBook)ContainerRecyclingBook.this).recipe_flags[3] = value;
                    break;
                }
                case 4: {
                    ContainerRecyclingBook.this.pageNum = value;
                    break;
                }
                case 5: {
                    ContainerRecyclingBook.this.pageMax = value;
                    break;
                }
            }
        }

        public int func_221478_a() {
            return 6;
        }
    }
}

