/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import ovh.corail.recycler.gui.ContainerRecyclingBook;
import ovh.corail.recycler.registry.ModTriggers;
import ovh.corail.recycler.util.Helper;

public class ServerRecyclingBookMessage {
    private final RecyclingBookAction action;
    private int pageNum;
    private String searchText;

    public ServerRecyclingBookMessage(RecyclingBookAction action, Object ... params) {
        this.action = action;
        if (action == RecyclingBookAction.CHANGE_PAGE) {
            this.pageNum = params.length == 1 ? (Integer)params[0] : 0;
        } else if (action == RecyclingBookAction.SEARCH_TEXT) {
            this.searchText = params.length == 1 ? String.valueOf(params[0]) : "";
        }
    }

    static ServerRecyclingBookMessage fromBytes(PacketBuffer buf) {
        RecyclingBookAction currentAction = RecyclingBookAction.values()[buf.readShort()];
        switch (currentAction) {
            case CHANGE_PAGE: {
                return new ServerRecyclingBookMessage(currentAction, buf.readInt());
            }
            case SEARCH_TEXT: {
                return new ServerRecyclingBookMessage(currentAction, buf.func_150789_c(20));
            }
        }
        return new ServerRecyclingBookMessage(currentAction, new Object[0]);
    }

    static void toBytes(ServerRecyclingBookMessage msg, PacketBuffer buf) {
        buf.writeShort(msg.action.ordinal());
        if (msg.action == RecyclingBookAction.CHANGE_PAGE) {
            buf.writeInt(msg.pageNum);
        } else if (msg.action == RecyclingBookAction.SEARCH_TEXT) {
            buf.func_180714_a(msg.searchText);
        }
    }

    static class Handler {
        Handler() {
        }

        static void handle(ServerRecyclingBookMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToServer(ctx)) {
                ctx.enqueueWork(() -> {
                    ServerPlayerEntity player = ctx.getSender();
                    if (player != null) {
                        switch (message.action) {
                            case RECYCLING_BOOK: {
                                ModTriggers.READ_RECYCLING_BOOK.trigger(player);
                                NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new INamedContainerProvider(){

                                    public ITextComponent func_145748_c_() {
                                        return new TranslationTextComponent("corail_recycler.message.recycling_book", new Object[0]);
                                    }

                                    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
                                        return new ContainerRecyclingBook(windowId, playerInventory);
                                    }
                                });
                                break;
                            }
                            case CHANGE_PAGE: {
                                if (!(player.field_71070_bA instanceof ContainerRecyclingBook)) break;
                                ((ContainerRecyclingBook)player.field_71070_bA).initPage(message.pageNum);
                                break;
                            }
                            case SEARCH_TEXT: {
                                if (!(player.field_71070_bA instanceof ContainerRecyclingBook)) break;
                                ((ContainerRecyclingBook)player.field_71070_bA).updateSearchText(message.searchText);
                            }
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }

    public static enum RecyclingBookAction {
        RECYCLING_BOOK,
        CHANGE_PAGE,
        SEARCH_TEXT;

    }
}

