/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.network;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.recycler.config.ConfigRecycler;
import ovh.corail.recycler.util.Helper;

public class UpdateConfigMessage {
    public final boolean unbalanced_recipes;
    public final boolean allow_automation;

    public UpdateConfigMessage(boolean unbalanced_recipes, boolean allow_automation) {
        this.unbalanced_recipes = unbalanced_recipes;
        this.allow_automation = allow_automation;
    }

    static UpdateConfigMessage fromBytes(PacketBuffer buf) {
        return new UpdateConfigMessage(buf.readBoolean(), buf.readBoolean());
    }

    static void toBytes(UpdateConfigMessage msg, PacketBuffer buf) {
        buf.writeBoolean(msg.unbalanced_recipes);
        buf.writeBoolean(msg.allow_automation);
    }

    static class Handler {
        Handler() {
        }

        static void handle(UpdateConfigMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(() -> ConfigRecycler.updateConfig(message));
            }
            ctx.setPacketHandled(true);
        }
    }
}

