/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.recipe;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.ImmutablePair;
import ovh.corail.recycler.ModRecycler;
import ovh.corail.recycler.config.ConfigRecycler;
import ovh.corail.recycler.recipe.JsonRecyclingRecipe;
import ovh.corail.recycler.recipe.RecipeLoaderHelper;
import ovh.corail.recycler.recipe.RecyclingRecipe;
import ovh.corail.recycler.recipe.SimpleStack;
import ovh.corail.recycler.registry.ModBlocks;
import ovh.corail.recycler.registry.ModItems;
import ovh.corail.recycler.util.Helper;

public class RecyclingManager {
    public static final RecyclingManager instance = new RecyclingManager();
    private final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private final NonNullList<RecyclingRecipe> recipes = NonNullList.func_191196_a();
    private final Set<SimpleStack> unbalanced = new HashSet<SimpleStack>();
    private final Set<SimpleStack> blacklist = new HashSet<SimpleStack>();
    private final NonNullList<ImmutablePair<SimpleStack, SimpleStack>> grindList = NonNullList.func_191196_a();
    public final File CONFIG_DIR = new File(FMLPaths.CONFIGDIR.get().toFile(), "corail_recycler");
    private final File unbalancedFile = new File(this.CONFIG_DIR, "unbalanced_recipes.json");
    private final File blacklistFile = new File(this.CONFIG_DIR, "blacklist_recipes.json");
    private final File userDefinedFile = new File(this.CONFIG_DIR, "user_defined_recipes.json");
    private final File grindFile = new File(this.CONFIG_DIR, "grind_list.json");

    private RecyclingManager() {
        if (!this.CONFIG_DIR.exists() && !this.CONFIG_DIR.mkdir()) {
            ModRecycler.LOGGER.warn("Impossible to create the config folder");
        }
    }

    public boolean discoverRecipe(ServerWorld world, ItemStack stack) {
        RecyclingRecipe recipe = this.getRecipe(stack, false);
        if (recipe != null) {
            return this.setAllowedRecipe(recipe, true) || (Boolean)ConfigRecycler.shared_general.unbalanced_recipes.get() == false && this.setUnbalancedRecipe(recipe, false);
        }
        recipe = world.func_199532_z().func_215366_a(IRecipeType.field_222149_a).values().stream().filter(craftingRecipe -> Helper.areItemEqual(craftingRecipe.func_77571_b(), stack) && Helper.isValidRecipe((IRecipe<CraftingInventory>)craftingRecipe)).map(this::convertCraftingRecipe).findFirst().orElse(null);
        if (Helper.isValidRecipe(recipe)) {
            this.recipes.add((Object)recipe);
            return this.saveUserDefinedRecipes();
        }
        return false;
    }

    public void loadRecipes() {
        this.clear();
        if (((Boolean)ConfigRecycler.general.recycle_enchanted_book.get()).booleanValue()) {
            this.recipes.add((Object)new RecyclingRecipe(new SimpleStack(Items.field_151134_bR), new SimpleStack[0]));
        }
        this.loadUnbalanced();
        this.loadBlacklist();
        RecipeLoaderHelper.loadDefaultRecipes(this.recipes);
        this.loadUserDefinedRecipes();
        this.loadGrindList();
    }

    public int getRecipeCount() {
        return this.recipes.size();
    }

    private void clear() {
        this.recipes.clear();
        this.unbalanced.clear();
        this.blacklist.clear();
        this.grindList.clear();
    }

    private void loadUnbalanced() {
        if (!this.unbalancedFile.exists()) {
            this.addToCollection(this.unbalanced, Blocks.field_196650_c);
            this.addToCollection(this.unbalanced, Blocks.field_196654_e);
            this.addToCollection(this.unbalanced, Blocks.field_196656_g);
            this.addToCollection(this.unbalanced, Items.field_151121_aF);
            this.addToCollection(this.unbalanced, Items.field_151102_aT);
            this.addToCollection(this.unbalanced, Items.field_151061_bv);
            this.addToCollection(this.unbalanced, Items.field_151065_br);
            this.addToCollection(this.unbalanced, Items.field_151064_bs);
            this.addToCollection(this.unbalanced, Items.field_151059_bz);
            this.addToCollection(this.unbalanced, Blocks.field_196817_hS);
            this.addToCollection(this.unbalanced, Blocks.field_196814_hQ);
            this.addToCollection(this.unbalanced, Blocks.field_196650_c);
            this.saveUnbalanced();
        } else {
            this.loadAsJson(this.unbalancedFile, String.class).forEach(jsonString -> {
                SimpleStack currentStack = SimpleStack.fromJson(jsonString);
                if (!currentStack.isEmpty()) {
                    this.unbalanced.add(currentStack);
                }
            });
        }
    }

    private void loadBlacklist() {
        if (!this.blacklistFile.exists()) {
            this.addToCollection(this.blacklist, ModBlocks.recycler);
            this.saveBlacklist();
        } else {
            this.loadAsJson(this.blacklistFile, String.class).forEach(jsonString -> {
                SimpleStack currentStack = SimpleStack.fromJson(jsonString);
                if (!currentStack.isEmpty()) {
                    this.blacklist.add(currentStack);
                }
            });
        }
    }

    private void saveBlacklist() {
        this.saveAsJson(this.blacklistFile, this.blacklist.stream().map(SimpleStack::toString).collect(Collectors.toCollection(NonNullList::func_191196_a)));
    }

    public boolean isAllowedRecipe(RecyclingRecipe recipe) {
        return this.blacklist.stream().noneMatch(stack -> SimpleStack.areItemEqual(stack, recipe.getItemRecipe()));
    }

    public boolean setAllowedRecipe(RecyclingRecipe recipe, boolean state) {
        boolean allowed = this.isAllowedRecipe(recipe);
        recipe.setAllowed(state);
        if (state != allowed) {
            if (allowed) {
                this.blacklist.add(recipe.getItemRecipe());
            } else {
                this.blacklist.remove(recipe.getItemRecipe());
            }
            this.saveBlacklist();
            return true;
        }
        return false;
    }

    private void saveUnbalanced() {
        this.saveAsJson(this.unbalancedFile, this.unbalanced.stream().map(SimpleStack::toString).collect(Collectors.toCollection(NonNullList::func_191196_a)));
    }

    public boolean isUnbalancedRecipe(RecyclingRecipe recipe) {
        return this.unbalanced.stream().anyMatch(stack -> SimpleStack.areItemEqual(stack, recipe.getItemRecipe()));
    }

    public boolean setUnbalancedRecipe(RecyclingRecipe recipe, boolean state) {
        boolean allowed = this.isUnbalancedRecipe(recipe);
        recipe.setUnbalanced(state);
        if (state != allowed) {
            if (allowed) {
                this.unbalanced.remove(recipe.getItemRecipe());
            } else {
                this.unbalanced.add(recipe.getItemRecipe());
            }
            this.saveUnbalanced();
            return true;
        }
        return false;
    }

    public RecyclingManager addRecipe(RecyclingRecipe recipe) {
        this.recipes.add((Object)recipe);
        return this;
    }

    public boolean removeRecipe(ItemStack stack) {
        RecyclingRecipe recipe = this.getRecipe(stack, false);
        if (recipe == null) {
            return false;
        }
        if (recipe.isUserDefined()) {
            this.recipes.remove((Object)recipe);
            this.saveUserDefinedRecipes();
            return true;
        }
        this.setAllowedRecipe(recipe, false);
        this.setUnbalancedRecipe(recipe, false);
        return true;
    }

    public NonNullList<RecyclingRecipe> getRecipesForSearch(String searchText) {
        return this.recipes.stream().filter(recipe -> !(!searchText.isEmpty() && !recipe.getItemRecipe().getTranslation().contains(searchText) || (Boolean)ConfigRecycler.general.only_user_recipes.get() != false && !recipe.isUserDefined())).collect(Collectors.toCollection(NonNullList::func_191196_a));
    }

    @Nullable
    public RecyclingRecipe getRecipe(ItemStack stack) {
        return this.getRecipe(stack, true);
    }

    @Nullable
    public RecyclingRecipe getRecipe(ItemStack stack, boolean checked) {
        if (stack.func_190926_b() || checked && stack.func_77973_b() == Items.field_151134_bR && EnchantedBookItem.func_92110_g((ItemStack)stack).size() < 2) {
            return null;
        }
        RecyclingRecipe recipe = this.recipes.stream().filter(recipeIn -> recipeIn.getItemRecipe().isItemEqual(stack)).findFirst().orElse(null);
        if (recipe == null) {
            return null;
        }
        if (checked) {
            if (!((Boolean)ConfigRecycler.shared_general.unbalanced_recipes.get()).booleanValue() && recipe.isUnbalanced()) {
                return null;
            }
            if (((Boolean)ConfigRecycler.general.only_user_recipes.get()).booleanValue() && !recipe.isUserDefined()) {
                return null;
            }
            if (!recipe.isAllowed()) {
                return null;
            }
        }
        return recipe;
    }

    private int getRecipeIndex(SimpleStack stack) {
        return stack.isEmpty() ? -1 : IntStream.range(0, this.recipes.size()).filter(slotId -> SimpleStack.areItemEqual(((RecyclingRecipe)this.recipes.get(slotId)).getItemRecipe(), stack)).findFirst().orElse(-1);
    }

    public NonNullList<ItemStack> getResultStack(ItemStack stack, int nb_input) {
        return this.getResultStack(stack, nb_input, false);
    }

    public NonNullList<ItemStack> getResultStack(ItemStack stack, int nb_input, boolean half) {
        NonNullList itemsList = NonNullList.func_191196_a();
        RecyclingRecipe currentRecipe = this.getRecipe(stack);
        if (currentRecipe == null) {
            return itemsList;
        }
        boolean isDamagedStack = stack.func_77958_k() > 0 && stack.func_77952_i() > 0;
        for (int i = 0; i < currentRecipe.getCount(); ++i) {
            int leftStackCount;
            int currentSize;
            ItemStack currentStack;
            ItemStack grind;
            ItemStack itemStack = grind = isDamagedStack || half ? this.getGrind(currentRecipe.getResult(i)).asItemStack() : ItemStack.field_190927_a;
            if (grind.func_190926_b()) {
                currentStack = currentRecipe.getResult(i).asItemStack();
                currentSize = currentStack.func_190916_E();
            } else {
                currentStack = grind;
                currentSize = currentRecipe.getResult(i).getCount() * grind.func_190916_E();
            }
            float modifiedSize = currentSize;
            if (isDamagedStack) {
                modifiedSize = modifiedSize * (float)(stack.func_77958_k() - stack.func_77952_i()) / (float)stack.func_77958_k();
            }
            if (half) {
                modifiedSize /= 2.0f;
            }
            currentStack.func_190920_e(currentStack.func_77976_d());
            for (leftStackCount = currentSize = (int)((Boolean)ConfigRecycler.general.recycle_round_down.get() != false ? Math.floor(modifiedSize) : (double)Math.round(modifiedSize)) * nb_input; leftStackCount >= currentStack.func_77976_d(); leftStackCount -= currentStack.func_77976_d()) {
                itemsList.add((Object)currentStack.func_77946_l());
            }
            if (leftStackCount <= 0) continue;
            currentStack.func_190920_e(leftStackCount);
            itemsList.add((Object)currentStack.func_77946_l());
        }
        if (((Boolean)ConfigRecycler.general.recycle_magic_item.get()).booleanValue()) {
            itemsList.addAll(this.getEnchantedBooks(stack));
        }
        return itemsList;
    }

    private NonNullList<ItemStack> getEnchantedBooks(ItemStack stack) {
        Map<Enchantment, Integer> enchants = EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet().stream().filter(p -> p.getKey() != null && p.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        NonNullList books = NonNullList.func_191196_a();
        if (!enchants.isEmpty()) {
            if (stack.func_77973_b() == Items.field_151134_bR) {
                if (enchants.size() < 2) {
                    return books;
                }
                for (Map.Entry<Enchantment, Integer> entry : enchants.entrySet()) {
                    ItemStack currentBook = new ItemStack((IItemProvider)Items.field_151134_bR);
                    EnchantedBookItem.func_92115_a((ItemStack)currentBook, (EnchantmentData)new EnchantmentData(entry.getKey(), entry.getValue().intValue()));
                    books.add((Object)currentBook);
                }
            } else {
                ItemStack currentBook = new ItemStack((IItemProvider)Items.field_151134_bR);
                for (Map.Entry<Enchantment, Integer> entry : enchants.entrySet()) {
                    EnchantedBookItem.func_92115_a((ItemStack)currentBook, (EnchantmentData)new EnchantmentData(entry.getKey(), entry.getValue().intValue()));
                }
                books.add((Object)currentBook);
            }
        }
        return books;
    }

    private void loadGrindList() {
        if (!this.grindFile.exists()) {
            this.grindList.add((Object)new ImmutablePair((Object)new SimpleStack(Items.field_151045_i), (Object)new SimpleStack(ModItems.diamond_shard, 9)));
            this.grindList.add((Object)new ImmutablePair((Object)new SimpleStack(Items.field_151042_j), (Object)new SimpleStack(Items.field_191525_da, 9)));
            this.grindList.add((Object)new ImmutablePair((Object)new SimpleStack(Items.field_151043_k), (Object)new SimpleStack(Items.field_151074_bl, 9)));
            this.grindList.add((Object)new ImmutablePair((Object)new SimpleStack(Items.field_151116_aA), (Object)new SimpleStack(Items.field_179555_bs, 4)));
            this.grindList.add((Object)new ImmutablePair((Object)new SimpleStack(Blocks.field_196662_n), (Object)new SimpleStack(Items.field_151055_y, 4)));
            this.saveAsJson(this.grindFile, this.grindList.stream().map(p -> new ImmutablePair((Object)((SimpleStack)p.getLeft()).toString(), (Object)((SimpleStack)p.getRight()).toString())).collect(Collectors.toCollection(NonNullList::func_191196_a)));
        } else {
            Type token = new TypeToken<NonNullList<ImmutablePair<String, String>>>(){}.getType();
            NonNullList<?> jsonStringList = this.loadAsJson(this.grindFile, token);
            for (ImmutablePair pair : jsonStringList) {
                SimpleStack input = SimpleStack.fromJson((String)pair.getLeft());
                SimpleStack output = SimpleStack.fromJson((String)pair.getRight());
                if (input.isEmpty() || output.isEmpty()) continue;
                this.grindList.add((Object)new ImmutablePair((Object)input, (Object)output));
            }
        }
    }

    private SimpleStack getGrind(SimpleStack stack) {
        return this.grindList.stream().filter(grind -> SimpleStack.areItemEqual((SimpleStack)grind.getLeft(), stack)).map(ImmutablePair::getRight).findFirst().orElse(SimpleStack.EMPTY);
    }

    public boolean saveUserDefinedRecipes() {
        return this.saveAsJson(this.userDefinedFile, this.recipes.stream().filter(recipe -> recipe.isUserDefined() && Helper.isValidRecipe(recipe)).map(JsonRecyclingRecipe::new).collect(Collectors.toCollection(NonNullList::func_191196_a)));
    }

    public boolean saveAsJson(File file, NonNullList list) {
        if (file.exists() && !file.delete()) {
            ModRecycler.LOGGER.warn("can't delete file " + file.getName());
        }
        try {
            if (file.createNewFile()) {
                FileWriter fw = new FileWriter(file);
                fw.write(this.GSON.toJson((Object)list));
                fw.close();
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private NonNullList<?> loadAsJson(File file, Type token) {
        NonNullList list = NonNullList.func_191196_a();
        try {
            list = (NonNullList)new Gson().fromJson((Reader)new BufferedReader(new FileReader(file)), token);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private <T> NonNullList<T> loadAsJson(File file, Class<T> type) {
        NonNullList list = NonNullList.func_191196_a();
        try {
            JsonArray arrayDatas = new JsonParser().parse((Reader)new BufferedReader(new FileReader(file))).getAsJsonArray();
            for (JsonElement elem : arrayDatas) {
                list.add(this.GSON.fromJson(elem, type));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private void loadUserDefinedRecipes() {
        NonNullList<JsonRecyclingRecipe> jsonRecipesList;
        if (!this.userDefinedFile.exists()) {
            jsonRecipesList = NonNullList.func_191196_a();
            jsonRecipesList.add((Object)new JsonRecyclingRecipe("corail_recycler:recycler:1", new String[]{"minecraft:acacia_planks:4", "minecraft:iron_ingot:4", "minecraft:chest:1"}));
            this.saveAsJson(this.userDefinedFile, jsonRecipesList);
        } else {
            jsonRecipesList = this.loadAsJson(this.userDefinedFile, JsonRecyclingRecipe.class);
        }
        for (JsonRecyclingRecipe aJsonRecipesList : jsonRecipesList) {
            RecyclingRecipe recipe = this.convertJsonRecipe(aJsonRecipesList);
            if (recipe != null && recipe.getCount() > 0) {
                int foundRecipe = this.getRecipeIndex(recipe.getItemRecipe());
                recipe.setUserDefined(true);
                if (foundRecipe == -1) {
                    this.recipes.add((Object)recipe);
                    continue;
                }
                this.recipes.set(foundRecipe, (Object)recipe);
                continue;
            }
            ModRecycler.LOGGER.warn("Error while reading json recipe : " + aJsonRecipesList.inputItem);
        }
    }

    @Nullable
    private RecyclingRecipe convertJsonRecipe(JsonRecyclingRecipe jRecipe) {
        SimpleStack inputItem = SimpleStack.fromJson(jRecipe.inputItem);
        if (inputItem.isEmpty()) {
            return null;
        }
        RecyclingRecipe recipe = new RecyclingRecipe(inputItem);
        Arrays.stream(jRecipe.outputItems).map(SimpleStack::fromJson).filter(outputItem -> !outputItem.isEmpty()).forEach(recipe::addStack);
        return recipe;
    }

    private void addToCollection(Collection<SimpleStack> list, @Nullable Block block) {
        if (block != null) {
            this.addToCollection(list, block.func_199767_j());
        }
    }

    private void addToCollection(Collection<SimpleStack> list, @Nullable Item item) {
        if (item != null && item.getRegistryName() != null) {
            list.add(new SimpleStack(item));
        }
    }

    public RecyclingRecipe convertCraftingRecipe(IRecipe iRecipe) {
        NonNullList ingredients = iRecipe.func_192400_c();
        NonNullList<ItemStack> stacks = Helper.mergeStackInList((NonNullList<ItemStack>)ingredients.stream().filter(p -> p.func_193365_a().length > 0 && !p.func_193365_a()[0].func_190926_b()).map(m -> m.func_193365_a()[0].func_77946_l()).collect(Collectors.toCollection(NonNullList::func_191196_a)));
        RecyclingRecipe recipe = new RecyclingRecipe(new SimpleStack(iRecipe.func_77571_b()), (NonNullList<SimpleStack>)stacks.stream().map(SimpleStack::new).collect(Collectors.toCollection(NonNullList::func_191196_a)));
        recipe.setUserDefined(true);
        return recipe;
    }
}

