/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.recipe;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class SimpleStack {
    public static final SimpleStack EMPTY = new SimpleStack(ItemStack.field_190927_a);
    private final Item item;
    private final int count;
    private String translation = null;

    public SimpleStack(ItemStack stack) {
        this(stack.func_77973_b(), stack.func_190916_E());
    }

    public SimpleStack(@Nullable Item item, int count) {
        if (item != null) {
            this.item = item;
            this.count = count;
        } else {
            this.item = Items.field_190931_a;
            this.count = 1;
        }
    }

    public SimpleStack(Item item) {
        this(item, 1);
    }

    public SimpleStack(Block block, int count) {
        this(block.func_199767_j(), count);
    }

    public SimpleStack(Block block) {
        this(block, 1);
    }

    public Item getItem() {
        return this.item;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.item == null || this.item == Items.field_190931_a;
    }

    public ItemStack asItemStack() {
        return new ItemStack((IItemProvider)this.item, this.count);
    }

    public String getTranslation() {
        if (this.translation == null) {
            this.translation = new TranslationTextComponent(this.item.func_77658_a(), new Object[0]).func_150254_d().toLowerCase();
        }
        return this.translation;
    }

    public String toString() {
        ResourceLocation rl = this.item.getRegistryName();
        assert (rl != null);
        return rl.toString() + ":" + this.count;
    }

    public boolean isItemEqual(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == this.item;
    }

    public static SimpleStack fromJson(String jsonString) {
        Item item;
        String[] parts = jsonString.split(":");
        if ((parts.length == 2 || parts.length == 3) && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parts[0], parts[1]))) != null) {
            return new SimpleStack(item, parts.length == 3 ? Integer.valueOf(parts[2]) : 1);
        }
        return new SimpleStack(ItemStack.field_190927_a);
    }

    public static boolean areItemEqual(SimpleStack s1, SimpleStack s2) {
        return !s1.isEmpty() && s1.item == s2.item;
    }
}

