/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.tileentity;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.INameable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import ovh.corail.recycler.block.BlockRecycler;
import ovh.corail.recycler.capability.RecyclerWorkingStackHandler;
import ovh.corail.recycler.config.ConfigRecycler;
import ovh.corail.recycler.recipe.RecyclingManager;
import ovh.corail.recycler.recipe.RecyclingRecipe;
import ovh.corail.recycler.registry.ModSounds;
import ovh.corail.recycler.registry.ModTileEntityTypes;
import ovh.corail.recycler.util.Helper;
import ovh.corail.recycler.util.LangKey;

public class TileEntityRecycler
extends TileEntity
implements ITickableTileEntity,
INameable {
    private final ItemStackHandler inventInput = new ItemStackHandler(18);
    private final ItemStackHandler inventWorking = new RecyclerWorkingStackHandler();
    private final ItemStackHandler inventOutput = new ItemStackHandler(18);
    private final ItemStackHandler inventVisual = new ItemStackHandler(9);
    private final EnergyStorage energyStorage = new EnergyStorage(10000, 20, 10);
    private RecyclingRecipe lastRecipe = null;
    private String customName;
    private boolean isWorking = false;
    private int countTicks = 0;
    private int progress = 0;
    private int inputMax = 0;
    private int cantRecycleTicks = 0;

    public TileEntityRecycler() {
        super(ModTileEntityTypes.RECYCLER);
    }

    public ItemStackHandler getInventoryInput() {
        return this.inventInput;
    }

    public ItemStackHandler getInventoryWorking() {
        return this.inventWorking;
    }

    public ItemStackHandler getInventoryOutput() {
        return this.inventOutput;
    }

    public ItemStackHandler getInventoryVisual() {
        return this.inventVisual;
    }

    public boolean isOutputEmpty() {
        return IntStream.range(0, this.inventOutput.getSlots()).allMatch(slot -> this.inventOutput.getStackInSlot(slot).func_190926_b());
    }

    private void transferSlotWorking() {
        ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventOutput, (ItemStack)this.inventWorking.extractItem(0, this.inventWorking.getStackInSlot(0).func_190916_E(), false), (boolean)false);
    }

    public boolean recycle(@Nullable ServerPlayerEntity player) {
        int maxDiskUse;
        assert (this.field_145850_b != null);
        RecyclingManager recyclingManager = RecyclingManager.instance;
        ItemStack workingStack = this.inventWorking.getStackInSlot(0);
        ItemStack diskStack = this.inventWorking.getStackInSlot(1);
        if (workingStack.func_190926_b() || diskStack.func_190926_b()) {
            return false;
        }
        RecyclingRecipe recipe = recyclingManager.getRecipe(workingStack);
        if (recipe == null) {
            this.transferSlotWorking();
            return false;
        }
        int nb_input = workingStack.func_190916_E() / Math.max(recipe.getItemRecipe().getCount(), 1);
        if (nb_input == 0) {
            return false;
        }
        if (this.isWorking) {
            nb_input = 1;
        }
        if ((maxDiskUse = (diskStack.func_77958_k() - diskStack.func_77952_i()) / 10) < nb_input) {
            nb_input = maxDiskUse;
        }
        int loss = 0;
        if ((Integer)ConfigRecycler.general.chance_loss.get() > 0) {
            for (int i = 0; i < nb_input; ++i) {
                if (Helper.getRandom(1, 100) > (Integer)ConfigRecycler.general.chance_loss.get()) continue;
                ++loss;
            }
            if (loss > 0) {
                LangKey.MESSAGE_LOSS.sendMessage((PlayerEntity)player, new Object[0]);
            }
        }
        NonNullList result = NonNullList.func_191196_a();
        int noLossCount = nb_input - loss;
        if (noLossCount > 0) {
            result.addAll(recyclingManager.getResultStack(workingStack, noLossCount));
        }
        if (loss > 0) {
            result.addAll(recyclingManager.getResultStack(workingStack, loss, true));
        }
        Helper.mergeStackInList((NonNullList<ItemStack>)result);
        if (!Helper.canInsertInInventory((IItemHandlerModifiable)this.inventOutput, (NonNullList<ItemStack>)result)) {
            LangKey.MESSAGE_NOT_ENOUGH_OUTPUT_SLOTS.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        result.forEach(stack -> ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventOutput, (ItemStack)stack, (boolean)false));
        this.inventWorking.getStackInSlot(0).func_190918_g(nb_input * recipe.getItemRecipe().getCount());
        int diskDamage = 10 * nb_input;
        if (diskStack.func_77952_i() + diskDamage >= diskStack.func_77958_k()) {
            LangKey.MESSAGE_BROKEN_DISK.sendMessage((PlayerEntity)player, new Object[0]);
            this.inventWorking.setStackInSlot(1, ItemStack.field_190927_a);
        } else {
            this.inventWorking.getStackInSlot(1).func_196085_b(diskStack.func_77952_i() + diskDamage);
        }
        ModSounds.playSoundAllAround(ModSounds.RECYCLER, SoundCategory.BLOCKS, this.field_145850_b, this.field_174879_c, 0.5f, 0.5f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f);
        if (this.inventWorking.getStackInSlot(0).func_190926_b()) {
            this.updateRecyclingRecipe();
        }
        return true;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (Helper.atInterval(this.field_145850_b, 10)) {
            int slotId;
            ItemStack stackToRecycle = this.inventWorking.getStackInSlot(0);
            boolean requireRecipeUpdate = false;
            if (stackToRecycle.func_190926_b()) {
                slotId = IntStream.range(0, this.inventInput.getSlots()).filter(slot -> {
                    ItemStack stackInSlot = this.inventInput.getStackInSlot(slot);
                    return !stackInSlot.func_190926_b() && this.inventWorking.isItemValid(0, stackInSlot);
                }).findFirst().orElse(-1);
                if (slotId >= 0) {
                    this.inventWorking.insertItem(0, this.inventInput.extractItem(slotId, this.inventInput.getStackInSlot(slotId).func_190916_E(), false), false);
                    requireRecipeUpdate = true;
                }
            } else if (stackToRecycle.func_77985_e() && stackToRecycle.func_190916_E() < stackToRecycle.func_77976_d() && (slotId = IntStream.range(0, this.inventInput.getSlots()).filter(slot -> Helper.areItemEqual(stackToRecycle, this.inventInput.getStackInSlot(slot))).findFirst().orElse(-1)) >= 0) {
                this.inventWorking.insertItem(0, this.inventInput.extractItem(slotId, 1, false), false);
                requireRecipeUpdate = true;
            }
            if (this.inventWorking.getStackInSlot(1).func_190926_b() && (slotId = IntStream.range(0, this.inventInput.getSlots()).filter(slot -> this.inventWorking.isItemValid(1, this.inventInput.getStackInSlot(slot))).findFirst().orElse(-1)) >= 0) {
                this.inventWorking.insertItem(1, this.inventInput.extractItem(slotId, 1, false), false);
                requireRecipeUpdate = true;
            }
            if (requireRecipeUpdate) {
                this.updateRecyclingRecipe();
            }
        }
        RecyclingRecipe baseRecipe = this.lastRecipe != null && this.lastRecipe.getItemRecipe().getItem() == this.inventWorking.getStackInSlot(0).func_77973_b() ? this.lastRecipe : (this.lastRecipe = RecyclingManager.instance.getRecipe(this.inventWorking.getStackInSlot(0)));
        int n = this.inputMax = baseRecipe != null ? this.inventWorking.getStackInSlot(0).func_190916_E() / baseRecipe.getItemRecipe().getCount() : 0;
        if (this.inputMax > 0) {
            this.inputMax = Math.min(this.inputMax, (this.inventWorking.getStackInSlot(1).func_77958_k() - this.inventWorking.getStackInSlot(1).func_77952_i()) / 10);
        }
        if (!this.isWorking) {
            return;
        }
        if (!((Boolean)ConfigRecycler.shared_general.allow_automation.get()).booleanValue()) {
            this.updateWorking(false);
            return;
        }
        if (this.energyStorage.getEnergyStored() >= 10) {
            this.energyStorage.extractEnergy(10, false);
            this.countTicks -= 2;
        } else {
            --this.countTicks;
        }
        int maxTicks = (Integer)ConfigRecycler.general.time_to_recycle.get();
        if (this.inputMax < 1) {
            ++this.cantRecycleTicks;
            this.countTicks = maxTicks;
        }
        if (this.cantRecycleTicks > 40) {
            if (!this.inventWorking.getStackInSlot(0).func_190926_b()) {
                this.transferSlotWorking();
            }
            this.updateWorking(false);
            this.cantRecycleTicks = 0;
            this.countTicks = maxTicks;
        }
        if (this.countTicks <= 0) {
            if (!this.recycle(null)) {
                ++this.cantRecycleTicks;
            }
            this.countTicks = maxTicks;
        } else if (this.cantRecycleTicks <= 1 && Helper.atInterval(this.countTicks, 15)) {
            ModSounds.playSoundAllAround(ModSounds.RECYCLER_WORKING, SoundCategory.BLOCKS, this.field_145850_b, this.field_174879_c, 0.5f, 0.5f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f);
            for (int i = 0; i < 4; ++i) {
                this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)this.field_174879_c.func_177958_n() + Helper.random.nextDouble(), (double)this.field_174879_c.func_177956_o() + Helper.random.nextDouble(), (double)this.field_174879_c.func_177952_p() + Helper.random.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
        this.progress = (maxTicks - this.countTicks) * 100 / maxTicks;
    }

    public void updateRecyclingRecipe() {
        int slotId;
        RecyclingRecipe recipe = RecyclingManager.instance.getRecipe(this.getInventoryWorking().getStackInSlot(0));
        boolean hasRecipe = recipe != null;
        NonNullList<ItemStack> currentRecipe = hasRecipe ? RecyclingManager.instance.getResultStack(this.getInventoryWorking().getStackInSlot(0), 1) : NonNullList.func_191196_a();
        if (hasRecipe) {
            for (slotId = 0; slotId < Math.min(currentRecipe.size(), this.inventVisual.getSlots()); ++slotId) {
                if (((ItemStack)currentRecipe.get(slotId)).func_77973_b() == this.inventVisual.getStackInSlot(slotId).func_77973_b()) continue;
                this.inventVisual.setStackInSlot(slotId, (ItemStack)currentRecipe.get(slotId));
            }
        }
        while (slotId < this.inventVisual.getSlots()) {
            if (!this.inventVisual.getStackInSlot(slotId).func_190926_b()) {
                this.inventVisual.setStackInSlot(slotId, ItemStack.field_190927_a);
            }
            ++slotId;
        }
        this.progress = 0;
        int n = this.inputMax = hasRecipe ? this.inventWorking.getStackInSlot(0).func_190916_E() / recipe.getItemRecipe().getCount() : 0;
        if (this.inputMax > 0) {
            this.inputMax = Math.min(this.inputMax, (this.inventWorking.getStackInSlot(1).func_77958_k() - this.inventWorking.getStackInSlot(1).func_77952_i()) / 10);
        }
    }

    public void switchWorking() {
        this.updateWorking(!this.isWorking);
    }

    public void updateWorking(boolean isWorking) {
        this.setProgress(0);
        if (isWorking != this.isWorking) {
            this.isWorking = isWorking;
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)BlockRecycler.ENABLED, (Comparable)Boolean.valueOf(isWorking)));
        }
    }

    public void setProgress(int progress) {
        if (progress == 0) {
            this.countTicks = (Integer)ConfigRecycler.general.time_to_recycle.get();
        }
        this.progress = progress;
    }

    public ITextComponent func_200200_C_() {
        return new TranslationTextComponent("corail_recyclerblock.recycler.name", new Object[0]);
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TranslationTextComponent(this.customName, new Object[0]) : this.func_200200_C_();
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.func_145818_k_() ? new TranslationTextComponent(this.customName, new Object[0]) : null;
    }

    public int getMaxEnergy() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == Direction.DOWN) {
                return LazyOptional.of(() -> this.inventOutput);
            }
            return LazyOptional.of(() -> this.inventInput);
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this.energyStorage);
        }
        return super.getCapability(cap, side);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeShareDatas(compound);
        compound.func_218657_a("invent_input", (INBT)this.inventInput.serializeNBT());
        compound.func_218657_a("invent_working", (INBT)this.inventWorking.serializeNBT());
        compound.func_218657_a("invent_output", (INBT)this.inventOutput.serializeNBT());
        return compound;
    }

    private CompoundNBT writeShareDatas(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.func_145818_k_()) {
            compound.func_74778_a("custom_name", this.customName);
        }
        compound.func_74768_a("countTicks", this.countTicks);
        compound.func_74757_a("isWorking", this.isWorking);
        compound.func_74768_a("progress", this.progress);
        compound.func_74768_a("cantRecycleTicks", this.cantRecycleTicks);
        INBT nbt = CapabilityEnergy.ENERGY.writeNBT((Object)this.energyStorage, null);
        if (nbt != null) {
            compound.func_218657_a("energy", nbt);
        }
        return compound;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.inventInput.deserializeNBT(compound.func_74775_l("invent_input"));
        this.inventWorking.deserializeNBT(compound.func_74775_l("invent_working"));
        this.inventOutput.deserializeNBT(compound.func_74775_l("invent_output"));
        if (compound.func_150297_b("custom_name", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        this.countTicks = compound.func_74762_e("countTicks");
        this.isWorking = compound.func_74767_n("isWorking");
        this.progress = compound.func_74762_e("progress");
        this.cantRecycleTicks = compound.func_74762_e("cantRecycleTicks");
        CapabilityEnergy.ENERGY.readNBT((Object)this.energyStorage, null, compound.func_74781_a("energy"));
    }

    public CompoundNBT func_189517_E_() {
        return this.writeShareDatas(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public class TrackedData
    implements IIntArray {
        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return TileEntityRecycler.this.isWorking ? 1 : 0;
                }
                case 1: {
                    return TileEntityRecycler.this.progress;
                }
                case 2: {
                    return TileEntityRecycler.this.inputMax;
                }
                case 3: {
                    return TileEntityRecycler.this.energyStorage.getEnergyStored();
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityRecycler.this.isWorking = value > 0;
                    break;
                }
                case 1: {
                    TileEntityRecycler.this.progress = value;
                    break;
                }
                case 2: {
                    TileEntityRecycler.this.inputMax = value;
                    break;
                }
                case 3: {
                    int diff = value - TileEntityRecycler.this.energyStorage.getEnergyStored();
                    if (diff >= 0) {
                        TileEntityRecycler.this.energyStorage.receiveEnergy(diff, false);
                        break;
                    }
                    TileEntityRecycler.this.energyStorage.extractEnergy(-diff, false);
                    break;
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    }
}

