/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.recycler.block;

import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;
import org.cursegame.minecraft.recycler.gui.ContainerRecycler;
import org.cursegame.minecraft.recycler.tileentity.TileEntityRecycler;
import org.cursegame.minecraft.recycler.util.Helper;

public class BlockRecycler
extends Block {
    private static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty ENABLED = BooleanProperty.func_177716_a((String)"enabled");

    public BlockRecycler() {
        this(BlockRecycler.getBuilder());
    }

    protected BlockRecycler(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    public String func_149739_a() {
        return "corail_recycler_ne.block.recycler";
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (Helper.isValidPlayer(player) && !player.func_175149_v()) {
            TileEntityRecycler recycler;
            if (!world.field_72995_K && (recycler = BlockRecycler.getTileEntity(world, pos)) != null && recycler.canInteract(player)) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public ITextComponent func_145748_c_() {
                        return new TranslationTextComponent("corail_recycler_ne.block.recycler");
                    }

                    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
                        return new ContainerRecycler(windowId, playerInventory, recycler);
                    }
                }, buf -> buf.func_179255_a(pos));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void func_196243_a(BlockState oldState, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntityRecycler recycler;
        if (oldState.func_177230_c() != newState.func_177230_c() && (recycler = BlockRecycler.getTileEntity(world, pos)) != null) {
            IntStream.range(0, recycler.getInventoryInput().getSlots()).forEach(slot -> InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)recycler.getInventoryInput().getStackInSlot(slot)));
            IntStream.range(0, recycler.getInventoryWorking().getSlots()).forEach(slot -> InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)recycler.getInventoryWorking().getStackInSlot(slot)));
            IntStream.range(0, recycler.getInventoryOutput().getSlots()).forEach(slot -> InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)recycler.getInventoryOutput().getStackInSlot(slot)));
            world.func_175713_t(pos);
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            BlockState newState = (BlockState)state.func_206870_a((Property)FACING, (Comparable)entity.func_174811_aO().func_176734_d());
            world.func_175656_a(pos, newState);
        }
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)ENABLED) != false ? 15 : 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, ENABLED});
    }

    @Nullable
    public static TileEntityRecycler getTileEntity(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityRecycler ? (TileEntityRecycler)tile : null;
    }

    public TileEntityRecycler createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityRecycler();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public static AbstractBlock.Properties getBuilder() {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(3.0f, 3.0f).func_200947_a(SoundType.field_185848_a).harvestTool(ToolType.AXE).harvestLevel(0);
    }
}

