/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.recycler.capability;

import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraftforge.items.ItemStackHandler;
import org.cursegame.minecraft.recycler.registry.ModTags;

public class RecyclerWorkingStackHandler
extends ItemStackHandler {
    public RecyclerWorkingStackHandler() {
        super(EnumSlot.values().length);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return EnumSlot.isItemValid(slot, stack);
    }

    public static enum EnumSlot {
        DISK(new Predicate<ItemStack>(){

            @Override
            public boolean test(ItemStack p) {
                return p.func_77973_b().func_206844_a(ModTags.Items.disks);
            }
        }),
        BOOK(new Predicate<ItemStack>(){

            @Override
            public boolean test(ItemStack p) {
                return p.func_77973_b().equals(Items.field_151122_aG);
            }
        }),
        BULB(new Predicate<ItemStack>(){

            @Override
            public boolean test(ItemStack p) {
                return p.func_77973_b().equals(Items.field_151069_bo) || p.func_77973_b().equals(Items.field_185156_bI);
            }
        });

        public final Predicate<ItemStack> predic;

        private EnumSlot(Predicate<ItemStack> predic) {
            this.predic = predic;
        }

        public static boolean isItemValid(int slot, ItemStack stack) {
            return (slot == 0 || slot == 1 || slot == 2) && EnumSlot.values()[slot].predic.test(stack);
        }
    }
}

