/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.recycler.gui;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.cursegame.minecraft.recycler.capability.RecyclerWorkingStackHandler;
import org.cursegame.minecraft.recycler.gui.SlotRecycler;
import org.cursegame.minecraft.recycler.gui.SlotWorking;
import org.cursegame.minecraft.recycler.registry.ModContainers;
import org.cursegame.minecraft.recycler.tileentity.TileEntityRecycler;

public class ContainerRecycler
extends Container {
    private final TileEntityRecycler recycler;
    private final IIntArray recyclerData;
    int clickSlotId;
    long clickSlotTimestamp;
    long clickSlotDelay = 300L;
    private int diskSlot;
    private int bookSlot;
    private int bulbSlot;
    private int iIndex;
    private int oIndex;
    private int vIndex;
    private int pIndex;

    protected ContainerRecycler(ContainerType<? extends ContainerRecycler> containerType, int windowId, PlayerInventory playerInventory, TileEntityRecycler recycler) {
        super(containerType, windowId);
        this.recycler = recycler;
        this.recyclerData = new TileEntityRecycler.TrackedData(recycler);
        this.func_216961_a(this.recyclerData);
        this.addSlots(playerInventory);
        if (!playerInventory.field_70458_d.field_70170_p.field_72995_K) {
            this.recycler.engage(playerInventory.field_70458_d);
            this.recycler.updateRecyclingRecipeFromPlayerRecipeBook(playerInventory.field_70458_d);
            this.recycler.requestUpdateRecyclingRecipe();
        }
    }

    public ContainerRecycler(int windowId, PlayerInventory playerInventory, TileEntityRecycler recycler) {
        this(ModContainers.RECYCLER, windowId, playerInventory, recycler);
    }

    public ContainerRecycler(int windowId, PlayerInventory playerInventory, BlockPos pos) {
        this(windowId, playerInventory, (TileEntityRecycler)playerInventory.field_70458_d.field_70170_p.func_175625_s(pos));
    }

    public ContainerRecycler(int windowId, PlayerInventory playerInventory, PacketBuffer data) {
        this(windowId, playerInventory, data.func_179259_c());
    }

    public BlockPos getPosition() {
        return this.recycler.func_174877_v();
    }

    public TileEntityRecycler getRecycler() {
        return this.recycler;
    }

    public Slot getItemSlot() {
        return (Slot)this.field_75151_b.get(this.iIndex);
    }

    public Slot getDiskSlot() {
        return (Slot)this.field_75151_b.get(this.diskSlot);
    }

    public Slot getBookSlot() {
        return (Slot)this.field_75151_b.get(this.bookSlot);
    }

    public Slot getBulbSlot() {
        return (Slot)this.field_75151_b.get(this.bulbSlot);
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.getRecycler().canInteract(player);
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        if (!playerIn.field_70170_p.field_72995_K) {
            this.getRecycler().disarm(playerIn);
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        if (this.clickSlotTimestamp < System.currentTimeMillis() - this.clickSlotDelay) {
            this.clickSlotId = slotId;
        }
        this.clickSlotTimestamp = System.currentTimeMillis();
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if ((this.clickSlotId >= 0 && this.clickSlotId < this.iIndex && index >= 0 && index < this.iIndex || this.clickSlotId >= this.iIndex && this.clickSlotId < this.oIndex && index >= this.iIndex && index < this.oIndex || this.clickSlotId >= this.oIndex && this.clickSlotId < this.pIndex && index >= this.oIndex && index < this.pIndex) && !this.func_75135_a(itemstack1, this.pIndex, this.vIndex, true)) {
                return ItemStack.field_190927_a;
            }
            if (this.clickSlotId >= this.pIndex && this.clickSlotId < this.vIndex && index >= this.pIndex && index < this.vIndex && !this.func_75135_a(itemstack1, 0, this.iIndex, false) && !this.func_75135_a(itemstack1, this.iIndex, this.oIndex, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
        }
        return itemstack;
    }

    private void addSlots(PlayerInventory playerInventory) {
        int x;
        int y;
        int x2;
        int y2;
        int index = 0;
        this.diskSlot = index++;
        this.func_75146_a((Slot)new SlotWorking(this, this.diskSlot, 90, 91, RecyclerWorkingStackHandler.EnumSlot.DISK.predic));
        this.bookSlot = index++;
        this.func_75146_a((Slot)new SlotWorking(this, this.bookSlot, 68, 91, RecyclerWorkingStackHandler.EnumSlot.BOOK.predic));
        this.bulbSlot = index++;
        this.func_75146_a((Slot)new SlotWorking(this, this.bulbSlot, 68, 69, RecyclerWorkingStackHandler.EnumSlot.BULB.predic));
        this.iIndex = index;
        this.func_75146_a((Slot)new SlotRecycler((IItemHandler)this.recycler.getInventoryInput(), index++ - this.iIndex, 90, 69));
        for (y2 = 0; y2 < 6; ++y2) {
            for (x2 = 0; x2 < 3; ++x2) {
                this.func_75146_a((Slot)new SlotRecycler((IItemHandler)this.recycler.getInventoryInput(), index++ - this.iIndex, x2 * 18 + 7, y2 * 18 + 8));
            }
        }
        this.oIndex = index;
        for (y2 = 0; y2 < 6; ++y2) {
            for (x2 = 0; x2 < 3; ++x2) {
                this.func_75146_a((Slot)new SlotRecycler((IItemHandler)this.recycler.getInventoryOutput(), index++ - this.oIndex, x2 * 18 + 173, y2 * 18 + 8));
            }
        }
        InvWrapper inventPlayer = new InvWrapper((IInventory)playerInventory);
        this.pIndex = index;
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 9; ++x) {
                this.func_75146_a((Slot)new SlotRecycler((IItemHandler)inventPlayer, index++ - this.pIndex, x * 18 + 7, y == 0 ? 178 : y * 18 + 102));
            }
        }
        this.vIndex = index;
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                this.func_75146_a((Slot)new SlotRecycler((IItemHandler)this.recycler.getInventoryVisual(), index++ - this.vIndex, x * 18 + 115, y * 18 + 8, p -> false, false));
            }
        }
    }
}

