/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.recycler.gui;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.cursegame.minecraft.recycler.gui.SlotRecycler;
import org.cursegame.minecraft.recycler.recipe.RecipeHolder;
import org.cursegame.minecraft.recycler.recipe.RecyclingManager;
import org.cursegame.minecraft.recycler.recipe.RecyclingRecipe;
import org.cursegame.minecraft.recycler.registry.ModContainers;

public class ContainerRecyclingBook
extends Container {
    public static final int SLOT_SIZE = 18;
    private final IIntArray recyclingBookData;
    private final ItemStackHandler inventory = new ItemStackHandler(40);
    private int pageNum = 0;
    private int pageMax = 0;
    private int[] recipe_flags = new int[4];
    private String searchText = "";
    private Map<Item, RecipeHolder> recipes = new LinkedHashMap<Item, RecipeHolder>();

    protected ContainerRecyclingBook(ContainerType<? extends ContainerRecyclingBook> containerType, int windowId, PlayerInventory playerInventory) {
        super(containerType, windowId);
        this.recyclingBookData = new RecyclingBookData();
        this.func_216961_a(this.recyclingBookData);
        this.initSlots();
        if (!playerInventory.field_70458_d.field_70170_p.field_72995_K) {
            RecyclingManager.getInstance().updateRecyclingRecipeFromPlayerRecipeBook(playerInventory.field_70458_d, this.recipes);
            this.initPage(0);
        }
    }

    public ContainerRecyclingBook(int windowId, PlayerInventory playerInventory) {
        this(ModContainers.RECYCLING_BOOK, windowId, playerInventory);
    }

    public void initPage(int pageNum) {
        NonNullList<RecyclingRecipe> recipes = RecyclingManager.getRecipesForSearch(this.recipes, this.searchText);
        this.setPageMax(recipes.size() / 4);
        this.setPageNum(MathHelper.func_76125_a((int)pageNum, (int)0, (int)this.getPageMax()));
        int slotId = 0;
        int recipeCount = Math.min(4, recipes.size() - this.getPageNum() * 4);
        for (int recipeIndex = 0; recipeIndex < recipeCount; ++recipeIndex) {
            RecyclingRecipe recipe = (RecyclingRecipe)recipes.get(this.getPageNum() * 4 + recipeIndex);
            this.setRecipeDisabled(recipeIndex, recipe.isRecipeDisabled());
            this.inventory.setStackInSlot(slotId++, recipe.getItemRecipe().toItemStack());
            for (int i = 0; i < 9; ++i) {
                this.inventory.setStackInSlot(slotId++, i < recipe.getResult().size() ? recipe.getResult(i).toItemStack() : ItemStack.field_190927_a);
            }
        }
        while (slotId < 40) {
            this.inventory.setStackInSlot(slotId++, ItemStack.field_190927_a);
        }
    }

    public void updateSearchText(String searchText) {
        this.searchText = searchText;
        this.initPage(0);
    }

    public int getPageNum() {
        return this.recyclingBookData.func_221476_a(4);
    }

    public void setPageNum(int num) {
        this.recyclingBookData.func_221477_a(4, num);
    }

    public int getPageMax() {
        return this.recyclingBookData.func_221476_a(5);
    }

    public void setPageMax(int num) {
        this.recyclingBookData.func_221477_a(5, num);
    }

    public boolean isRecipeDisabled(int recipeIndex) {
        if (recipeIndex < 0 || recipeIndex >= 4) {
            throw new IndexOutOfBoundsException();
        }
        return (this.recyclingBookData.func_221476_a(recipeIndex) & 2) == 2;
    }

    public void setRecipeDisabled(int recipeIndex, boolean b) {
        if (recipeIndex < 0 || recipeIndex >= 4) {
            throw new IndexOutOfBoundsException();
        }
        if (b) {
            this.recyclingBookData.func_221477_a(recipeIndex, this.recyclingBookData.func_221476_a(recipeIndex) | 2);
        } else {
            this.recyclingBookData.func_221477_a(recipeIndex, this.recyclingBookData.func_221476_a(recipeIndex) & 0xFFFFFFFD);
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    private void initSlots() {
        int slotId = 0;
        for (int j = 0; j < 2; ++j) {
            int startX = 42;
            int startY = 19 + j * 18 * 3 + 10 * j;
            for (int i = 0; i < 2; ++i) {
                this.func_75146_a((Slot)new SlotRecycler((IItemHandler)this.inventory, slotId++, startX, startY + 18, p -> false, false));
                startX += 23;
                for (int caseY = 0; caseY < 3; ++caseY) {
                    for (int caseX = 0; caseX < 3; ++caseX) {
                        this.func_75146_a((Slot)new SlotRecycler((IItemHandler)this.inventory, slotId++, startX + caseX * 18, startY + caseY * 18, p -> false, false));
                    }
                }
                startX = 137;
            }
        }
    }

    public class RecyclingBookData
    implements IIntArray {
        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return ContainerRecyclingBook.this.recipe_flags[0];
                }
                case 1: {
                    return ContainerRecyclingBook.this.recipe_flags[1];
                }
                case 2: {
                    return ContainerRecyclingBook.this.recipe_flags[2];
                }
                case 3: {
                    return ContainerRecyclingBook.this.recipe_flags[3];
                }
                case 4: {
                    return ContainerRecyclingBook.this.pageNum;
                }
                case 5: {
                    return ContainerRecyclingBook.this.pageMax;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    ((ContainerRecyclingBook)ContainerRecyclingBook.this).recipe_flags[0] = value;
                    break;
                }
                case 1: {
                    ((ContainerRecyclingBook)ContainerRecyclingBook.this).recipe_flags[1] = value;
                    break;
                }
                case 2: {
                    ((ContainerRecyclingBook)ContainerRecyclingBook.this).recipe_flags[2] = value;
                    break;
                }
                case 3: {
                    ((ContainerRecyclingBook)ContainerRecyclingBook.this).recipe_flags[3] = value;
                    break;
                }
                case 4: {
                    ContainerRecyclingBook.this.pageNum = value;
                    break;
                }
                case 5: {
                    ContainerRecyclingBook.this.pageMax = value;
                }
            }
        }

        public int func_221478_a() {
            return 6;
        }
    }
}

