/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.recycler.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cursegame.minecraft.recycler.ConfigRecycler;
import org.cursegame.minecraft.recycler.gui.ButtonNext;
import org.cursegame.minecraft.recycler.gui.ButtonRecycler;
import org.cursegame.minecraft.recycler.gui.ContainerRecycler;
import org.cursegame.minecraft.recycler.gui.SlotRecycler;
import org.cursegame.minecraft.recycler.network.PacketHandler;
import org.cursegame.minecraft.recycler.network.ServerRecyclerMessage;
import org.cursegame.minecraft.recycler.network.ServerRecyclingBookMessage;
import org.cursegame.minecraft.recycler.tileentity.TileEntityRecycler;
import org.cursegame.minecraft.recycler.util.LangKey;

@OnlyIn(value=Dist.CLIENT)
public class GuiRecycler
extends ContainerScreen<ContainerRecycler> {
    private static final ResourceLocation TEXTURE_RECYCLER = new ResourceLocation("corail_recycler_ne", "textures/gui/recycler.png");
    private final ResourceLocation TEXTURE_BAR = new ResourceLocation("textures/gui/bars.png");

    public GuiRecycler(ContainerRecycler container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_146999_f = 232;
        this.field_147000_g = 203;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.func_230480_a_((Widget)new ButtonRecycler(this.field_147003_i + 172, this.field_147009_r + 121, 55, 14, I18n.func_135052_a((String)LangKey.BUTTON_RECYLE.getKey(), (Object[])new Object[0]), pressable -> PacketHandler.sendToServer(new ServerRecyclerMessage(ServerRecyclerMessage.RecyclerAction.RECYCLE, ((ContainerRecycler)this.field_147002_h).getPosition()))));
        this.func_230480_a_((Widget)new ButtonRecycler(this.field_147003_i + 172, this.field_147009_r + 139, 55, 14, I18n.func_135052_a((String)LangKey.BUTTON_AUTO.getKey(), (Object[])new Object[0]), pressable -> PacketHandler.sendToServer(new ServerRecyclerMessage(ServerRecyclerMessage.RecyclerAction.TOGGLE_AUTO, ((ContainerRecycler)this.field_147002_h).getPosition())), ((ContainerRecycler)this.field_147002_h).getRecycler()::isStartedPermanently));
        this.func_230480_a_((Widget)new ButtonRecycler(this.field_147003_i + 172, this.field_147009_r + 157, 55, 14, I18n.func_135052_a((String)LangKey.BUTTON_TAKE_ALL.getKey(), (Object[])new Object[0]), pressable -> PacketHandler.sendToServer(new ServerRecyclerMessage(ServerRecyclerMessage.RecyclerAction.TAKE_ALL, ((ContainerRecycler)this.field_147002_h).getPosition()))));
        this.func_230480_a_((Widget)new ButtonRecycler(this.field_147003_i + 172, this.field_147009_r + 179, 55, 14, I18n.func_135052_a((String)LangKey.BUTTON_ENABLE_RECIPE.getKey(), (Object[])new Object[0]), pressable -> PacketHandler.sendToServer(new ServerRecyclerMessage(ServerRecyclerMessage.RecyclerAction.ENABLE_RECIPE, ((ContainerRecycler)this.field_147002_h).getPosition()))));
        this.func_230480_a_((Widget)new ButtonRecycler(this.field_147003_i + 172, this.field_147009_r + 179, 55, 14, I18n.func_135052_a((String)LangKey.BUTTON_REMOVE_RECIPE.getKey(), (Object[])new Object[0]), pressable -> PacketHandler.sendToServer(new ServerRecyclerMessage(ServerRecyclerMessage.RecyclerAction.REMOVE_RECIPE, ((ContainerRecycler)this.field_147002_h).getPosition()))));
        this.func_230480_a_((Widget)new ButtonNext(this.field_147003_i + 105, this.field_147009_r + 10, pressable -> PacketHandler.sendToServer(new ServerRecyclerMessage(ServerRecyclerMessage.RecyclerAction.BROWSE_RECIPE, ((ContainerRecycler)this.field_147002_h).getPosition()))));
        this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 149, this.field_147009_r + 67, 20, 18, 178, 0, 19, field_147001_a, pressable -> PacketHandler.sendToServer(new ServerRecyclingBookMessage(ServerRecyclingBookMessage.RecyclingBookAction.RECYCLING_BOOK, new Object[0]))));
    }

    protected void func_230450_a_(MatrixStack ms, float partialTicks, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        this.func_230446_a_(ms);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(TEXTURE_RECYCLER);
        this.func_238474_b_(ms, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (Slot slot : ((ContainerRecycler)this.func_212873_a_()).field_75151_b) {
            this.func_238474_b_(ms, this.field_147003_i + slot.field_75223_e - 1, this.field_147009_r + slot.field_75221_f - 1, 80, 203, 18, 18);
            if (!(slot instanceof SlotRecycler)) continue;
            SlotRecycler slotRecycler = (SlotRecycler)slot;
            if (slotRecycler.getItemHandler() == ((ContainerRecycler)this.func_212873_a_()).getRecycler().getInventoryVisual() && ((ContainerRecycler)this.func_212873_a_()).getRecycler().isRecipeDisabled()) {
                this.func_238474_b_(ms, this.field_147003_i + slot.field_75223_e - 1, this.field_147009_r + slot.field_75221_f - 1, 80, 238, 18, 18);
            }
            if (slotRecycler.getItemHandler() != ((ContainerRecycler)this.func_212873_a_()).getRecycler().getInventoryWorking()) continue;
            if (slot == ((ContainerRecycler)this.func_212873_a_()).getDiskSlot() && slot.func_75211_c().func_190926_b()) {
                this.func_238474_b_(ms, this.field_147003_i + slot.field_75223_e - 1, this.field_147009_r + slot.field_75221_f - 1, 170, 203, 18, 18);
            }
            if (slot == ((ContainerRecycler)this.func_212873_a_()).getBookSlot() && slot.func_75211_c().func_190926_b()) {
                this.func_238474_b_(ms, this.field_147003_i + slot.field_75223_e - 1, this.field_147009_r + slot.field_75221_f - 1, 190, 203, 18, 18);
            }
            if (slot != ((ContainerRecycler)this.func_212873_a_()).getBulbSlot() || !slot.func_75211_c().func_190926_b()) continue;
            this.func_238474_b_(ms, this.field_147003_i + slot.field_75223_e - 1, this.field_147009_r + slot.field_75221_f - 1, 210, 203, 18, 18);
        }
    }

    protected void func_230451_b_(MatrixStack ms, int mouseX, int mouseY) {
        Slot diskSlot;
        Minecraft mc = Minecraft.func_71410_x();
        int guiScale = mc.func_228018_at_().func_216521_a(mc.field_71474_y.field_74335_Z, mc.func_211821_e());
        int entityX = 86;
        int entityY = 50;
        InventoryScreen.func_228187_a_((int)entityX, (int)entityY, (int)20, (float)(2 * entityX - mouseX), (float)(entityY - mouseY), (LivingEntity)mc.field_71439_g);
        mc.func_110434_K().func_110577_a(TEXTURE_RECYCLER);
        TileEntityRecycler recycler = ((ContainerRecycler)this.field_147002_h).getRecycler();
        this.func_238474_b_(ms, 114, 79, 130, 203, 31, 18);
        if (recycler.isStarted() || recycler.isStartedPermanently()) {
            this.func_238474_b_(ms, 114, 79, 130, 221, recycler.getProgress() * 31 / 100, 18);
        }
        int tmp = 100 * recycler.getTemperature() / 256;
        mc.func_110434_K().func_110577_a(this.TEXTURE_BAR);
        GuiRecycler.func_238463_a_((MatrixStack)ms, (int)68, (int)112, (float)0.0f, (float)20.0f, (int)136, (int)3, (int)139, (int)256);
        GuiRecycler.func_238463_a_((MatrixStack)ms, (int)68, (int)112, (float)0.0f, (float)25.0f, (int)tmp, (int)2, (int)139, (int)256);
        GuiRecycler.func_238463_a_((MatrixStack)ms, (int)68, (int)112, (float)0.0f, (float)81.0f, (int)136, (int)3, (int)139, (int)256);
        RenderSystem.pushMatrix();
        float scale = mc.func_211821_e() ? (guiScale < 4 ? 1.0f : 0.5f) : (guiScale > 1 ? 0.5f : 1.0f);
        RenderSystem.scaled((double)scale, (double)scale, (double)scale);
        Slot itemSlot = ((ContainerRecycler)this.field_147002_h).getItemSlot();
        if (!itemSlot.func_75211_c().func_190926_b() && recycler.getRecipeItemInput() > 0) {
            this.field_230712_o_.func_238421_b_(ms, itemSlot.func_75211_c().func_190916_E() >= recycler.getRecipeItemInput() ? itemSlot.func_75211_c().func_190916_E() / recycler.getRecipeItemInput() + "" : itemSlot.func_75211_c().func_190916_E() + "/" + recycler.getRecipeItemInput(), (float)((int)((float)(itemSlot.field_75223_e + 20) / scale)), (float)((int)(((float)(itemSlot.field_75221_f + 8) - 4.0f * scale) / scale)), itemSlot.func_75211_c().func_190916_E() >= recycler.getRecipeItemInput() ? 65280 : 0xFF0000);
        }
        if (!(diskSlot = ((ContainerRecycler)this.field_147002_h).getDiskSlot()).func_75211_c().func_190926_b()) {
            int useLeft = diskSlot.func_75211_c().func_190926_b() ? 0 : diskSlot.func_75211_c().func_77958_k() - diskSlot.func_75211_c().func_77952_i();
            this.field_230712_o_.func_238421_b_(ms, useLeft + "", (float)((int)((float)(diskSlot.field_75223_e + 20) / scale)), (float)((int)(((float)(diskSlot.field_75221_f + 8) - 4.0f * scale) / scale)), useLeft > 0 ? 65280 : 0xFF0000);
        }
        RenderSystem.popMatrix();
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_195559_v.func_197967_a(false);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.updateButtons();
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    public boolean func_231177_au__() {
        return false;
    }

    private void updateButtons() {
        Minecraft minecraft = Minecraft.func_71410_x();
        TileEntityRecycler recycler = ((ContainerRecycler)this.field_147002_h).getRecycler();
        ItemStack diskStack = recycler.getDiskStack();
        boolean canProcess = true;
        if (recycler.getRecipeItemInput() == 0 || recycler.isRecipeAvailable() && recycler.isRecipeDisabled() || recycler.getRecipeDiskInput() > 0 && diskStack.func_190926_b()) {
            canProcess = false;
        }
        boolean canControl = !recycler.isStarted() && !recycler.isStartedPermanently();
        ((Widget)this.field_230710_m_.get((int)0)).field_230693_o_ = canProcess && canControl;
        ((Widget)this.field_230710_m_.get((int)1)).field_230694_p_ = ((Widget)this.field_230710_m_.get((int)1)).field_230693_o_ = ((Boolean)ConfigRecycler.general.allow_automation.get()).booleanValue();
        ((Widget)this.field_230710_m_.get((int)2)).field_230693_o_ = !IntStream.range(0, recycler.getInventoryOutput().getSlots()).allMatch(slot -> recycler.getInventoryOutput().getStackInSlot(slot).func_190926_b());
        ((Widget)this.field_230710_m_.get((int)3)).field_230693_o_ = minecraft.field_71439_g.func_195070_dx() && recycler.isRecipeAvailable() && recycler.isRecipeDisabled() && canControl;
        ((Widget)this.field_230710_m_.get((int)3)).field_230694_p_ = minecraft.field_71439_g.func_195070_dx() && recycler.isRecipeAvailable() && recycler.isRecipeDisabled() && canControl;
        ((Widget)this.field_230710_m_.get((int)4)).field_230693_o_ = minecraft.field_71439_g.func_195070_dx() && recycler.isRecipeAvailable() && !recycler.isRecipeDisabled() && canControl;
        ((Widget)this.field_230710_m_.get((int)4)).field_230694_p_ = minecraft.field_71439_g.func_195070_dx() && recycler.isRecipeAvailable() && !recycler.isRecipeDisabled() && canControl;
        ((Widget)this.field_230710_m_.get((int)5)).field_230693_o_ = recycler.isRecipeAmbiguous() && canControl;
        ((Widget)this.field_230710_m_.get((int)5)).field_230694_p_ = recycler.isRecipeAmbiguous() && recycler.isRecipeAvailable();
    }
}

