/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.recycler.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.cursegame.minecraft.recycler.gui.ButtonRecyclingBook;
import org.cursegame.minecraft.recycler.gui.ContainerRecyclingBook;
import org.cursegame.minecraft.recycler.network.PacketHandler;
import org.cursegame.minecraft.recycler.network.ServerRecyclingBookMessage;
import org.cursegame.minecraft.recycler.util.LangKey;

@OnlyIn(value=Dist.CLIENT)
public class GuiRecyclingBook
extends ContainerScreen<ContainerRecyclingBook> {
    private static final int SLOTS_PER_RECIPE = 10;
    private TextFieldWidget searchBox;
    private String lastText = "";
    private static final ResourceLocation TEXTURE_recycler = new ResourceLocation("corail_recycler_ne", "textures/gui/recycler.png");
    private static final ResourceLocation TEXTURE_RECYCLING_BOOK = new ResourceLocation("corail_recycler_ne", "textures/gui/book.png");
    private Rectangle2d[] recipeHints = new Rectangle2d[4];
    private long searchUpdated;

    public GuiRecyclingBook(ContainerRecyclingBook container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_146999_f = 250;
        this.field_147000_g = 156;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.func_230480_a_((Widget)new ButtonRecyclingBook(false, this.field_147003_i + 20, this.field_147009_r + this.field_147000_g, pressable -> {
            if (((ContainerRecyclingBook)this.field_147002_h).getPageNum() > 0) {
                PacketHandler.sendToServer(new ServerRecyclingBookMessage(ServerRecyclingBookMessage.RecyclingBookAction.CHANGE_PAGE, ((ContainerRecyclingBook)this.field_147002_h).getPageNum() - 1));
            }
        }));
        this.func_230480_a_((Widget)new ButtonRecyclingBook(true, this.field_147003_i + 208, this.field_147009_r + this.field_147000_g, pressable -> {
            if (((ContainerRecyclingBook)this.field_147002_h).getPageNum() < ((ContainerRecyclingBook)this.field_147002_h).getPageMax()) {
                PacketHandler.sendToServer(new ServerRecyclingBookMessage(ServerRecyclingBookMessage.RecyclingBookAction.CHANGE_PAGE, ((ContainerRecyclingBook)this.field_147002_h).getPageNum() + 1));
            }
        }));
        for (int recipeIndex = 0; recipeIndex < 4; ++recipeIndex) {
            Slot slot = (Slot)((ContainerRecyclingBook)this.func_212873_a_()).field_75151_b.get(recipeIndex * 10);
            int startPosX = this.field_147003_i + slot.field_75223_e;
            int startPosY = this.field_147009_r + slot.field_75221_f;
            this.recipeHints[recipeIndex] = new Rectangle2d(startPosX + 18 - 5 - 1, startPosY + 18, 5, 5);
        }
        this.searchBox = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 32, this.field_147009_r + this.field_147000_g + 2, 64, 12, (ITextComponent)new StringTextComponent("search"));
        this.func_230480_a_((Widget)this.searchBox);
        this.configureSearchBox();
    }

    private void configureSearchBox() {
        this.searchBox.func_146185_a(true);
        this.searchBox.func_146195_b(true);
        this.searchBox.func_146203_f(20);
        this.searchBox.func_146180_a("");
        this.searchBox.func_146205_d(false);
    }

    private void updateButton(int buttonNum, boolean state) {
        Widget button = (Widget)this.field_230710_m_.get(buttonNum);
        button.field_230693_o_ = button.field_230694_p_ = state;
    }

    private void updateButtons() {
        if (((ContainerRecyclingBook)this.field_147002_h).getPageNum() <= 0) {
            ((ContainerRecyclingBook)this.field_147002_h).setPageNum(0);
            this.updateButton(0, false);
            this.updateButton(1, ((ContainerRecyclingBook)this.field_147002_h).getPageMax() > 0);
        } else if (((ContainerRecyclingBook)this.field_147002_h).getPageNum() >= ((ContainerRecyclingBook)this.field_147002_h).getPageMax()) {
            ((ContainerRecyclingBook)this.field_147002_h).setPageNum(((ContainerRecyclingBook)this.field_147002_h).getPageMax());
            this.updateButton(0, true);
            this.updateButton(1, false);
        } else {
            this.updateButton(0, true);
            this.updateButton(1, true);
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int p_keyPressed_3_) {
        if (keyCode == 256) {
            return super.func_231046_a_(keyCode, scanCode, p_keyPressed_3_);
        }
        if (keyCode == 259) {
            String text = this.searchBox.func_146179_b();
            if (text.length() < 2) {
                this.searchBox.func_146180_a("");
            } else {
                this.searchBox.func_146180_a(text.substring(0, text.length() - 1));
            }
            return true;
        }
        return false;
    }

    public boolean func_231042_a_(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.searchBox.func_231042_a_(Character.toLowerCase(p_charTyped_1_), p_charTyped_2_)) {
            return true;
        }
        return super.func_231042_a_(p_charTyped_1_, p_charTyped_2_);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.searchUpdated > System.currentTimeMillis() - 500L) {
            return;
        }
        this.searchUpdated = System.currentTimeMillis();
        String currentText = this.searchBox.func_146179_b();
        if (!this.lastText.equals(currentText)) {
            this.lastText = currentText;
            PacketHandler.sendToServer(new ServerRecyclingBookMessage(ServerRecyclingBookMessage.RecyclingBookAction.SEARCH_TEXT, this.searchBox.func_146179_b().toLowerCase()));
        }
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.getMinecraft().field_195559_v.func_197967_a(false);
    }

    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        this.func_230459_a_(ms, mouseX, mouseY);
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected void func_230450_a_(MatrixStack ms, float partialTicks, int mouseX, int mouseY) {
        this.updateButtons();
        this.func_230446_a_(ms);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE_RECYCLING_BOOK);
        this.func_238474_b_(ms, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE_recycler);
        for (Slot slot : ((ContainerRecyclingBook)this.field_147002_h).field_75151_b) {
            int posX = this.field_147003_i + slot.field_75223_e - 1;
            int posY = this.field_147009_r + slot.field_75221_f - 1;
            int recipeIndex = slot.getSlotIndex() / 10;
            this.func_238474_b_(ms, posX, posY, 100, 203, 18, 18);
            if (((ContainerRecyclingBook)this.field_147002_h).isRecipeDisabled(recipeIndex)) {
                this.func_238474_b_(ms, posX, posY, 100, 238, 18, 18);
            }
            if (slot.getSlotIndex() % 10 != 0 || !((ContainerRecyclingBook)this.field_147002_h).isRecipeDisabled(recipeIndex)) continue;
            Rectangle2d pos = this.recipeHints[recipeIndex];
            GuiRecyclingBook.func_238467_a_((MatrixStack)ms, (int)pos.func_199318_a(), (int)pos.func_199319_b(), (int)(pos.func_199318_a() + pos.func_199316_c()), (int)(pos.func_199319_b() + pos.func_199317_d()), (int)-11530192);
        }
    }

    protected void func_230459_a_(MatrixStack ms, int mouseX, int mouseY) {
        for (int recipeId = 0; recipeId < 4; ++recipeId) {
            if (!this.recipeHints[recipeId].func_199315_b(mouseX, mouseY) || !((ContainerRecyclingBook)this.field_147002_h).isRecipeDisabled(recipeId)) continue;
            this.func_238652_a_(ms, (ITextComponent)LangKey.HINT_RECIPE_DISABLED.getTranslation(new Object[0]), mouseX, mouseY);
            break;
        }
        super.func_230459_a_(ms, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack ms, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        int guiScale = mc.func_228018_at_().func_216521_a(mc.field_71474_y.field_74335_Z, mc.func_211821_e());
        float fontScale = mc.func_211821_e() ? (guiScale < 4 ? 1.0f : 0.5f) : (guiScale > 1 ? 0.5f : 1.0f);
        RenderSystem.pushMatrix();
        RenderSystem.scaled((double)fontScale, (double)fontScale, (double)fontScale);
        IntStream.range(0, 4).boxed().map(i -> (Slot)((ContainerRecyclingBook)this.field_147002_h).field_75151_b.get(i * 10)).filter(s -> !s.func_75211_c().func_190926_b()).forEach(s -> {
            String text = s.func_75211_c().func_200301_q().getString();
            while ((float)this.field_230712_o_.func_78256_a(text) > 80.0f / fontScale) {
                text = StringUtils.abbreviate((String)text, (int)(text.length() - 1));
            }
            GuiRecyclingBook.func_238475_b_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent(text), (int)((int)(((float)s.field_75223_e - 2.0f * fontScale) / fontScale)), (int)((int)(((float)(s.field_75221_f - 18 - 7) - 4.0f * fontScale) / fontScale)), (int)13938487);
        });
        RenderSystem.popMatrix();
        String text = ((ContainerRecyclingBook)this.field_147002_h).getPageNum() + 1 + "/" + (((ContainerRecyclingBook)this.field_147002_h).getPageMax() + 1);
        this.field_230712_o_.func_238421_b_(ms, text, (float)(208 - this.field_230712_o_.func_78256_a(text)), (float)(this.field_147000_g + 6 - 1), 13938487);
        String title = TextFormatting.BOLD + I18n.func_135052_a((String)LangKey.MESSAGE_RECYCLING_BOOK.getKey(), (Object[])new Object[0]);
        this.field_230712_o_.func_243246_a(ms, (ITextComponent)new StringTextComponent(title), (float)(this.field_146999_f - this.field_230712_o_.func_78256_a(title)) / 2.0f, -10.0f, 13938487);
    }
}

