/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.recycler.item;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.BlockItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.TieredItem;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cursegame.minecraft.recycler.item.ItemGeneric;
import org.cursegame.minecraft.recycler.registry.ModTags;
import org.cursegame.minecraft.recycler.registry.ModTriggers;

public class ItemDisk
extends TieredItem {
    private final String name;
    private final ItemTier dust;
    private final ItemTier base;
    public static final Map<ArmorMaterial, Integer> ARMOR_HL = Maps.immutableEnumMap((Map)ImmutableMap.builder().put((Object)ArmorMaterial.LEATHER, (Object)0).put((Object)ArmorMaterial.GOLD, (Object)0).put((Object)ArmorMaterial.CHAIN, (Object)2).put((Object)ArmorMaterial.IRON, (Object)2).put((Object)ArmorMaterial.TURTLE, (Object)2).put((Object)ArmorMaterial.DIAMOND, (Object)3).put((Object)ArmorMaterial.NETHERITE, (Object)4).build());
    public static final Map<ItemTier, Integer> TIERED_HL = Maps.immutableEnumMap((Map)ImmutableMap.builder().put((Object)ItemTier.WOOD, (Object)0).put((Object)ItemTier.GOLD, (Object)0).put((Object)ItemTier.STONE, (Object)1).put((Object)ItemTier.IRON, (Object)2).put((Object)ItemTier.DIAMOND, (Object)3).put((Object)ItemTier.NETHERITE, (Object)4).build());

    public ItemDisk(String name, ItemTier dust, ItemTier base) {
        super((IItemTier)base, ItemDisk.createProperties(dust, base));
        this.name = name;
        this.dust = dust;
        this.base = base;
    }

    private static Item.Properties createProperties(ItemTier dust, ItemTier base) {
        return ItemGeneric.getBuilder().func_200915_b(base.func_200926_a() / 5);
    }

    public ITextComponent func_200296_o() {
        return new StringTextComponent(this.name);
    }

    public String func_77667_c(ItemStack stack) {
        return "corail_recycler_ne.item.disk_" + this.dust.ordinal();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        TranslationTextComponent textComponent = new TranslationTextComponent("corail_recycler_ne.item.base_" + this.base.ordinal());
        textComponent.func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240745_a_((String)"#7f7f7f")));
        tooltip.add((ITextComponent)textComponent);
    }

    public void func_77622_d(ItemStack stack, World world, PlayerEntity player) {
        if (world == null || world.field_72995_K) {
            return;
        }
        if (stack.func_77973_b().func_206844_a(ModTags.Items.disk_0)) {
            ModTriggers.BUILD_DISK_0.trigger(player);
        }
        if (stack.func_77973_b().func_206844_a(ModTags.Items.disk_1)) {
            ModTriggers.BUILD_DISK_1.trigger(player);
        }
        if (stack.func_77973_b().func_206844_a(ModTags.Items.disk_2)) {
            ModTriggers.BUILD_DISK_2.trigger(player);
        }
        if (stack.func_77973_b().func_206844_a(ModTags.Items.disk_3)) {
            ModTriggers.BUILD_DISK_3.trigger(player);
        }
        if (stack.func_77973_b().func_206844_a(ModTags.Items.disk_4)) {
            ModTriggers.BUILD_DISK_4.trigger(player);
        }
        if (stack.func_77973_b().func_206844_a(ModTags.Items.disk_5)) {
            ModTriggers.BUILD_DISK_5.trigger(player);
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.func_82781_a((ItemStack)book).entrySet().stream().anyMatch(p -> this.canApplyAtEnchantingTable(stack, (Enchantment)p.getKey()));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185307_s || enchantment == Enchantments.field_185308_t || enchantment == Enchantments.field_185296_A || enchantment == Enchantments.field_185305_q;
    }

    public boolean func_150897_b(BlockState blockIn) {
        return this.dust.func_200925_d() >= blockIn.getHarvestLevel();
    }

    public float getProcessingTimeFactor(ItemStack stack) {
        float factor = this.dust.func_200928_b();
        int boostLevel = EnchantmentHelper.func_82781_a((ItemStack)stack).getOrDefault(Enchantments.field_185305_q, 0);
        if (boostLevel > 0) {
            factor += (float)(boostLevel * boostLevel + 1);
        }
        return factor;
    }

    public boolean canGrind(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)itemStack.func_77973_b();
            return this.dust.func_200925_d() >= blockItem.func_179223_d().func_176223_P().getHarvestLevel();
        }
        if (itemStack.func_77973_b() instanceof TieredItem) {
            Integer h = TIERED_HL.getOrDefault(((TieredItem)itemStack.func_77973_b()).func_200891_e(), 0);
            return h - this.dust.func_200925_d() <= 1;
        }
        if (itemStack.func_77973_b() instanceof ArmorItem) {
            Integer h = ARMOR_HL.getOrDefault(((ArmorItem)itemStack.func_77973_b()).func_200880_d(), 0);
            return h - this.dust.func_200925_d() <= 1;
        }
        return true;
    }
}

