/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.recycler.network;

import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.cursegame.minecraft.recycler.block.BlockRecycler;
import org.cursegame.minecraft.recycler.recipe.RecipeHolder;
import org.cursegame.minecraft.recycler.recipe.RecyclingManager;
import org.cursegame.minecraft.recycler.tileentity.TileEntityRecycler;
import org.cursegame.minecraft.recycler.util.LangKey;

public class ServerRecyclerMessage {
    private final RecyclerAction action;
    private final BlockPos pos;

    public ServerRecyclerMessage(RecyclerAction action, BlockPos pos) {
        this.action = action;
        this.pos = pos;
    }

    static ServerRecyclerMessage fromBytes(PacketBuffer buf) {
        return new ServerRecyclerMessage(RecyclerAction.values()[buf.readShort()], buf.func_179259_c());
    }

    static void toBytes(ServerRecyclerMessage msg, PacketBuffer buf) {
        buf.writeShort(msg.action.ordinal());
        buf.func_179255_a(msg.pos);
    }

    static class Handler {
        Handler() {
        }

        static void handle(ServerRecyclerMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                TileEntityRecycler recycler;
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null && (recycler = BlockRecycler.getTileEntity(player.field_70170_p, message.pos)) != null) {
                    switch (message.action) {
                        case RECYCLE: {
                            recycler.setStarted(true);
                            break;
                        }
                        case TOGGLE_AUTO: {
                            recycler.setStartedPermanently(!recycler.isStartedPermanently());
                            break;
                        }
                        case TAKE_ALL: {
                            player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(p -> {
                                ItemStackHandler inventOutput = recycler.getInventoryOutput();
                                IntStream.range(0, inventOutput.getSlots()).filter(slot -> !inventOutput.getStackInSlot(slot).func_190926_b()).forEach(slot -> inventOutput.setStackInSlot(slot, ItemHandlerHelper.insertItemStacked((IItemHandler)p, (ItemStack)inventOutput.getStackInSlot(slot), (boolean)false)));
                            });
                            break;
                        }
                        case BROWSE_RECIPE: {
                            RecipeHolder recipeHolder;
                            ItemStack stack = recycler.getItemStack();
                            if (stack.func_190926_b() || (recipeHolder = recycler.getRecipeHolder(stack)) == null) break;
                            RecyclingManager.getInstance().browseRecipe(player, recipeHolder);
                            recycler.requestUpdateRecyclingRecipe();
                            break;
                        }
                        case ENABLE_RECIPE: {
                            RecipeHolder recipeHolder;
                            ItemStack stack = recycler.getItemStack();
                            if (!stack.func_190926_b() && (recipeHolder = recycler.getRecipeHolder(stack)) != null) {
                                RecyclingManager.getInstance().enableRecipe(recipeHolder);
                                recycler.requestUpdateRecyclingRecipe();
                                LangKey.MESSAGE_ADD_RECIPE_SUCCESS.sendMessage((PlayerEntity)player, new Object[0]);
                                break;
                            }
                            LangKey.MESSAGE_ADD_RECIPE_FAILURE.sendMessage((PlayerEntity)player, new Object[0]);
                            break;
                        }
                        case REMOVE_RECIPE: {
                            ItemStack stack = recycler.getItemStack();
                            if (!stack.func_190926_b()) {
                                RecipeHolder recipeHolder = recycler.getRecipeHolder(stack);
                                if (recipeHolder == null) break;
                                RecyclingManager.getInstance().disableRecipe(recipeHolder);
                                recycler.requestUpdateRecyclingRecipe();
                                LangKey.MESSAGE_REMOVE_RECIPE_SUCCESS.sendMessage((PlayerEntity)player, new Object[0]);
                                break;
                            }
                            LangKey.MESSAGE_REMOVE_RECIPE_FAILURE.sendMessage((PlayerEntity)player, new Object[0]);
                        }
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static enum RecyclerAction {
        RECYCLE,
        TOGGLE_AUTO,
        TAKE_ALL,
        BROWSE_RECIPE,
        ENABLE_RECIPE,
        REMOVE_RECIPE;

    }
}

