/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.recycler.recipe;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.ServerRecipeBook;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.time.StopWatch;
import org.cursegame.minecraft.recycler.ModRecycler;
import org.cursegame.minecraft.recycler.recipe.RecipeHolder;
import org.cursegame.minecraft.recycler.recipe.RecyclingRecipe;
import org.cursegame.minecraft.recycler.recipe.SimpleStack;
import org.cursegame.minecraft.recycler.registry.ModItems;
import org.cursegame.minecraft.recycler.util.Helper;

public class RecyclingManager {
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private static RecyclingManager instance;
    public final File CONFIG_DIR = new File(FMLPaths.CONFIGDIR.get().toFile(), "corail_recycler_ne");
    private final File baseRecipesFile = new File(this.CONFIG_DIR, "base_recipes.json");
    private final File disabledRecipesFile = new File(this.CONFIG_DIR, "disabled_recipes.json");
    private final File grindFile = new File(this.CONFIG_DIR, "grind_recipes.json");
    private RecipeManager recipeManager;
    private List<RecyclingRecipe> registeredRecipes = NonNullList.func_191196_a();
    private List<RecyclingRecipe> baseRecipes = NonNullList.func_191196_a();
    private Set<RecyclingRecipe> disabledRecipes = new LinkedHashSet<RecyclingRecipe>();
    private List<RecyclingRecipe> grindRecipes = NonNullList.func_191196_a();
    private static final Comparator<EffectInstance> C_EFFECT;

    public static RecyclingManager getInstance() {
        if (instance == null) {
            instance = new RecyclingManager();
        }
        return instance;
    }

    private RecyclingManager() {
    }

    public RecipeManager getRecipeManager() {
        if (this.recipeManager == null) {
            throw new IllegalStateException("Recycling manager isn't initialized");
        }
        return this.recipeManager;
    }

    public void initialize(RecipeManager recipeManager) {
        this.recipeManager = recipeManager;
        if (!this.CONFIG_DIR.exists() && !this.CONFIG_DIR.mkdir()) {
            ModRecycler.LOGGER.warn("Unable to create config folder {}", (Object)this.CONFIG_DIR);
        }
        this.loadBaseRecipes();
        this.loadRegisteredRecipes();
        this.loadDisabledRecipes();
        this.loadGrindList();
    }

    public List<RecyclingRecipe> getRegisteredRecipes() {
        return this.registeredRecipes;
    }

    private void loadRegisteredRecipes() {
        for (final IRecipe candidate : this.getRecipeManager().func_199510_b()) {
            if (!candidate.func_222127_g().equals(IRecipeType.field_222149_a)) continue;
            LinkedHashMap groups = new LinkedHashMap();
            candidate.func_192400_c().stream().filter(i -> i != Ingredient.field_193370_a).forEach(i -> groups.compute(new Group(i.func_193365_a()), (items, count) -> count == null ? 1 : count + 1));
            new BiConsumer<LinkedList<Map.Entry<Group, Integer>>, LinkedList<ItemStack>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(LinkedList<Map.Entry<Group, Integer>> entries, LinkedList<ItemStack> variant) {
                    if (entries.isEmpty()) {
                        if (variant.stream().allMatch(stack -> stack.func_77973_b() == candidate.func_77571_b().func_77973_b())) {
                            return;
                        }
                        RecyclingRecipe recyclingRecipe = new RecyclingRecipe(candidate.func_199560_c(), new SimpleStack(candidate.func_77571_b()));
                        variant.stream().map(SimpleStack::new).forEach(arg_0 -> recyclingRecipe.getResult().add(arg_0));
                        RecyclingManager.this.registeredRecipes.add(recyclingRecipe);
                    } else {
                        Map.Entry<Group, Integer> tail = entries.pollFirst();
                        try {
                            for (ItemStack item : tail.getKey().items) {
                                ItemStack itemStack = new ItemStack((IItemProvider)item.func_77973_b(), tail.getValue().intValue());
                                variant.addLast(itemStack);
                                try {
                                    this.accept(entries, variant);
                                }
                                finally {
                                    variant.removeLast();
                                }
                            }
                        }
                        finally {
                            entries.addFirst(tail);
                        }
                    }
                }
            }.accept(new LinkedList<Map.Entry<Group, Integer>>(groups.entrySet()), new LinkedList<ItemStack>());
        }
        HashMap simpleRecipes = new HashMap();
        this.registeredRecipes.forEach(r -> simpleRecipes.computeIfAbsent(r.getItemRecipe().getItem(), k -> new ArrayList()).add(r));
        HashSet candidateRecipes = new HashSet();
        this.registeredRecipes.forEach(r -> {
            if (r.getResult().size() == 1) {
                SimpleStack s = r.getResult(0);
                simpleRecipes.computeIfPresent(s.getItem(), (i, t) -> {
                    t.forEach(c -> {
                        if (c.getResult().size() == 1) {
                            SimpleStack a = c.getResult(0);
                            if (s.equals(c.getItemRecipe()) && a.equals(r.getItemRecipe())) {
                                candidateRecipes.add(r);
                                candidateRecipes.add(c);
                            }
                        }
                    });
                    return t;
                });
            }
        });
        this.registeredRecipes.removeIf(candidateRecipes::contains);
        ModRecycler.LOGGER.info("Loaded {} registered recipes", (Object)this.registeredRecipes.size());
    }

    public List<RecyclingRecipe> getBaseRecipes() {
        return this.baseRecipes;
    }

    private void loadBaseRecipes() {
        this.baseRecipes.clear();
        if (!this.baseRecipesFile.exists() || !RecyclingManager.loadAsJson(this.baseRecipesFile, this.baseRecipes)) {
            RecyclingManager.forTagItems("minecraft:planks", item -> this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(ModItems.dust_0, 9), new SimpleStack((Item)item))));
            RecyclingManager.forTagItems("minecraft:stone_tool_materials", item -> this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(ModItems.dust_1, 9), new SimpleStack((Item)item))));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(ModItems.dust_2, 9), new SimpleStack(Items.field_151042_j)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(ModItems.dust_3, 9), new SimpleStack(Items.field_151045_i)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(ModItems.dust_4, 9), new SimpleStack(Items.field_151043_k)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(ModItems.dust_5, 9), new SimpleStack(Items.field_234759_km_)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(Blocks.field_196717_eY), new SimpleStack(Items.field_221698_bk, 2), new SimpleStack(Items.field_151042_j, 4)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(Blocks.field_196718_eZ), new SimpleStack(Items.field_221698_bk, 1), new SimpleStack(Items.field_151042_j, 4)));
            Item chain = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "chain"));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_151029_X), new SimpleStack(chain, 4)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_151022_W), new SimpleStack(chain, 7)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_151020_U), new SimpleStack(chain, 4)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_151023_V), new SimpleStack(chain, 8)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_151138_bX), new SimpleStack(Items.field_151042_j, 7)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_151136_bY), new SimpleStack(Items.field_151043_k, 7)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_151125_bZ), new SimpleStack(Items.field_151045_i, 7)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_151141_av), new SimpleStack(Items.field_151116_aA, 5), new SimpleStack(Items.field_151042_j, 3)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_190929_cY), new SimpleStack(Items.field_151153_ao), new SimpleStack(Items.field_151074_bl, 5), new SimpleStack(Items.field_151166_bC, 2)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_151164_bB), new SimpleStack(Items.field_151099_bA, 1)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_234763_ls_), new SimpleStack(Items.field_151161_ac), new SimpleStack(Items.field_234759_km_)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_234764_lt_), new SimpleStack(Items.field_151163_ad), new SimpleStack(Items.field_234759_km_)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_234764_lt_), new SimpleStack(Items.field_151173_ae), new SimpleStack(Items.field_234759_km_)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_234766_lv_), new SimpleStack(Items.field_151175_af), new SimpleStack(Items.field_234759_km_)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_234754_kI_), new SimpleStack(Items.field_151048_u), new SimpleStack(Items.field_234759_km_)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_234755_kJ_), new SimpleStack(Items.field_151047_v), new SimpleStack(Items.field_234759_km_)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_234756_kK_), new SimpleStack(Items.field_151046_w), new SimpleStack(Items.field_234759_km_)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_234757_kL_), new SimpleStack(Items.field_151056_x), new SimpleStack(Items.field_234759_km_)));
            this.baseRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_234758_kU_), new SimpleStack(Items.field_151012_L), new SimpleStack(Items.field_234759_km_)));
            Collections.sort(this.baseRecipes, RecyclingRecipe.ORDER_NATURAL);
            RecyclingManager.saveAsJson(this.baseRecipesFile, this.baseRecipes);
        }
        ModRecycler.LOGGER.info("Loaded {} base recipes", (Object)this.baseRecipes.size());
    }

    public Set<RecyclingRecipe> getDisabledRecipes() {
        return this.disabledRecipes;
    }

    private void loadDisabledRecipes() {
        this.disabledRecipes.clear();
        if (!this.disabledRecipesFile.exists() || !RecyclingManager.loadAsJson(this.disabledRecipesFile, this.disabledRecipes)) {
            HashSet disableItems = Sets.newHashSet((Object[])new Item[]{Items.field_222065_kN, Items.field_226638_pX_, Items.field_151110_aK, Items.field_221694_bi, Items.field_221692_bh, Items.field_151172_bF, Items.field_151174_bG, Items.field_221794_dg, Items.field_221687_cF, Items.field_151015_O, Items.field_221774_cw, Items.field_222068_kQ, Items.field_196128_bn, Items.field_221619_aU, Items.field_221620_aV, Items.field_221621_aW, Items.field_221622_aX, Items.field_221623_aY, Items.field_221678_ba, Items.field_221682_bc, Items.field_221624_aZ, Items.field_221680_bb, Items.field_221684_bd, Items.field_221686_be, Items.field_221688_bf, Items.field_221690_bg, Items.field_221908_fl, Items.field_221910_fm, Items.field_221912_fn, Items.field_221914_fo, Items.field_221572_Y, Items.field_221573_Z, Items.field_221626_aa, Items.field_221628_ab, Items.field_221630_ac, Items.field_221632_ad, Items.field_234715_ap_, Items.field_234716_aq_});
            RecyclingManager.forTagItems("forge:crops", disableItems::add);
            RecyclingManager.forTagItems("forge:seeds", disableItems::add);
            this.registeredRecipes.forEach(r -> {
                boolean disable = false;
                for (SimpleStack result : r.getResult()) {
                    if (!disableItems.contains(result.getItem())) continue;
                    disable = true;
                    break;
                }
                if (disable) {
                    this.disabledRecipes.add((RecyclingRecipe)r);
                }
            });
            RecyclingManager.saveAsJson(this.disabledRecipesFile, this.disabledRecipes);
        }
        ModRecycler.LOGGER.info("Loaded {} disabled recipes", (Object)this.disabledRecipes.size());
    }

    private RecyclingRecipe getGrindRecipe(Item item) {
        return this.grindRecipes.stream().filter(r -> r.getItemRecipe().getItem() == item).findFirst().orElse(null);
    }

    private void loadGrindList() {
        this.grindRecipes.clear();
        if (!this.grindFile.exists() || !RecyclingManager.loadAsJson(this.grindFile, this.grindRecipes)) {
            this.grindRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_151116_aA), new SimpleStack(ModItems.leather_strip, 9)));
            this.grindRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_221737_dE), new SimpleStack(Items.field_191525_da, 6)));
            this.grindRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_151055_y), new SimpleStack(ModItems.dust_0, 4)));
            RecyclingManager.forTagItems("minecraft:planks", item -> this.grindRecipes.add(new RecyclingRecipe(new SimpleStack((Item)item), new SimpleStack(Items.field_151055_y, 2))));
            RecyclingManager.forTagItems("minecraft:stone_tool_materials", item -> this.grindRecipes.add(new RecyclingRecipe(new SimpleStack((Item)item), new SimpleStack(ModItems.dust_1, 9))));
            this.grindRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_151042_j), new SimpleStack(ModItems.dust_2, 9)));
            this.grindRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_151045_i), new SimpleStack(ModItems.dust_3, 9)));
            this.grindRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_151043_k), new SimpleStack(ModItems.dust_4, 9)));
            this.grindRecipes.add(new RecyclingRecipe(new SimpleStack(Items.field_234759_km_), new SimpleStack(ModItems.dust_5, 9)));
            RecyclingManager.forTagItems("minecraft:logs", item -> this.grindRecipes.add(new RecyclingRecipe(new SimpleStack((Item)item), new SimpleStack(Items.field_151055_y, 8))));
            Collections.sort(this.grindRecipes, RecyclingRecipe.ORDER_NATURAL);
            RecyclingManager.saveAsJson(this.grindFile, this.grindRecipes);
        }
        ModRecycler.LOGGER.info("Loaded {} grind schemas", (Object)this.grindRecipes.size());
    }

    public static NonNullList<RecyclingRecipe> getRecipesForSearch(Map<Item, RecipeHolder> recipes, String searchText) {
        return recipes.values().stream().flatMap(rh -> rh.getItems().stream()).filter(recipe -> searchText.isEmpty() || recipe.getItemRecipe().toItemStack().func_200301_q().getString().toLowerCase().contains(searchText)).sorted(RecyclingRecipe.ORDER_NATURAL).collect(Collectors.toCollection(NonNullList::func_191196_a));
    }

    /*
     * WARNING - void declaration
     */
    public RecycleOutput getResultStack(RecycleInput recycleInput, World world) {
        List effects;
        Map enchantments;
        CompoundNBT data;
        RecycleOutput recycleOutput = new RecycleOutput();
        RecyclingRecipe currentRecipe = null;
        RecipeHolder recipeHolder = (RecipeHolder)recycleInput.recipes.get(recycleInput.itemStack.func_77973_b());
        if (recipeHolder != null) {
            currentRecipe = recipeHolder.getCurrentRecipe();
        }
        if (currentRecipe == null && recycleInput.itemStack.func_77973_b() == Items.field_185167_i) {
            currentRecipe = new RecyclingRecipe(new SimpleStack(Items.field_185167_i, 8), new SimpleStack(Items.field_151032_g, 8), new SimpleStack(Items.field_185156_bI));
        }
        if (currentRecipe == null && recycleInput.itemStack.func_77973_b() == Items.field_151098_aY) {
            MapData mapData = FilledMapItem.func_219994_a((ItemStack)recycleInput.itemStack, (World)world);
            currentRecipe = new RecyclingRecipe(new SimpleStack(Items.field_151098_aY), new SimpleStack(Items.field_151148_bJ), new SimpleStack(Items.field_151121_aF, (int)mapData.field_76197_d));
        }
        if (currentRecipe == null && recycleInput.itemStack.func_77973_b() == Items.field_196152_dE) {
            ListNBT tagExplosions;
            ArrayList<SimpleStack> stacksOut = new ArrayList<SimpleStack>();
            stacksOut.add(new SimpleStack(Items.field_151016_H));
            stacksOut.add(new SimpleStack(Items.field_151121_aF));
            CompoundNBT tagFireworks = recycleInput.itemStack.func_179543_a("Fireworks");
            if (tagFireworks != null && (tagExplosions = tagFireworks.func_150295_c("Explosions", 10)) != null) {
                tagExplosions.stream().map(CompoundNBT.class::cast).forEach(c -> {
                    SimpleStack starStack = new SimpleStack(Items.field_196153_dF);
                    CompoundNBT starStackTag = new CompoundNBT();
                    starStackTag.func_218657_a("Explosion", (INBT)c);
                    starStack.setTag(starStackTag);
                    stacksOut.add(starStack);
                });
            }
            currentRecipe = new RecyclingRecipe(new SimpleStack(Items.field_196152_dE, 3), stacksOut);
        }
        if (currentRecipe != null) {
            recycleOutput.recipeAvailable = true;
            recycleOutput.recipeAmbiguous = recipeHolder != null && recipeHolder.getItems().size() > 1;
            recycleOutput.recipeDisabled = currentRecipe.isRecipeDisabled();
        }
        if (currentRecipe != null && (data = recycleInput.itemStack.getShareTag()) != null) {
            boolean listDetected = false;
            block2: for (String key : data.func_150296_c()) {
                INBT iNBT;
                if (key.equalsIgnoreCase("display") || key.equalsIgnoreCase("enchantments") || !((iNBT = data.func_74781_a(key)) instanceof ListNBT)) continue;
                ListNBT listNBT = (ListNBT)iNBT;
                for (INBT listItem : listNBT) {
                    listDetected = true;
                    if (!(listItem instanceof CompoundNBT)) continue;
                    CompoundNBT compoundNBT = (CompoundNBT)listItem;
                    try {
                        ItemStack itemStack = ItemStack.func_199557_a((CompoundNBT)compoundNBT);
                        if (itemStack.func_190926_b()) continue;
                        recycleOutput.content.add(itemStack);
                    }
                    catch (Throwable t) {
                        continue block2;
                    }
                }
            }
            if (!listDetected || recycleOutput.content.isEmpty()) {
                // empty if block
            }
        }
        if (currentRecipe != null) {
            boolean isDamagedStack;
            boolean bl = isDamagedStack = recycleInput.itemStack.func_77958_k() > 0 && recycleInput.itemStack.func_77952_i() > 0;
            if (isDamagedStack) {
                if (recycleInput.itemStack.func_190916_E() != 1) {
                    throw new IllegalStateException();
                }
                this.processPartial(recycleOutput, currentRecipe, 1.0f - 1.0f * (float)recycleInput.itemStack.func_77952_i() / (float)recycleInput.itemStack.func_77958_k());
                recycleOutput.itemConsumed++;
            } else {
                if (recycleInput.itemStack.func_190916_E() < currentRecipe.getItemRecipe().getCount()) {
                    this.processPartial(recycleOutput, currentRecipe, 1.0f * (float)recycleInput.itemStack.func_190916_E() / (float)currentRecipe.getItemRecipe().getCount());
                } else {
                    currentRecipe.getResult().forEach(s -> recycleOutput.items.add(s.toItemStack()));
                }
                RecycleOutput listDetected = recycleOutput;
                listDetected.itemConsumed = listDetected.itemConsumed + currentRecipe.getItemRecipe().getCount();
            }
        }
        if (!(enchantments = EnchantmentHelper.func_82781_a((ItemStack)recycleInput.itemStack)).isEmpty()) {
            int bookCount = recycleInput.bookStack.func_190916_E();
            if (recycleInput.itemStack.func_77973_b() == Items.field_151134_bR) {
                if (enchantments.size() < 2 || bookCount == 0) {
                    ItemStack bookItem = new ItemStack((IItemProvider)Items.field_151122_aG);
                    recycleOutput.items.add(bookItem);
                    recycleOutput.xp = Helper.getEnchantmentXp(enchantments);
                } else {
                    recycleOutput.bookConsumed--;
                    ++bookCount;
                    LinkedList q = new LinkedList(enchantments.entrySet());
                    block4: while (q.size() > 0) {
                        ItemStack currentBook = null;
                        while (q.size() > 0) {
                            Map.Entry entry = (Map.Entry)q.poll();
                            if (currentBook == null && bookCount > 0) {
                                currentBook = new ItemStack((IItemProvider)Items.field_151134_bR);
                                recycleOutput.items.add(currentBook);
                                recycleOutput.bookConsumed++;
                                --bookCount;
                            }
                            if (currentBook != null) {
                                EnchantedBookItem.func_92115_a((ItemStack)currentBook, (EnchantmentData)new EnchantmentData((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
                            }
                            if (bookCount <= 0) continue;
                            continue block4;
                        }
                    }
                }
                recycleOutput.itemConsumed++;
            } else if (bookCount > 0) {
                if (currentRecipe == null) {
                    ItemStack itemStack = recycleInput.itemStack.func_77946_l();
                    EnchantmentHelper.func_82782_a(Collections.emptyMap(), (ItemStack)itemStack);
                    recycleOutput.items.add(itemStack);
                    recycleOutput.itemConsumed++;
                }
                ItemStack currentBook = new ItemStack((IItemProvider)Items.field_151134_bR);
                for (Map.Entry entry : enchantments.entrySet()) {
                    EnchantedBookItem.func_92115_a((ItemStack)currentBook, (EnchantmentData)new EnchantmentData((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
                }
                recycleOutput.items.add(currentBook);
                recycleOutput.bookConsumed++;
                --bookCount;
            } else {
                recycleOutput.xp = Helper.getEnchantmentXp(enchantments);
            }
            if (recycleOutput.xp > 0 && recycleInput.bulbStack.func_77973_b() == Items.field_151069_bo) {
                ItemStack bulbItem = new ItemStack((IItemProvider)Items.field_151062_by, 0);
                for (int bulbCount = recycleInput.bulbStack.func_190916_E(); bulbCount > 0 && recycleOutput.xp > 0; --bulbCount) {
                    bulbItem.func_190917_f(1);
                    RecycleOutput recycleOutput2 = recycleOutput;
                    recycleOutput2.xp = recycleOutput2.xp - 7;
                }
                if (recycleOutput.xp < 0) {
                    recycleOutput.xp = 0;
                }
                if (!bulbItem.func_190926_b()) {
                    recycleOutput.items.add(bulbItem);
                }
            }
        }
        if (!(effects = PotionUtils.func_185189_a((ItemStack)recycleInput.itemStack)).isEmpty() && recycleOutput.items.removeIf(s -> s.func_77973_b() == Items.field_185156_bI) && recycleInput.bulbStack.func_77973_b() == Items.field_185156_bI) {
            Potion potion;
            ArrayList<EffectInstance> result = new ArrayList<EffectInstance>();
            for (EffectInstance effectInstance : PotionUtils.func_185189_a((ItemStack)recycleInput.bulbStack)) {
                this.merge(result, effectInstance);
            }
            for (EffectInstance effectInstance : PotionUtils.func_185189_a((ItemStack)recycleInput.itemStack)) {
                this.merge(result, effectInstance);
            }
            ItemStack itemStack = new ItemStack((IItemProvider)Items.field_185156_bI);
            Potion potion2 = PotionUtils.func_185191_c((ItemStack)recycleInput.bulbStack);
            if (potion2 != null || (potion = PotionUtils.func_185191_c((ItemStack)recycleInput.itemStack)) != null) {
                void var10_31;
                PotionUtils.func_185188_a((ItemStack)itemStack, (Potion)var10_31);
                result.removeAll(var10_31.func_185170_a());
            }
            PotionUtils.func_185184_a((ItemStack)itemStack, result);
            recycleOutput.items.add(itemStack);
            recycleOutput.bulbConsumed++;
        }
        recycleOutput.diskConsumed++;
        return recycleOutput;
    }

    private void merge(List<EffectInstance> result, EffectInstance effect) {
        result.removeIf(e -> Objects.equals(e.func_76453_d(), effect.func_76453_d()) && C_EFFECT.compare((EffectInstance)e, effect) <= 0);
        result.add(effect);
    }

    private void processPartial(RecycleOutput recycleOutput, RecyclingRecipe recipe, float damage) {
        HashMap output = new HashMap();
        recipe.getResult().forEach(s -> {
            if (s.getItem().func_77645_m()) {
                ItemStack itemStack = s.toItemStack();
                itemStack.func_196085_b(itemStack.func_77958_k() - (int)((float)itemStack.func_77958_k() * damage));
                output.put(s.getItem(), itemStack);
            } else {
                this.evaluate(output, IntStream.range(0, s.getCount()).boxed().map(i -> s.getItem()).collect(Collectors.toList()), damage);
            }
        });
        recycleOutput.items.addAll(output.values());
    }

    private float evaluate(Map<Item, ItemStack> output, List<Item> line, float part) {
        for (int i = 0; i < line.size(); ++i) {
            float f = part * (float)line.size();
            if (i < (int)f) {
                output.computeIfAbsent(line.get(i), item -> new ItemStack((IItemProvider)item, 0)).func_190917_f(1);
                continue;
            }
            RecyclingRecipe recipe = this.getGrindRecipe(line.get(i));
            if (recipe == null) continue;
            this.evaluate(output, recipe.getOutputItems(), f - (float)((int)f));
            break;
        }
        return part;
    }

    private List<RecyclingRecipe> loadUserDefinedRecipes(ServerPlayerEntity player) {
        CompoundNBT preferredRecipes = player.getPersistentData().func_74775_l("recycler:preferred_recipes");
        return preferredRecipes.func_150296_c().stream().map(arg_0 -> ((CompoundNBT)preferredRecipes).func_74775_l(arg_0)).map(RecyclingRecipe::asNBT).collect(Collectors.toList());
    }

    public void saveUserDefinedRecipe(ServerPlayerEntity player, RecyclingRecipe recipe) {
        CompoundNBT preferredRecipes = player.getPersistentData().func_74775_l("recycler:preferred_recipes");
        preferredRecipes.func_218657_a(recipe.getItemRecipe().getItem().getRegistryName().toString(), (INBT)RecyclingRecipe.toNBT(recipe));
        player.getPersistentData().func_218657_a("recycler:preferred_recipes", (INBT)preferredRecipes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean saveAsJson(File file, Collection<RecyclingRecipe> recipes) {
        try (FileWriter fw = new FileWriter(file);){
            GSON.toJson((JsonElement)recipes.stream().map(RecyclingRecipe::toJson).collect(JsonArray::new, JsonArray::add, (l, r) -> {}), GSON.newJsonWriter((Writer)fw));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            ModRecycler.LOGGER.error("Ubable to save recipes to file {}", (Object)file, (Object)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadAsJson(File file, Collection<RecyclingRecipe> recipes) {
        try (FileReader fr = new FileReader(file);){
            JsonArray jsonArray = (JsonArray)GSON.fromJson((Reader)fr, JsonArray.class);
            for (JsonElement json : jsonArray) {
                try {
                    recipes.add(RecyclingRecipe.asJson(json));
                }
                catch (RuntimeException e) {
                    ModRecycler.LOGGER.error("Ubable read json element: {}", (Object)json, (Object)e);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            ModRecycler.LOGGER.error("Ubable to load recipes from file {}", (Object)file, (Object)e);
            return false;
        }
    }

    public void updateRecyclingRecipeFromPlayerRecipeBook(PlayerEntity player, Map<Item, RecipeHolder> recipes) {
        if (player.field_70170_p == null || player.field_70170_p.field_72995_K) {
            return;
        }
        ModRecycler.LOGGER.debug("Collecting recipes for {} ...", (Object)player.func_200200_C_().getString());
        StopWatch stopWatch = StopWatch.createStarted();
        this.updateRecyclingRecipeFromRecipeBook((ServerPlayerEntity)player, recipes);
        stopWatch.stop();
        ModRecycler.LOGGER.debug("Collecting done in {}ms", (Object)stopWatch.getTime());
    }

    public void updateRecyclingRecipeFromRecipeBook(ServerPlayerEntity player, Map<Item, RecipeHolder> recipes) {
        recipes.clear();
        Predicate<ResourceLocation> isUnlocked = player.func_195070_dx() ? r -> true : arg_0 -> ((ServerRecipeBook)player.func_192037_E()).func_226144_b_(arg_0);
        Stream.concat(this.baseRecipes.stream(), this.registeredRecipes.stream().filter(r -> isUnlocked.test(r.getId()))).forEach(r -> {
            recipes.computeIfAbsent(r.getItemRecipe().getItem(), k -> new RecipeHolder((NonNullList<RecyclingRecipe>)NonNullList.func_191196_a(), -1)).getItems().add(r);
            if (this.disabledRecipes.contains(r)) {
                r.setRecipeDisabled(true);
            }
        });
        this.loadUserDefinedRecipes(player).forEach(recipe -> recipes.computeIfPresent(recipe.getItemRecipe().getItem(), (k, h) -> {
            int index = h.getItems().indexOf(recipe);
            if (index != -1) {
                h.setIndex(index);
            }
            return h;
        }));
    }

    public static RecyclingRecipe getRecipe(Map<Item, RecipeHolder> recipes, ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        RecipeHolder recipeHolder = recipes.get(itemStack.func_77973_b());
        if (recipeHolder == null) {
            return null;
        }
        return recipeHolder.getCurrentRecipe();
    }

    public void browseRecipe(ServerPlayerEntity player, RecipeHolder recipeHolder) {
        recipeHolder.addIndex();
        this.saveUserDefinedRecipe(player, recipeHolder.getCurrentRecipe());
    }

    public void enableRecipe(RecipeHolder recipeHolder) {
        RecyclingRecipe recipe = recipeHolder.getCurrentRecipe();
        recipe.setRecipeDisabled(false);
        if (this.disabledRecipes.remove(recipe)) {
            RecyclingManager.saveAsJson(this.disabledRecipesFile, this.disabledRecipes);
        }
    }

    public void disableRecipe(RecipeHolder recipeHolder) {
        RecyclingRecipe recipe = recipeHolder.getCurrentRecipe();
        recipe.setRecipeDisabled(true);
        if (this.disabledRecipes.add(recipe)) {
            RecyclingManager.saveAsJson(this.disabledRecipesFile, this.disabledRecipes);
        }
    }

    public static void forTagItems(String tag, Consumer<Item> c) {
        ResourceLocation resourcelocation = new ResourceLocation(tag);
        ITag<Item> iTag = Helper.getTag(resourcelocation);
        if (iTag == null) {
            ModRecycler.LOGGER.warn("No tag registered: {}", (Object)tag);
        } else {
            iTag.func_230236_b_().forEach(c);
        }
    }

    static {
        C_EFFECT = Comparator.comparing(EffectInstance::func_76453_d).thenComparing(EffectInstance::func_76458_c).thenComparing(EffectInstance::func_76459_b);
    }

    private static class Group {
        private final ItemStack[] items;

        public Group(ItemStack[] items) {
            this.items = items;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            for (ItemStack item : this.items) {
                result = 31 * result + item.func_77973_b().hashCode();
            }
            return result;
        }

        public boolean equals(Object o) {
            Group other = (Group)o;
            if (this.items.length != other.items.length) {
                return false;
            }
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i].func_77973_b() == other.items[i].func_77973_b()) continue;
                return false;
            }
            return true;
        }
    }

    public static class RecycleOutput {
        private final List<ItemStack> items = NonNullList.func_191196_a();
        private final List<ItemStack> content = NonNullList.func_191196_a();
        private int itemConsumed;
        private int diskConsumed;
        private int bookConsumed;
        private int bulbConsumed;
        private int xp;
        private boolean recipeAvailable;
        private boolean recipeAmbiguous;
        private boolean recipeDisabled;

        public List<ItemStack> getItems() {
            return this.items;
        }

        public List<ItemStack> getContent() {
            return this.content;
        }

        public int getItemConsumed() {
            return this.itemConsumed;
        }

        public int getDiskConsumed() {
            return this.diskConsumed;
        }

        public int getBookConsumed() {
            return this.bookConsumed;
        }

        public int getBulbConsumed() {
            return this.bulbConsumed;
        }

        public int getXp() {
            return this.xp;
        }

        public boolean isRecipeAvailable() {
            return this.recipeAvailable;
        }

        public boolean isRecipeAmbiguous() {
            return this.recipeAmbiguous;
        }

        public boolean isRecipeDisabled() {
            return this.recipeDisabled;
        }
    }

    public static class RecycleInput {
        private final Map<Item, RecipeHolder> recipes;
        private final ItemStack itemStack;
        private final ItemStack diskStack;
        private final ItemStack bookStack;
        private final ItemStack bulbStack;

        public RecycleInput(Map<Item, RecipeHolder> recipes, ItemStack itemStack, ItemStack diskStack, ItemStack bookStack, ItemStack bulbStack) {
            this.recipes = recipes;
            this.itemStack = itemStack;
            this.diskStack = diskStack;
            this.bookStack = bookStack;
            this.bulbStack = bulbStack;
        }
    }
}

