/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.recycler.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.cursegame.minecraft.recycler.recipe.SimpleStack;

public class RecyclingRecipe {
    public static final Comparator<RecyclingRecipe> ORDER_NATURAL = Comparator.comparing(r -> Item.func_150891_b((Item)r.getItemRecipe().getItem())).thenComparing(r -> r.getResult().size());
    private static final ResourceLocation CUSTOM_RECIPE = new ResourceLocation("corail_recycler_ne", "custom");
    private final ResourceLocation id;
    private final SimpleStack itemRecipe;
    private final NonNullList<SimpleStack> itemsList = NonNullList.func_191196_a();
    private boolean recipeDisabled;

    public boolean isRecipeDisabled() {
        return this.recipeDisabled;
    }

    public void setRecipeDisabled(boolean b) {
        this.recipeDisabled = b;
    }

    public RecyclingRecipe(ResourceLocation id, SimpleStack stack) {
        this.id = id;
        this.itemRecipe = Objects.requireNonNull(stack);
    }

    public RecyclingRecipe(SimpleStack stackIn, List<SimpleStack> stacksOut) {
        this(CUSTOM_RECIPE, stackIn);
        stacksOut.forEach(s -> {
            if (s != null && !s.isEmpty()) {
                this.itemsList.add(s);
            }
        });
    }

    public RecyclingRecipe(SimpleStack stackIn, SimpleStack ... stacksOut) {
        this(stackIn, Arrays.asList(stacksOut));
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public SimpleStack getItemRecipe() {
        return this.itemRecipe;
    }

    public SimpleStack getResult(int index) {
        return (SimpleStack)this.itemsList.get(index);
    }

    public NonNullList<SimpleStack> getResult() {
        return this.itemsList;
    }

    public List<Item> getOutputItems() {
        return this.getResult().stream().flatMap(s -> IntStream.range(0, s.getCount()).boxed().map(i -> s.getItem())).collect(Collectors.toList());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.itemRecipe == null ? 0 : this.itemRecipe.hashCode());
        result = 31 * result + (this.itemsList == null ? 0 : this.itemsList.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        RecyclingRecipe other = (RecyclingRecipe)o;
        if (this.itemRecipe == null ? other.itemRecipe != null : !this.itemRecipe.equals(other.itemRecipe)) {
            return false;
        }
        return !(this.itemsList == null ? other.itemsList != null : !this.itemsList.equals(other.itemsList));
    }

    public static CompoundNBT toNBT(RecyclingRecipe recipe) {
        CompoundNBT recipeNBT = new CompoundNBT();
        recipeNBT.func_218657_a("i", (INBT)StringNBT.func_229705_a_((String)recipe.getItemRecipe().toString()));
        recipeNBT.func_218657_a("o", (INBT)recipe.getResult().stream().map(SimpleStack::toString).map(StringNBT::func_229705_a_).collect(ListNBT::new, AbstractList::add, AbstractCollection::addAll));
        return recipeNBT;
    }

    public static RecyclingRecipe asNBT(CompoundNBT recipeNBT) {
        String i = recipeNBT.func_74779_i("i");
        if (i == null || i.isEmpty()) {
            return null;
        }
        ListNBT o = (ListNBT)recipeNBT.func_74781_a("o");
        return new RecyclingRecipe(SimpleStack.asString(i), (List)o.stream().map(INBT::func_150285_a_).map(SimpleStack::asString).collect(Collectors.toCollection(NonNullList::func_191196_a)));
    }

    public static RecyclingRecipe asJson(JsonElement json) {
        return new RecyclingRecipe(SimpleStack.asString(json.getAsJsonObject().get("input").getAsString()), (List)StreamSupport.stream(json.getAsJsonObject().get("output").getAsJsonArray().spliterator(), false).map(JsonElement::getAsString).map(SimpleStack::asString).collect(Collectors.toCollection(NonNullList::func_191196_a)));
    }

    public static JsonElement toJson(RecyclingRecipe recipe) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("input", recipe.getItemRecipe().toString());
        jsonObject.add("output", (JsonElement)recipe.getResult().stream().map(SimpleStack::toString).collect(JsonArray::new, JsonArray::add, (l, r) -> {}));
        return jsonObject;
    }
}

