/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.recycler.recipe;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class SimpleStack {
    public static final SimpleStack EMPTY = new SimpleStack(ItemStack.field_190927_a);
    private final Item item;
    private final int count;
    private CompoundNBT tag;

    public SimpleStack(ItemStack stack) {
        this(stack.func_77973_b(), stack.func_190916_E());
    }

    public SimpleStack(@Nullable Item item, int count) {
        if (item != null) {
            this.item = item;
            this.count = count;
        } else {
            this.item = Items.field_190931_a;
            this.count = 1;
        }
    }

    public SimpleStack(Item item) {
        this(item, 1);
    }

    public SimpleStack(Block block, int count) {
        this(block.func_199767_j(), count);
    }

    public SimpleStack(Block block) {
        this(block, 1);
    }

    public Item getItem() {
        return this.item;
    }

    public int getCount() {
        return this.count;
    }

    public CompoundNBT getTag() {
        return this.tag;
    }

    public void setTag(CompoundNBT tag) {
        this.tag = tag;
    }

    public boolean isEmpty() {
        return this.item == null || this.item == Items.field_190931_a;
    }

    public ItemStack toItemStack() {
        ItemStack itemStack = new ItemStack((IItemProvider)this.item, this.count);
        if (this.tag != null) {
            itemStack.func_77982_d(this.tag);
        }
        return itemStack;
    }

    public String toString() {
        ResourceLocation rl = this.item.getRegistryName();
        assert (rl != null);
        return rl.toString() + ":" + this.count;
    }

    public static SimpleStack asString(String string) {
        Item item;
        String[] parts = string.split(":");
        if ((parts.length == 2 || parts.length == 3) && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parts[0], parts[1]))) != null) {
            return new SimpleStack(item, parts.length == 3 ? Integer.valueOf(parts[2]) : 1);
        }
        return new SimpleStack(ItemStack.field_190927_a);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        SimpleStack other = (SimpleStack)o;
        return this.item == other.item && this.count == other.count;
    }
}

