/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.recycler.registry;

import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemTier;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.cursegame.minecraft.recycler.block.BlockRecycler;
import org.cursegame.minecraft.recycler.block.ItemBlockRecycler;
import org.cursegame.minecraft.recycler.gui.ContainerRecycler;
import org.cursegame.minecraft.recycler.gui.ContainerRecyclingBook;
import org.cursegame.minecraft.recycler.item.ItemDisk;
import org.cursegame.minecraft.recycler.item.ItemGeneric;
import org.cursegame.minecraft.recycler.registry.ModBlocks;
import org.cursegame.minecraft.recycler.tileentity.TileEntityRecycler;

@Mod.EventBusSubscriber(modid="corail_recycler_ne", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryHandler {
    public static final int[] dusts = new int[]{0, 1, 2, 3, 4, 5};
    public static final int[] bases = new int[]{0, 1, 2, 3, 4, 5};

    public static String getDustName(int dust) {
        return "dust_" + dust;
    }

    public static String getDiskName(int dust, int base) {
        return "disk_" + dust + "_" + base;
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)RegistryHandler.withName(new BlockRecycler(), "recycler"));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RegistryHandler.withName(new ItemGeneric("leather_strip"), "leather_strip"), (Item)RegistryHandler.withName(new ItemBlockRecycler(ModBlocks.recycler), ModBlocks.recycler.getRegistryName())});
        for (int dust : dusts) {
            String dustName = RegistryHandler.getDustName(dust);
            event.getRegistry().register((IForgeRegistryEntry)RegistryHandler.withName(new ItemGeneric(dustName), dustName));
            for (int base : bases) {
                String diskName = RegistryHandler.getDiskName(dust, base);
                event.getRegistry().register((IForgeRegistryEntry)RegistryHandler.withName(new ItemDisk(diskName, ItemTier.values()[dust], ItemTier.values()[base]), diskName));
            }
        }
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{RegistryHandler.fromSound("recycler"), RegistryHandler.fromSound("recycler_working")});
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)RegistryHandler.withName(TileEntityType.Builder.func_223042_a(TileEntityRecycler::new, (Block[])new Block[]{ModBlocks.recycler}).func_206865_a(null), "recycler"));
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new ContainerType[]{RegistryHandler.withName(IForgeContainerType.create(ContainerRecycler::new), "recycler"), RegistryHandler.withName(new ContainerType(ContainerRecyclingBook::new), "recycling_book")});
    }

    private static SoundEvent fromSound(String name) {
        ResourceLocation rl = new ResourceLocation("corail_recycler_ne", name);
        return (SoundEvent)new SoundEvent(rl).setRegistryName(rl);
    }

    private static <T extends IForgeRegistryEntry<T>> T withName(T entry, String name) {
        return (T)((IForgeRegistryEntry)entry.setRegistryName(new ResourceLocation("corail_recycler_ne", name)));
    }

    private static <T extends IForgeRegistryEntry<T>> T withName(T entry, ResourceLocation locName) {
        return (T)((IForgeRegistryEntry)entry.setRegistryName(locName));
    }
}

