/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.recycler.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ItemTagsProvider;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.TagsProvider;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.cursegame.minecraft.recycler.registry.RegistryHandler;

@Mod.EventBusSubscriber(modid="corail_recycler_ne", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryRecipeGenerator {
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();

    @SubscribeEvent
    public static void registerRecipes(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper fileHelper = new ExistingFileHelper(Collections.emptyList(), false);
        generator.func_200390_a((IDataProvider)new ItemModelProvider(generator, "corail_recycler_ne", fileHelper){

            protected void registerModels() {
                ModelFile.ExistingModelFile dustParent = this.getExistingFile(new ResourceLocation("corail_recycler_ne", "item/dust"));
                for (int dust : RegistryHandler.dusts) {
                    ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(RegistryHandler.getDustName(dust))).parent((ModelFile)dustParent)).texture("layer0", new ResourceLocation("corail_recycler_ne", "item/" + RegistryHandler.getDustName(dust)));
                    for (int base : RegistryHandler.bases) {
                        ModelFile.ExistingModelFile diskParent = this.getExistingFile(new ResourceLocation("corail_recycler_ne", "item/disk"));
                        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(RegistryHandler.getDiskName(dust, base))).parent((ModelFile)diskParent)).texture("layer0", new ResourceLocation("corail_recycler_ne", "item/disk_base_" + base))).texture("layer1", new ResourceLocation("corail_recycler_ne", "item/disk_rim_" + dust));
                    }
                }
            }
        });
        generator.func_200390_a((IDataProvider)new RecipeProvider(generator){

            protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
                ResourceLocation[][] diskBases = new ResourceLocation[][]{{null, new ResourceLocation("minecraft:planks")}, {null, new ResourceLocation("minecraft:stone_tool_materials")}, {new ResourceLocation("minecraft:iron_ingot"), null}, {new ResourceLocation("minecraft:diamond"), null}, {new ResourceLocation("minecraft:gold_ingot"), null}, {new ResourceLocation("minecraft:netherite_ingot"), null}};
                for (int dust : RegistryHandler.dusts) {
                    ResourceLocation dustItem = new ResourceLocation("corail_recycler_ne", RegistryHandler.getDustName(dust));
                    for (int base : RegistryHandler.bases) {
                        RecipeBuilder.createShaped(new ResourceLocation("corail_recycler_ne", RegistryHandler.getDiskName(dust, base))).addPatternLine(" 0 ").addPatternLine("010").addPatternLine(" 0 ").setKey(Character.valueOf('0'), dustItem, null).setKey(Character.valueOf('1'), diskBases[base][0], diskBases[base][1]).build(this.field_200413_c);
                    }
                }
            }
        });
        generator.func_200390_a((IDataProvider)new ItemTagsProvider(generator, new BlockTagsProvider(generator, "corail_recycler_ne", fileHelper), "corail_recycler_ne", fileHelper){

            protected void func_200432_c() {
                TagsProvider.Builder disksBuilder = this.func_240522_a_(new NamedTag(new ResourceLocation("corail_recycler_ne", "disks")));
                for (int dust : RegistryHandler.dusts) {
                    TagsProvider.Builder diskBuilder = this.func_240522_a_(new NamedTag(new ResourceLocation("corail_recycler_ne", "disk_" + dust)));
                    for (int base : RegistryHandler.bases) {
                        Item diskItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("corail_recycler_ne", RegistryHandler.getDiskName(dust, base)));
                        diskBuilder.func_240534_a_((Object[])new Item[]{diskItem});
                        disksBuilder.func_240534_a_((Object[])new Item[]{diskItem});
                    }
                }
            }
        });
    }

    private static class RecipeBuilder {
        private final Type type;
        private final ResourceLocation result;
        private final Integer count;
        private final List<String> pattern = Lists.newArrayList();
        private final Map<Character, Resource> keys = Maps.newLinkedHashMap();

        private RecipeBuilder(Type type, ResourceLocation result, Integer count) {
            this.type = type;
            this.result = result;
            this.count = count;
        }

        private RecipeBuilder(Type type, ResourceLocation result) {
            this(type, result, 1);
        }

        public static RecipeBuilder createShaped(ResourceLocation result) {
            return new RecipeBuilder(Type.SHAPED, result);
        }

        public static RecipeBuilder createShapeless(ResourceLocation result) {
            return new RecipeBuilder(Type.SHAPELESS, result);
        }

        public RecipeBuilder addPatternLine(String line) {
            if (!this.pattern.isEmpty() && line.length() != this.pattern.get(0).length()) {
                throw new IllegalArgumentException("Pattern must be the same width on every line!");
            }
            this.pattern.add(line);
            return this;
        }

        public RecipeBuilder setKey(Character key, ResourceLocation i, ResourceLocation t) {
            if (this.keys.containsKey(key)) {
                throw new IllegalArgumentException("Symbol '" + key + "' is already defined!");
            }
            if (key.charValue() == ' ') {
                throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
            }
            this.keys.put(key, new Resource("requirement" + key, i, t));
            return this;
        }

        public void build(DataGenerator generator) {
            Path outputDataFolder = generator.func_200391_b().resolve("data");
            Path advancementPath = outputDataFolder.resolve(this.result.func_110624_b()).resolve("advancements").resolve("recipes").resolve(this.result.func_110623_a() + ".json");
            if (Files.notExists(advancementPath.getParent(), new LinkOption[0])) {
                try {
                    Files.createDirectories(advancementPath.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            try (BufferedWriter writer = Files.newBufferedWriter(advancementPath, new OpenOption[0]);){
                GSON.toJson((JsonElement)this.createAdvancement(), new JsonWriter((Writer)writer));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            Path recipePath = outputDataFolder.resolve(this.result.func_110624_b()).resolve("recipes").resolve(this.result.func_110623_a() + ".json");
            if (Files.notExists(recipePath.getParent(), new LinkOption[0])) {
                try {
                    Files.createDirectories(recipePath.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            try (BufferedWriter writer = Files.newBufferedWriter(recipePath, new OpenOption[0]);){
                GSON.toJson((JsonElement)this.createRecipe(), new JsonWriter((Writer)writer));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private JsonObject createAdvancement() {
            JsonObject root = new JsonObject();
            root.addProperty("parent", "minecraft:recipes/root");
            JsonArray recipes = new JsonArray();
            recipes.add(this.result.toString());
            JsonObject rewards = new JsonObject();
            rewards.add("recipes", (JsonElement)recipes);
            root.add("rewards", (JsonElement)rewards);
            JsonObject criteria = new JsonObject();
            for (Resource resource : this.keys.values()) {
                JsonObject requirement = new JsonObject();
                requirement.addProperty("trigger", "minecraft:inventory_changed");
                JsonObject item = new JsonObject();
                if (resource.i != null) {
                    item.addProperty("item", resource.i.toString());
                }
                if (resource.t != null) {
                    item.addProperty("tag", resource.t.toString());
                }
                JsonArray items = new JsonArray();
                items.add((JsonElement)item);
                JsonObject conditions = new JsonObject();
                conditions.add("items", (JsonElement)items);
                requirement.add("conditions", (JsonElement)conditions);
                criteria.add(resource.name, (JsonElement)requirement);
            }
            root.add("criteria", (JsonElement)criteria);
            JsonArray requirements = new JsonArray();
            for (Resource resource : this.keys.values()) {
                JsonArray requirement = new JsonArray();
                requirement.add(resource.name);
                requirements.add((JsonElement)requirement);
            }
            root.add("requirements", (JsonElement)requirements);
            return root;
        }

        private JsonObject createRecipe() {
            JsonObject root = new JsonObject();
            switch (this.type) {
                case SHAPED: {
                    root.addProperty("type", "crafting_shaped");
                    break;
                }
                case SHAPELESS: {
                    root.addProperty("type", "crafting_shapeless");
                }
            }
            if (this.type != Type.SHAPED) {
                throw new UnsupportedOperationException();
            }
            JsonArray pattern = new JsonArray();
            this.pattern.forEach(arg_0 -> ((JsonArray)pattern).add(arg_0));
            root.add("pattern", (JsonElement)pattern);
            JsonObject keys = new JsonObject();
            for (Character c : this.keys.keySet()) {
                JsonObject item = new JsonObject();
                if (this.keys.get(c).i != null) {
                    item.addProperty("item", this.keys.get(c).i.toString());
                }
                if (this.keys.get(c).t != null) {
                    item.addProperty("tag", this.keys.get(c).t.toString());
                }
                keys.add(Character.toString(c.charValue()), (JsonElement)item);
            }
            root.add("key", (JsonElement)keys);
            JsonObject item = new JsonObject();
            item.addProperty("item", this.result.toString());
            root.add("result", (JsonElement)item);
            return root;
        }

        private static class Resource {
            private String name;
            private ResourceLocation i;
            private ResourceLocation t;

            public Resource(String name, ResourceLocation item, ResourceLocation tag) {
                this.name = name;
                if (this.i != null ^ this.t != null) {
                    throw new IllegalArgumentException("Either item or tag shoulb be specified");
                }
                this.i = item;
                this.t = tag;
            }
        }

        private static enum Type {
            SHAPED,
            SHAPELESS;

        }
    }

    private static class NamedTag<T>
    implements ITag.INamedTag<T> {
        private final ResourceLocation resourceLocation;

        public NamedTag(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public boolean func_230235_a_(T element) {
            throw new UnsupportedOperationException();
        }

        public List<T> func_230236_b_() {
            throw new UnsupportedOperationException();
        }

        public ResourceLocation func_230234_a_() {
            return this.resourceLocation;
        }
    }
}

