/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.recycler.tileentity;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.INameable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.cursegame.minecraft.recycler.ModRecycler;
import org.cursegame.minecraft.recycler.block.BlockRecycler;
import org.cursegame.minecraft.recycler.capability.RecyclerWorkingStackHandler;
import org.cursegame.minecraft.recycler.item.ItemDisk;
import org.cursegame.minecraft.recycler.recipe.RecipeHolder;
import org.cursegame.minecraft.recycler.recipe.RecyclingManager;
import org.cursegame.minecraft.recycler.registry.ModSounds;
import org.cursegame.minecraft.recycler.registry.ModTileEntityTypes;
import org.cursegame.minecraft.recycler.registry.ModTriggers;
import org.cursegame.minecraft.recycler.util.Helper;
import org.cursegame.minecraft.recycler.util.LangKey;

public class TileEntityRecycler
extends TileEntity
implements ITickableTileEntity,
INameable {
    private final ItemStackHandler inventoryInput = new ItemStackHandler(19){

        protected void onContentsChanged(int slot) {
            World world = TileEntityRecycler.this.func_145831_w();
            if (world != null && !world.field_72995_K && slot == 0) {
                TileEntityRecycler.this.requestUpdateRecyclingRecipe();
            }
        }
    };
    private final ItemStackHandler inventoryWorking = new RecyclerWorkingStackHandler(){

        protected void onContentsChanged(int slot) {
            World world = TileEntityRecycler.this.func_145831_w();
            if (world != null && !world.field_72995_K) {
                TileEntityRecycler.this.requestUpdateRecyclingRecipe();
            }
        }
    };
    private final ItemStackHandler inventoryOutput = new ItemStackHandler(18);
    private final ItemStackHandler inventoryVisual = new ItemStackHandler(9);
    private String customName;
    private int temperature;
    public int state;
    private int recipeState;
    private int playerIn;
    private long recycleItemDelay;
    private long recycleItemStart;
    private long recycleStaledLimit = 1000L;
    private long recycleStaledStart;
    private final long supplyItemSlotDelay = 500L;
    private long supplyItemSlotTime;
    private final long supplyDiskSlotDelay = 500L;
    private long supplyDiskSlotTime;
    private long blockStateUpdated;
    private final int quant = 8;
    private long temperatureDownUpdated;
    private long temperatureUpUpdated;
    private long playWorkingSoundUpdated;
    private long playRecycleSoundUpdated;
    private boolean requireRecipeUpdate = false;
    private transient Item previousItem;
    private transient int previousItemCount;
    private static final int inventoryVersion = 3;
    private NonNullList<ItemStack> itemsToThrowAway;
    private final Map<Item, RecipeHolder> recipes = new LinkedHashMap<Item, RecipeHolder>();
    private int recipesPlayerId;
    private int lastPlayerIn;

    public TileEntityRecycler() {
        super(ModTileEntityTypes.RECYCLER);
    }

    public ItemStackHandler getInventoryInput() {
        return this.inventoryInput;
    }

    public ItemStackHandler getInventoryWorking() {
        return this.inventoryWorking;
    }

    public ItemStackHandler getInventoryOutput() {
        return this.inventoryOutput;
    }

    public ItemStackHandler getInventoryVisual() {
        return this.inventoryVisual;
    }

    public ItemStack getItemStack() {
        return this.inventoryInput.getStackInSlot(0);
    }

    public void setItemStack(ItemStack stack) {
        this.inventoryInput.setStackInSlot(0, stack);
    }

    public ItemStack getDiskStack() {
        return this.inventoryWorking.getStackInSlot(0);
    }

    public void setDiskStack(ItemStack stack) {
        this.inventoryWorking.setStackInSlot(0, stack);
    }

    public ItemStack getBookStack() {
        return this.inventoryWorking.getStackInSlot(1);
    }

    public void setBookStack(ItemStack stack) {
        this.inventoryWorking.setStackInSlot(1, stack);
    }

    public ItemStack getBulbStack() {
        return this.inventoryWorking.getStackInSlot(2);
    }

    public void setBulbStack(ItemStack stack) {
        this.inventoryWorking.setStackInSlot(2, stack);
    }

    public boolean isStarted() {
        return TileEntityRecycler.getValue(this.state, 0);
    }

    public void setStarted(boolean b) {
        this.state = TileEntityRecycler.setValue(this.state, 0, b);
    }

    public boolean isStartedPermanently() {
        return TileEntityRecycler.getValue(this.state, 1);
    }

    public void setStartedPermanently(boolean b) {
        this.state = TileEntityRecycler.setValue(this.state, 1, b);
    }

    public int getStateVersion() {
        return TileEntityRecycler.getValue(this.state, 2, 6);
    }

    public void setStateVersion(int v) {
        this.state = TileEntityRecycler.setValue(this.state, 2, 6, v);
    }

    public int getProgress() {
        return TileEntityRecycler.getValue(this.state, 8, 8);
    }

    public void setProgress(int v) {
        this.state = TileEntityRecycler.setValue(this.state, 8, 8, v);
    }

    public int getTemperature() {
        return TileEntityRecycler.getValue(this.state, 16, 8);
    }

    public void setTemperature(int v) {
        this.state = TileEntityRecycler.setValue(this.state, 16, 8, v);
    }

    public int getRecipeItemInput() {
        return TileEntityRecycler.getValue(this.recipeState, 8, 8);
    }

    public void setRecipeItemInput(int number) {
        this.recipeState = TileEntityRecycler.setValue(this.recipeState, 8, 8, number);
    }

    public int getRecipeDiskInput() {
        return TileEntityRecycler.getValue(this.recipeState, 16, 8);
    }

    public void setRecipeDiskInput(int number) {
        this.recipeState = TileEntityRecycler.setValue(this.recipeState, 16, 8, number);
    }

    public int getRecipeBookInput() {
        return TileEntityRecycler.getValue(this.recipeState, 24, 8);
    }

    public void setRecipeBookInput(int number) {
        this.recipeState = TileEntityRecycler.setValue(this.recipeState, 24, 8, number);
    }

    public boolean isRecipeAvailable() {
        return TileEntityRecycler.getValue(this.recipeState, 0);
    }

    public void setRecipeAvailable(boolean b) {
        this.recipeState = TileEntityRecycler.setValue(this.recipeState, 0, b);
    }

    public boolean isRecipeAmbiguous() {
        return TileEntityRecycler.getValue(this.recipeState, 1);
    }

    public void setRecipeAmbiguous(boolean b) {
        this.recipeState = TileEntityRecycler.setValue(this.recipeState, 1, b);
    }

    public boolean isRecipeDisabled() {
        return TileEntityRecycler.getValue(this.recipeState, 2);
    }

    public void setRecipeDisabled(boolean b) {
        this.recipeState = TileEntityRecycler.setValue(this.recipeState, 2, b);
    }

    public int getPlayerIn() {
        return this.playerIn;
    }

    private void recycleProggress(ItemStack diskItem) {
        long time;
        if (this.recycleItemDelay == 0L) {
            ItemDisk itemDisk = (ItemDisk)diskItem.func_77973_b();
            float processingSpeed = itemDisk.getProcessingTimeFactor(diskItem);
            float hardeness = 1.0f;
            if (this.getItemStack().func_77973_b() instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)this.getItemStack().func_77973_b();
                hardeness *= blockItem.func_179223_d().func_176223_P().func_185887_b(null, null);
            }
            this.recycleItemDelay = (int)(3000.0f * hardeness / processingSpeed);
            this.recycleItemStart = System.currentTimeMillis();
            ModRecycler.LOGGER.debug("Progress has been sterted for {} ms", (Object)this.recycleItemDelay);
        }
        if ((time = System.currentTimeMillis()) >= this.recycleItemStart + this.recycleItemDelay) {
            this.setProgress(100);
        } else {
            this.setProgress((int)(100.0f * (float)(time - this.recycleItemStart) / (float)this.recycleItemDelay));
        }
    }

    private void recycleReset() {
        if (this.recycleItemStart != 0L) {
            ModRecycler.LOGGER.debug("Progress has been reset");
        }
        this.recycleItemDelay = 0L;
        this.recycleItemStart = 0L;
        this.recycleStaledReset();
        this.setProgress(0);
    }

    private void recycleStaledReset() {
        if (this.recycleStaledStart != 0L) {
            ModRecycler.LOGGER.debug("Staled process has been reset");
        }
        this.recycleStaledStart = 0L;
    }

    private void recycle(ItemStack itemStack) {
        if (this.recycleStaledStart == 0L ? this.recycleItemStart > System.currentTimeMillis() - this.recycleItemDelay : this.recycleStaledStart > System.currentTimeMillis() - this.recycleStaledLimit) {
            return;
        }
        if (this.recycleStaledStart == 0L) {
            boolean recycled = this.recycle();
            ModRecycler.LOGGER.debug("Recycling attempt: outcome - {}", (Object)(recycled ? "OK" : "FAILURE"));
            if (recycled) {
                this.recycleReset();
                if (this.isStarted()) {
                    this.setStarted(false);
                }
                this.playRecycleSound();
            } else {
                ModRecycler.LOGGER.debug("Staled process detected");
                this.recycleStaledStart = System.currentTimeMillis();
            }
        } else {
            ModRecycler.LOGGER.debug("Staled process resolution time gone");
            if (Helper.canInsertInInventory((IItemHandlerModifiable)this.inventoryOutput, Collections.singletonList(itemStack))) {
                ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventoryOutput, (ItemStack)this.inventoryInput.extractItem(0, this.inventoryInput.getStackInSlot(0).func_190916_E(), false), (boolean)false);
                this.requestUpdateRecyclingRecipe();
            } else {
                this.recycleReset();
                if (this.isStartedPermanently()) {
                    this.setStartedPermanently(false);
                }
                LangKey.MESSAGE_NOT_ENOUGH_OUTPUT_SLOTS.sendMessage((PlayerEntity)this.getPlayer(), new Object[0]);
            }
        }
    }

    public boolean recycle() {
        RecyclingManager.RecycleOutput recycleOutput;
        assert (this.field_145850_b != null && !this.field_145850_b.field_72995_K);
        ServerPlayerEntity player = this.getPlayer();
        boolean recycled = false;
        ItemStack itemStack = this.getItemStack();
        ItemStack diskStack = this.getDiskStack();
        ItemStack bookStack = this.getBookStack();
        ItemStack bulbStack = this.getBulbStack();
        if (!(itemStack.func_190926_b() || diskStack.func_190926_b() || (recycleOutput = RecyclingManager.getInstance().getResultStack(new RecyclingManager.RecycleInput(this.recipes, itemStack, diskStack, bookStack, bulbStack), this.field_145850_b)).getItemConsumed() == 0 || recycleOutput.isRecipeAvailable() && recycleOutput.isRecipeDisabled())) {
            Helper.mergeStackInList(recycleOutput.getItems());
            if (!Helper.canInsertInInventory((IItemHandlerModifiable)this.inventoryOutput, recycleOutput.getItems())) {
                LangKey.MESSAGE_NOT_ENOUGH_OUTPUT_SLOTS.sendMessage((PlayerEntity)player, new Object[0]);
            } else if (!recycleOutput.isRecipeAvailable() || itemStack.func_190916_E() >= recycleOutput.getItemConsumed() || !this.isStartedPermanently()) {
                boolean canRecycle = ((ItemDisk)diskStack.func_77973_b()).canGrind(itemStack);
                if (canRecycle) {
                    boolean loss = false;
                    float chance = 1.5625f + this.getTermalFactor();
                    chance /= (float)(EnchantmentHelper.func_82781_a((ItemStack)diskStack).getOrDefault(Enchantments.field_185308_t, 0) + 1);
                    if (Math.random() * 100.0 < (double)chance) {
                        loss = true;
                    }
                    if (!loss) {
                        recycleOutput.getItems().forEach(s -> ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventoryOutput, (ItemStack)s, (boolean)false));
                    } else {
                        if (player != null) {
                            ModTriggers.RECYCLE_3.trigger(player);
                        }
                        LangKey.MESSAGE_LOSS.sendMessage((PlayerEntity)player, new Object[0]);
                    }
                } else {
                    LangKey.MESSAGE_DISK_LEVEL_TOO_LOW.sendMessage((PlayerEntity)player, itemStack.func_200301_q().getString());
                }
                if (canRecycle) {
                    if (recycleOutput.getItemConsumed() > 0) {
                        itemStack.func_190918_g(recycleOutput.getItemConsumed());
                        if (itemStack.func_190926_b()) {
                            this.setItemStack(ItemStack.field_190927_a);
                        }
                    }
                    if (recycleOutput.getBookConsumed() > 0) {
                        bookStack.func_190918_g(recycleOutput.getBookConsumed());
                        if (bookStack.func_190926_b()) {
                            this.setBookStack(ItemStack.field_190927_a);
                        }
                    }
                    if (recycleOutput.getBulbConsumed() > 0) {
                        bulbStack.func_190918_g(recycleOutput.getBulbConsumed());
                        if (bulbStack.func_190926_b()) {
                            this.setBulbStack(ItemStack.field_190927_a);
                        }
                    }
                    if (recycleOutput.getXp() > 0) {
                        BlockPos p = this.func_174877_v();
                        this.field_145850_b.func_217376_c((Entity)new ExperienceOrbEntity(this.field_145850_b, (double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.5, (double)p.func_177952_p() + 0.5, recycleOutput.getXp()));
                    }
                }
                if (recycleOutput.getDiskConsumed() > 0 && diskStack.func_96631_a(1, Helper.random, player)) {
                    this.setDiskStack(ItemStack.field_190927_a);
                    if (player != null) {
                        ModTriggers.RECYCLE_2.trigger(player);
                    }
                    LangKey.MESSAGE_DISK_BROKEN.sendMessage((PlayerEntity)player, new Object[0]);
                }
                if (canRecycle) {
                    recycleOutput.getContent().forEach(s -> InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)s));
                }
                recycled = canRecycle;
            }
        }
        if (recycled) {
            if (player != null) {
                ModTriggers.RECYCLE_1.trigger(player);
            }
            this.requestUpdateRecyclingRecipe();
        }
        return recycled;
    }

    private void supplyItemSlot() {
        if (this.supplyItemSlotTime > System.currentTimeMillis() - 500L) {
            return;
        }
        this.supplyItemSlotTime = System.currentTimeMillis();
        ItemStack itemStack = this.getItemStack();
        if (itemStack.func_190926_b()) {
            for (int slotIndex = 1; slotIndex < this.inventoryInput.getSlots(); ++slotIndex) {
                ItemStack slotItemStack = this.inventoryInput.getStackInSlot(slotIndex);
                if (slotItemStack.func_190926_b()) continue;
                this.inventoryInput.insertItem(0, this.inventoryInput.extractItem(slotIndex, slotItemStack.func_190916_E(), false), false);
                this.requestUpdateRecyclingRecipe();
                break;
            }
            return;
        }
        if (this.isStartedPermanently() && itemStack.func_190916_E() < itemStack.func_77976_d()) {
            for (int slotIndex = 1; slotIndex < this.inventoryInput.getSlots(); ++slotIndex) {
                ItemStack slotItemStack = this.inventoryInput.getStackInSlot(slotIndex);
                if (slotItemStack.func_77973_b() != itemStack.func_77973_b()) continue;
                this.inventoryInput.insertItem(0, this.inventoryInput.extractItem(slotIndex, 1, false), false);
                break;
            }
        }
    }

    private void supplyDiskSlot() {
        if (this.supplyDiskSlotTime > System.currentTimeMillis() - 500L) {
            return;
        }
        this.supplyDiskSlotTime = System.currentTimeMillis();
        ItemStack diskStack = this.getDiskStack();
        if (diskStack.func_190926_b()) {
            if (this.isStartedPermanently()) {
                this.setStartedPermanently(false);
            }
            return;
        }
    }

    private void updateBlockState() {
        if (this.blockStateUpdated > System.currentTimeMillis() - 500L) {
            return;
        }
        this.blockStateUpdated = System.currentTimeMillis();
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)BlockRecycler.ENABLED, (Comparable)Boolean.valueOf(this.isStarted() || this.isStartedPermanently())));
    }

    private void updateTemperature() {
        if (this.temperatureDownUpdated < System.currentTimeMillis() - 1000L) {
            this.temperatureDownUpdated = System.currentTimeMillis();
            Stream.of(this.func_174877_v().func_177978_c(), this.func_174877_v().func_177974_f(), this.func_174877_v().func_177968_d(), this.func_174877_v().func_177976_e(), this.func_174877_v().func_177984_a(), this.func_174877_v().func_177977_b()).forEach(p -> {
                BlockState blockState = this.field_145850_b.func_180495_p(p);
                if (blockState.func_177230_c() == Blocks.field_150350_a) {
                    --this.temperature;
                }
                if (blockState.func_177230_c() == Blocks.field_150355_j) {
                    this.temperature -= 2;
                }
                if (blockState.func_177230_c() == Blocks.field_150432_aD || blockState.func_177230_c() == Blocks.field_205164_gk || blockState.func_177230_c() == Blocks.field_185778_de || blockState.func_177230_c() == Blocks.field_150403_cj) {
                    this.temperature -= 4;
                }
                if (blockState.func_177230_c() == Blocks.field_150353_l) {
                    ++this.temperature;
                }
            });
        }
        if (this.temperatureUpUpdated < System.currentTimeMillis() - 500L) {
            this.temperatureUpUpdated = System.currentTimeMillis();
            if (this.recycleItemStart != 0L) {
                ++this.temperature;
                if (this.temperature >= 8 && this.checkHeatEmission()) {
                    this.temperature -= 8;
                }
                this.checkHeatExplosion();
            }
        }
        if (this.temperature < 0) {
            this.temperature = 0;
        }
        if (this.temperature > 255) {
            this.temperature = 255;
        }
        this.setTemperature(this.temperature);
    }

    private boolean checkHeatEmission() {
        float chance = this.getTermalFactor();
        if ((double)chance < Math.random()) {
            return false;
        }
        World world = this.func_145831_w();
        BlockPos firePosition = this.func_174877_v().func_177963_a((double)Math.round((Math.random() - 0.5) * 2.0), (double)Math.round((Math.random() - 0.5) * 2.0), (double)Math.round((Math.random() - 0.5) * 2.0));
        BlockState fireBlock = world.func_180495_p(firePosition);
        if (!AbstractFireBlock.func_220055_a((IWorldReader)world, (BlockPos)firePosition, (Direction)Direction.UP)) {
            firePosition = firePosition.func_177984_a();
        }
        fireBlock = world.func_180495_p(firePosition);
        if (AbstractFireBlock.func_220055_a((IWorldReader)world, (BlockPos)firePosition, (Direction)Direction.UP)) {
            world.func_184133_a(null, firePosition, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, Helper.random.nextFloat() * 0.4f + 0.8f);
            fireBlock = AbstractFireBlock.func_235326_a_((IBlockReader)world, (BlockPos)firePosition);
            world.func_180501_a(firePosition, fireBlock, 11);
            return true;
        }
        return false;
    }

    private float getTermalFactor() {
        float threshold = 0.1f;
        return (float)Math.pow(threshold / (threshold + 1.0f - (float)this.temperature / 256.0f), 3.0);
    }

    private void checkHeatExplosion() {
        if (this.temperature > 255) {
            ModTriggers.RECYCLE_4.trigger(this.getPlayer());
            BlockPos blockPosition = this.func_174877_v();
            this.func_145831_w().func_217385_a((Entity)this.getPlayer(), (double)blockPosition.func_177958_n() + 0.5, (double)blockPosition.func_177956_o() + 0.5, (double)blockPosition.func_177952_p() + 0.5, 4.0f, Explosion.Mode.DESTROY);
        }
    }

    private void playWorkingSound() {
        if (this.playWorkingSoundUpdated > System.currentTimeMillis() - 2000L) {
            return;
        }
        this.playWorkingSoundUpdated = System.currentTimeMillis();
        ModSounds.playSoundAllAround(ModSounds.RECYCLER_WORKING, SoundCategory.BLOCKS, this.field_145850_b, this.field_174879_c, 0.5f, 0.5f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f);
        for (int i = 0; i < 4; ++i) {
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)this.field_174879_c.func_177958_n() + Helper.random.nextDouble(), (double)this.field_174879_c.func_177956_o() + Helper.random.nextDouble(), (double)this.field_174879_c.func_177952_p() + Helper.random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    private void playRecycleSound() {
        if (this.playRecycleSoundUpdated > System.currentTimeMillis() - 1000L) {
            return;
        }
        this.playRecycleSoundUpdated = System.currentTimeMillis();
        ModSounds.playSoundAllAround(ModSounds.RECYCLER, SoundCategory.BLOCKS, this.field_145850_b, this.field_174879_c, 0.5f, 0.5f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.completeInitialization();
        this.supplyItemSlot();
        this.supplyDiskSlot();
        this.updateRecyclingRecipe();
        this.updateBlockState();
        this.updateTemperature();
        if (!this.isStarted() && !this.isStartedPermanently()) {
            if (this.recycleItemStart != 0L) {
                this.recycleReset();
            }
            return;
        }
        ItemStack diskStack = this.getDiskStack();
        if (diskStack.func_190926_b()) {
            this.setStarted(false);
            this.recycleReset();
            return;
        }
        ItemStack itemStack = this.getItemStack();
        if (itemStack.func_190926_b()) {
            this.setStarted(false);
            this.recycleReset();
            return;
        }
        this.playWorkingSound();
        this.recycleProggress(diskStack);
        this.recycle(itemStack);
    }

    public void requestUpdateRecyclingRecipe() {
        this.requireRecipeUpdate = true;
    }

    public void updateRecyclingRecipe() {
        if (!this.requireRecipeUpdate) {
            return;
        }
        this.requireRecipeUpdate = false;
        RecyclingManager.RecycleOutput recycleOutput = RecyclingManager.getInstance().getResultStack(new RecyclingManager.RecycleInput(this.recipes, this.getItemStack(), this.getDiskStack(), this.getBookStack(), this.getBulbStack()), this.field_145850_b);
        for (int slotId = 0; slotId < this.inventoryVisual.getSlots(); ++slotId) {
            if (slotId < recycleOutput.getItems().size()) {
                ItemStack outputStack = recycleOutput.getItems().get(slotId);
                ItemStack stackInSlot = this.inventoryVisual.getStackInSlot(slotId);
                if (ItemStack.func_77989_b((ItemStack)stackInSlot, (ItemStack)outputStack)) continue;
                this.inventoryVisual.setStackInSlot(slotId, outputStack);
                continue;
            }
            this.inventoryVisual.setStackInSlot(slotId, ItemStack.field_190927_a);
        }
        this.setRecipeItemInput(recycleOutput.getItemConsumed());
        this.setRecipeDiskInput(recycleOutput.getDiskConsumed());
        this.setRecipeBookInput(recycleOutput.getBookConsumed());
        this.setRecipeAvailable(recycleOutput.isRecipeAvailable());
        this.setRecipeAmbiguous(recycleOutput.isRecipeAmbiguous());
        this.setRecipeDisabled(recycleOutput.isRecipeDisabled());
        ModRecycler.LOGGER.debug("Recipe updated");
        if (this.previousItem != this.getItemStack().func_77973_b()) {
            this.recycleReset();
        } else if (this.isRecipeAvailable() && this.previousItemCount < this.getRecipeItemInput() && this.previousItemCount < this.getItemStack().func_190916_E()) {
            this.recycleStaledReset();
        }
        this.previousItem = this.getItemStack().func_77973_b();
        this.previousItemCount = this.getItemStack().func_190916_E();
    }

    public ITextComponent func_200200_C_() {
        return new TranslationTextComponent("corail_recycler_ne.block.recycler.name");
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TranslationTextComponent(this.customName) : this.func_200200_C_();
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.func_145818_k_() ? new TranslationTextComponent(this.customName) : null;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == Direction.DOWN) {
                return LazyOptional.of(() -> this.inventoryOutput);
            }
            if (side == Direction.UP) {
                return LazyOptional.of(() -> this.inventoryInput);
            }
            return LazyOptional.of(() -> this.inventoryWorking);
        }
        return super.getCapability(cap, side);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeShareData(compound);
        compound.func_74768_a("version", 3);
        compound.func_218657_a("invent_input", (INBT)this.inventoryInput.serializeNBT());
        compound.func_218657_a("invent_working", (INBT)this.inventoryWorking.serializeNBT());
        compound.func_218657_a("invent_output", (INBT)this.inventoryOutput.serializeNBT());
        return compound;
    }

    private CompoundNBT writeShareData(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.func_145818_k_()) {
            compound.func_74778_a("custom_name", this.customName);
        }
        compound.func_74768_a("temperature", this.temperature);
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.readSharedData(state, compound);
        int version = compound.func_74762_e("version");
        if (version == 3) {
            this.inventoryInput.deserializeNBT(compound.func_74775_l("invent_input"));
            this.inventoryWorking.deserializeNBT(compound.func_74775_l("invent_working"));
            this.inventoryOutput.deserializeNBT(compound.func_74775_l("invent_output"));
        } else {
            this.itemsToThrowAway = Stream.of("invent_input", "invent_working", "invent_output").flatMap(k -> {
                ItemStackHandler itemStackHandler = new ItemStackHandler();
                itemStackHandler.deserializeNBT(compound.func_74775_l(k));
                return IntStream.range(0, itemStackHandler.getSlots()).mapToObj(arg_0 -> ((ItemStackHandler)itemStackHandler).getStackInSlot(arg_0)).filter(s -> !s.func_190926_b());
            }).collect(Collectors.toCollection(NonNullList::func_191196_a));
        }
    }

    private void readSharedData(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_150297_b("custom_name", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        this.temperature = compound.func_74762_e("temperature");
    }

    private void completeInitialization() {
        if (this.itemsToThrowAway != null) {
            this.itemsToThrowAway.removeIf(s -> {
                try {
                    BlockPos p = this.func_174877_v().func_177984_a();
                    InventoryHelper.func_180173_a((World)this.field_145850_b, (double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), (ItemStack)s);
                }
                catch (Throwable t) {
                    return false;
                }
                return true;
            });
            if (this.itemsToThrowAway.size() > 0) {
                ModRecycler.LOGGER.warn("Unable to spawn items: {}", this.itemsToThrowAway);
            }
            this.itemsToThrowAway = null;
        }
    }

    public CompoundNBT func_189517_E_() {
        return this.writeShareData(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    public RecipeHolder getRecipeHolder(ItemStack itemStack) {
        return this.recipes.get(itemStack.func_77973_b());
    }

    public void updateRecyclingRecipeFromPlayerRecipeBook(PlayerEntity player) {
        this.recipes.clear();
        if (this.recipesPlayerId != player.func_145782_y()) {
            this.recycleReset();
            this.setStarted(false);
            this.setStartedPermanently(false);
        }
        this.recipesPlayerId = player.func_145782_y();
        RecyclingManager.getInstance().updateRecyclingRecipeFromPlayerRecipeBook(player, this.recipes);
    }

    private ServerPlayerEntity getPlayer() {
        Function<Integer, ServerPlayerEntity> playerAccessor = playerId -> this.field_145850_b.func_217369_A().stream().filter(p -> p.func_145782_y() == playerId.intValue()).map(ServerPlayerEntity.class::cast).findFirst().orElse(null);
        return Stream.of(this.playerIn, this.lastPlayerIn).map(playerAccessor::apply).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public boolean canInteract(PlayerEntity player) {
        if (this.getPlayerIn() != 0 && this.getPlayerIn() != player.func_145782_y() && !player.func_195070_dx()) {
            LangKey.MESSAGE_ENGAGED.sendMessage(player, player.field_70170_p.func_217369_A().stream().filter(p -> p.func_145782_y() == this.getPlayerIn()).map(p -> p.func_145748_c_().getString()).findFirst().orElse("Invisible"));
            return false;
        }
        if (!this.func_174877_v().func_218137_a((IPosition)player.func_213303_ch(), 5.0)) {
            LangKey.MESSAGE_TOO_FAR.sendMessage(player, new Object[0]);
            return false;
        }
        return true;
    }

    public void engage(PlayerEntity player) {
        int entityId = player.func_145782_y();
        ModRecycler.LOGGER.debug("Recycler engaged by {}", (Object)entityId);
        this.setStateVersion(this.getStateVersion() + 1);
        this.lastPlayerIn = this.playerIn = entityId;
    }

    public void disarm(PlayerEntity player) {
        int entityId = player.func_145782_y();
        ModRecycler.LOGGER.debug("Recycler disarmed by {}", (Object)entityId);
        if (this.playerIn == entityId) {
            this.playerIn = 0;
        }
    }

    public static int getValue(int target, int pos, int len) {
        int mask = (1 << len) - 1;
        return target >> pos & mask;
    }

    public static int setValue(int target, int pos, int len, int value) {
        int mask = (1 << len) - 1;
        return target & ~(mask << pos) | (value & mask) << pos;
    }

    public static boolean getValue(int target, int pos) {
        return TileEntityRecycler.getValue(target, pos, 1) == 1;
    }

    public static int setValue(int target, int pos, boolean b) {
        return TileEntityRecycler.setValue(target, pos, 1, b ? 1 : 0);
    }

    public class TrackedData
    implements IIntArray {
        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return TileEntityRecycler.this.state;
                }
                case 1: {
                    return TileEntityRecycler.this.recipeState;
                }
                case 2: {
                    return TileEntityRecycler.this.playerIn;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityRecycler.this.state = value;
                    break;
                }
                case 1: {
                    TileEntityRecycler.this.recipeState = value;
                    break;
                }
                case 2: {
                    TileEntityRecycler.this.playerIn = value;
                }
            }
        }

        public int func_221478_a() {
            return 3;
        }
    }
}

