/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.recycler.util;

import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Helper {
    public static final Random random = new Random();

    public static int getRandom(int min, int maxInclusive) {
        return random.nextInt(maxInclusive - min + 1) + min;
    }

    public static boolean isValidPlayer(@Nullable PlayerEntity player) {
        return player != null && Helper.isNotFakePlayer((LivingEntity)player);
    }

    public static boolean isValidServerPlayer(@Nullable PlayerEntity player) {
        return player != null && !player.field_70170_p.field_72995_K && Helper.isNotFakePlayer((LivingEntity)player);
    }

    private static boolean isNotFakePlayer(LivingEntity entity) {
        return !(entity instanceof FakePlayer);
    }

    public static boolean areItemEqual(ItemStack s1, ItemStack s2) {
        return !s1.func_190926_b() && s1.func_77973_b() == s2.func_77973_b();
    }

    public static List<ItemStack> mergeStackInList(List<ItemStack> list) {
        block0: for (int i = 0; i < list.size(); ++i) {
            ItemStack currentStack = list.get(i);
            if (currentStack.func_190926_b() || !currentStack.func_77985_e() || currentStack.func_190916_E() >= currentStack.func_77976_d()) continue;
            for (int j = i + 1; j < list.size(); ++j) {
                int add;
                ItemStack lookStack = list.get(j);
                if (lookStack.func_190926_b() || !Helper.areItemEqual(currentStack, lookStack) || (add = Math.min(lookStack.func_190916_E(), currentStack.func_77976_d() - currentStack.func_190916_E())) <= 0) continue;
                lookStack.func_190918_g(add);
                currentStack.func_190917_f(add);
                if (currentStack.func_190916_E() == currentStack.func_77976_d()) continue block0;
            }
        }
        list.removeIf(ItemStack::func_190926_b);
        return list;
    }

    public static boolean canInsertInInventory(IItemHandlerModifiable inventory, List<ItemStack> items) {
        List slotSizes = IntStream.range(0, inventory.getSlots()).map(slotId -> {
            ItemStack stack = inventory.getStackInSlot(slotId);
            return stack.func_190926_b() ? 0 : stack.func_190916_E();
        }).boxed().collect(Collectors.toList());
        int emptySlots = (int)slotSizes.stream().filter(i -> i == 0).count();
        if (emptySlots >= items.size()) {
            return true;
        }
        int minCount = items.size() - emptySlots;
        block0: for (ItemStack stackIn : items) {
            if (minCount <= 0) {
                return true;
            }
            if (stackIn.func_190926_b()) {
                --minCount;
                continue;
            }
            if (!stackIn.func_77985_e()) continue;
            int left = stackIn.func_190916_E();
            for (int slotId2 = 0; slotId2 < inventory.getSlots(); ++slotId2) {
                int add;
                int stacksize;
                ItemStack currentStack = inventory.getStackInSlot(slotId2);
                if (!Helper.areItemEqual(stackIn, currentStack) || (stacksize = ((Integer)slotSizes.get(slotId2)).intValue()) >= currentStack.func_77976_d() || (add = Math.min(left, currentStack.func_77976_d() - stacksize)) <= 0) continue;
                slotSizes.set(slotId2, stacksize + add);
                if ((left -= add) > 0) continue;
                --minCount;
                continue block0;
            }
        }
        return minCount <= 0;
    }

    @Nonnull
    public static <T extends IForgeRegistryEntry> T getDefaultNotNull() {
        return null;
    }

    public static ITag<Item> getTag(ResourceLocation resourcelocation) {
        return TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(resourcelocation);
    }

    public static int getEnchantmentXp(Map<Enchantment, Integer> enchantments) {
        int l = 0;
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            Enchantment enchantment = entry.getKey();
            Integer level = entry.getValue();
            l += (enchantment.func_77321_a(level.intValue()) + enchantment.func_223551_b(level.intValue())) / 2;
        }
        return l;
    }
}

