/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.craftingstation;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class Configs {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;

    public static void onConfigChanged(ModConfig.ModConfigEvent e) {
        if (e.getConfig().getModId().equals("craftingstation")) {
            ServerConfig.blockentitytypes.clear();
            ((List)ServerConfig.blockEntityTypeStrings.get()).forEach(blockEntityType -> ServerConfig.blockentitytypes.add((TileEntityType<?>)ForgeRegistries.TILE_ENTITIES.getValue(new ResourceLocation(blockEntityType))));
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
    }

    public static class ServerConfig {
        static ForgeConfigSpec.ConfigValue<List<? extends String>> blockEntityTypeStrings;
        public static final Set<TileEntityType<?>> blockentitytypes;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("server");
            blockEntityTypeStrings = builder.comment("Blacklisted Block Entities").translation("text.craftingstation.config.blacklistedblockentities").defineList("blacklisted block entities", (List)Lists.newArrayList(), String.class::isInstance);
        }

        static {
            blockentitytypes = new HashSet();
        }
    }

    public static class ClientConfig {
        public static ForgeConfigSpec.BooleanValue showItemsInTable;

        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("client");
            showItemsInTable = builder.comment("Display Items in Table?").translation("text.craftingstation.config.displayitemsintable").define("display items in table", true);
            builder.pop();
        }
    }
}

