/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.craftingstation;

import com.tfar.craftingstation.util.CraftingStationItemHandler;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class CraftingInventoryPersistant
extends CraftingInventory {
    private boolean doNotCallUpdates;
    protected final CraftingStationItemHandler inv;

    public CraftingInventoryPersistant(Container eventHandler, CraftingStationItemHandler itemHandler) {
        super(eventHandler, 3, 3);
        this.inv = itemHandler;
        this.doNotCallUpdates = false;
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        this.validate(slot);
        return this.inv.getStackInSlot(slot);
    }

    public void validate(int slot) {
        if (this.isValid(slot)) {
            return;
        }
        throw new IndexOutOfBoundsException("Someone attempted to poll an outofbounds stack at slot " + slot + " report to them, NOT Crafting Station");
    }

    public boolean isValid(int slot) {
        return slot >= 0 && slot < this.func_70302_i_();
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int count) {
        this.validate(slot);
        ItemStack stack = this.inv.extractItem(slot, count, false);
        if (!stack.func_190926_b()) {
            this.onCraftMatrixChanged();
        }
        return stack;
    }

    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        this.validate(slot);
        this.inv.setStackInSlot(slot, stack);
        this.onCraftMatrixChanged();
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        this.validate(index);
        ItemStack s = this.func_70301_a(index);
        if (s.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.onCraftMatrixChanged();
        this.func_70299_a(index, ItemStack.field_190927_a);
        return s;
    }

    public NonNullList<ItemStack> getStackList() {
        return this.inv.getContents();
    }

    public boolean func_191420_l() {
        return IntStream.range(0, this.inv.getSlots()).allMatch(i -> this.inv.getStackInSlot(i).func_190926_b());
    }

    public void func_174888_l() {
    }

    public void setDoNotCallUpdates(boolean doNotCallUpdates) {
        this.doNotCallUpdates = doNotCallUpdates;
    }

    public void onCraftMatrixChanged() {
        if (!this.doNotCallUpdates) {
            this.field_70465_c.func_75130_a((IInventory)this);
        }
    }
}

