/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.craftingstation.client;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.tfar.craftingstation.CraftingStation;
import com.tfar.craftingstation.CraftingStationBlock;
import com.tfar.craftingstation.CraftingStationBlockEntity;
import com.tfar.craftingstation.client.ClientStuffs;
import net.minecraft.block.BlockState;
import net.minecraft.block.SlabBlock;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;

public class CraftingStationBlockEntityRenderer
extends TileEntityRenderer<CraftingStationBlockEntity> {
    public void render(CraftingStationBlockEntity blockEntity, double x, double y, double z, float partialTicks, int destroyStage) {
        if (this.field_147501_a.field_217666_g != null && blockEntity.func_145835_a(this.field_147501_a.field_217666_g.func_216785_c().field_72450_a, this.field_147501_a.field_217666_g.func_216785_c().field_72448_b, this.field_147501_a.field_217666_g.func_216785_c().field_72449_c) < 128.0) {
            double sixteenth = 0.0625;
            double shift = 0.189;
            BlockState storedState = blockEntity.func_195044_w();
            Direction facing = (Direction)storedState.func_177229_b((IProperty)CraftingStationBlock.FACING);
            double height = storedState.func_177230_c() == CraftingStation.Objects.crafting_station_slab ? (storedState.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM ? 0.5 : 1.0) : 1.0;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    double shiftZ;
                    double shiftX;
                    ItemStack item = blockEntity.input.getStackInSlot(j + 3 * i);
                    if (item.func_190926_b()) continue;
                    boolean isBlock = item.func_77973_b() instanceof BlockItem;
                    double blockScale = isBlock ? 0.25 : 0.125;
                    double offset = isBlock ? 0.0625 : 0.0;
                    double offset2 = isBlock ? 0.125 : 0.0;
                    double offset3 = 0.3109;
                    double shiftY = height + offset;
                    double x1 = offset2 / 2.0 - offset - 0.189 * (double)i + 0.689;
                    double z1 = 0.3109 - offset2 / 2.0 + offset + 0.189 * (double)i;
                    switch (facing) {
                        case NORTH: {
                            shiftX = 0.3109 + 0.189 * (double)j;
                            shiftZ = z1;
                            break;
                        }
                        case EAST: {
                            shiftX = x1;
                            shiftZ = 0.3109 + 0.189 * (double)j;
                            break;
                        }
                        case SOUTH: {
                            shiftX = 0.689 - 0.189 * (double)j;
                            shiftZ = x1;
                            break;
                        }
                        case WEST: {
                            shiftX = z1;
                            shiftZ = 0.689 - 0.189 * (double)j;
                            break;
                        }
                        default: {
                            throw new IllegalStateException(facing.toString());
                        }
                    }
                    GlStateManager.pushMatrix();
                    GlStateManager.enableBlend();
                    GlStateManager.translated((double)(x + shiftX), (double)(y + shiftY), (double)(z + shiftZ));
                    GlStateManager.rotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                    switch (facing) {
                        case WEST: {
                            GlStateManager.rotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                            break;
                        }
                        case SOUTH: {
                            break;
                        }
                        case EAST: {
                            GlStateManager.rotated((double)270.0, (double)0.0, (double)0.0, (double)1.0);
                            break;
                        }
                        case NORTH: {
                            GlStateManager.rotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                        }
                    }
                    GlStateManager.scaled((double)blockScale, (double)blockScale, (double)blockScale);
                    int light = blockEntity.func_145831_w().func_217338_b(blockEntity.func_174877_v().func_177984_a(), 0);
                    GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)(light % 65536), (float)(light / 65536));
                    ClientStuffs.mc.func_175599_af().func_181564_a(item, ItemCameraTransforms.TransformType.FIXED);
                    GlStateManager.popMatrix();
                }
            }
        }
    }
}

