/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.craftingstation.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.tfar.craftingstation.CraftingStationContainer;
import com.tfar.craftingstation.client.ClearButton;
import com.tfar.craftingstation.client.TabButton;
import com.tfar.craftingstation.network.C2SChangeContainerPacket;
import com.tfar.craftingstation.network.C2SClearPacket;
import com.tfar.craftingstation.network.PacketHandler;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.ModList;

public class CraftingStationScreen
extends ContainerScreen<CraftingStationContainer> {
    public static final ResourceLocation CRAFTING_TABLE_GUI_TEXTURES = new ResourceLocation("textures/gui/container/crafting_table.png");
    public static final ResourceLocation SCROLLBAR_AND_TAB = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final ResourceLocation SCROLLBAR_BACKGROUND_AND_TAB = new ResourceLocation("textures/gui/container/creative_inventory/tab_items.png");
    public static final ResourceLocation SECONDARY_GUI_TEXTURE = new ResourceLocation("craftingstation", "textures/gui/secondary.png");
    private double currentScroll;
    private boolean isScrolling = false;
    private int topRow = 0;

    public CraftingStationScreen(CraftingStationContainer p_i51094_1_, PlayerInventory p_i51094_2_, ITextComponent p_i51094_3_) {
        super((Container)p_i51094_1_, p_i51094_2_, p_i51094_3_);
    }

    protected void init() {
        super.init();
        if (((CraftingStationContainer)this.field_147002_h).hasSideContainers) {
            for (int i = 0; i < ((CraftingStationContainer)this.field_147002_h).containerStarts.size(); ++i) {
                this.addButton((Widget)new TabButton(this.field_147003_i - 120 + 20 * i, this.field_147009_r - 22, 22, 22, button -> this.changeContainer(((TabButton)button).index), i, ((CraftingStationContainer)this.field_147002_h).blocks.get(i)));
            }
        }
        if (!ModList.get().isLoaded("craftingtweaks")) {
            this.addButton((Widget)new ClearButton(this.field_147003_i + 85, this.field_147009_r + 16, 7, 7, b -> PacketHandler.INSTANCE.sendToServer((Object)new C2SClearPacket())));
        }
    }

    protected boolean func_195361_a(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        return super.func_195361_a(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton) && (!((CraftingStationContainer)this.field_147002_h).hasSideContainers || !this.func_195359_a(-126, -16, 126, 32 + this.field_147000_g, mouseX, mouseY));
    }

    public void changeContainer(int container) {
        PacketHandler.INSTANCE.sendToServer((Object)new C2SChangeContainerPacket(container));
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int p_146979_1_, int p_146979_2_) {
        this.font.func_211126_b(this.title.func_150254_d(), 28.0f, 6.0f, 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        if (((CraftingStationContainer)this.field_147002_h).hasSideContainers) {
            this.font.func_211126_b(((CraftingStationContainer)this.field_147002_h).containerNames.get(((CraftingStationContainer)this.field_147002_h).currentContainer).func_150254_d(), -120.0f, 6.0f, 0x404040);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(CRAFTING_TABLE_GUI_TEXTURES);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int i = this.field_147003_i;
        int i1 = i - 16;
        int i2 = i1 + 14;
        int j = (this.height - this.field_147000_g) / 2;
        if (((CraftingStationContainer)this.field_147002_h).hasSideContainers) {
            this.minecraft.func_110434_K().func_110577_a(SECONDARY_GUI_TEXTURE);
            this.blit(i - 130, j, 0, 0, this.field_146999_f, this.field_147000_g + 18);
            this.minecraft.func_110434_K().func_110577_a(SCROLLBAR_BACKGROUND_AND_TAB);
            int totalSlots = ((CraftingStationContainer)this.field_147002_h).getSlotCount();
            int slotsToDraw = 54;
            if (totalSlots < slotsToDraw) {
                slotsToDraw = totalSlots;
            } else if (this.hasScrollbar() && this.topRow == ((CraftingStationContainer)this.field_147002_h).getRows() - 9 && totalSlots % 6 != 0) {
                slotsToDraw = 48 + totalSlots % 6;
            }
            int offset = this.hasScrollbar() ? -126 : -118;
            for (int i3 = 0; i3 < slotsToDraw; ++i3) {
                int j1 = i3 % 6;
                int k1 = i3 / 6;
                this.blit(i + j1 * 18 + offset, 18 * k1 + j + 16, 8, 17, 18, 18);
            }
            if (this.hasScrollbar()) {
                this.blit(i - 17, j + 16, 174, 17, 14, 100);
                this.blit(i - 17, j + 67, 174, 18, 14, 111);
                this.minecraft.func_110434_K().func_110577_a(SCROLLBAR_AND_TAB);
                int k = (int)((double)(j + 17) + 145.0 * this.currentScroll);
                if (this.isScrolling && mouseX <= i2 && mouseX >= i1) {
                    this.blit(i - 16, k, 244, 0, 12, 15);
                } else {
                    this.blit(i - 16, k, 232, 0, 12, 15);
                }
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int scroll) {
        this.isScrolling = this.hasScrollbar();
        return super.mouseClicked(mouseX, mouseY, scroll);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (this.isScrolling) {
            int j = this.field_147009_r;
            int j1 = j + 24;
            int j2 = j1 + 145;
            int k = this.field_147003_i;
            int k1 = k - 16;
            int k2 = k1 + 14;
            if (mouseX <= (double)k2 && mouseX >= (double)k1) {
                this.currentScroll = (mouseY - (double)j1) / (double)((float)(j2 - j1) - 0.0f);
                this.currentScroll = MathHelper.func_151237_a((double)this.currentScroll, (double)0.0, (double)1.0);
                this.scrollTo(this.currentScroll);
            }
        }
        return super.mouseDragged(mouseX, mouseY, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int scroll) {
        this.isScrolling = false;
        return super.mouseReleased(mouseX, mouseY, scroll);
    }

    private boolean hasScrollbar() {
        return ((CraftingStationContainer)this.field_147002_h).getRows() > 9;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        if (this.hasScrollbar() && mouseX < (double)this.field_147003_i && mouseX > (double)(this.field_147003_i - 20)) {
            this.setTopRow((int)((double)this.topRow - scrollDelta), false);
            return true;
        }
        return false;
    }

    private void scrollTo(double scroll) {
        this.setTopRow((int)Math.round((double)(((CraftingStationContainer)this.field_147002_h).getRows() - 9) * scroll), true);
    }

    private void setTopRow(int offset, boolean smooth) {
        this.topRow = offset;
        if (this.topRow < 0) {
            this.topRow = 0;
        } else if (this.topRow > ((CraftingStationContainer)this.field_147002_h).getRows() - 9) {
            this.topRow = ((CraftingStationContainer)this.field_147002_h).getRows() - 9;
        }
        ((CraftingStationContainer)this.field_147002_h).updateSlotPositions(this.topRow);
        if (!smooth) {
            this.currentScroll = (double)this.topRow / (double)(((CraftingStationContainer)this.field_147002_h).getRows() - 9);
        }
    }
}

