/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.craftingstation.network;

import com.tfar.craftingstation.CraftingStationContainer;
import com.tfar.craftingstation.network.PacketHandler;
import com.tfar.craftingstation.network.S2CChangeContainerPacket;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class C2SChangeContainerPacket {
    private int newContainer;

    public C2SChangeContainerPacket() {
    }

    public C2SChangeContainerPacket(int newContainer) {
        this.newContainer = newContainer;
    }

    public C2SChangeContainerPacket(PacketBuffer buf) {
        this.newContainer = buf.readInt();
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.newContainer);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (ctx.get() == null || ((NetworkEvent.Context)ctx.get()).getSender() == null) {
                return;
            }
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            Container station = ((NetworkEvent.Context)ctx.get()).getSender().field_71070_bA;
            if (station instanceof CraftingStationContainer) {
                ((CraftingStationContainer)station).changeContainer(this.newContainer);
            }
            PacketHandler.INSTANCE.sendTo((Object)new S2CChangeContainerPacket(this.newContainer), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        });
        ctx.get().setPacketHandled(true);
    }
}

