/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.modules.logistics.block.inventories.FlexcrateContainer;
import com.simibubi.create.modules.logistics.block.inventories.FlexcrateScreen;
import com.simibubi.create.modules.logistics.item.filter.AttributeFilterContainer;
import com.simibubi.create.modules.logistics.item.filter.AttributeFilterScreen;
import com.simibubi.create.modules.logistics.item.filter.FilterContainer;
import com.simibubi.create.modules.logistics.item.filter.FilterScreen;
import com.simibubi.create.modules.schematics.block.SchematicTableContainer;
import com.simibubi.create.modules.schematics.block.SchematicTableScreen;
import com.simibubi.create.modules.schematics.block.SchematicannonContainer;
import com.simibubi.create.modules.schematics.block.SchematicannonScreen;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.network.IContainerFactory;

public enum AllContainers {
    SCHEMATIC_TABLE(SchematicTableContainer::new),
    SCHEMATICANNON(SchematicannonContainer::new),
    FLEXCRATE(FlexcrateContainer::new),
    FILTER(FilterContainer::new),
    ATTRIBUTE_FILTER(AttributeFilterContainer::new);

    public ContainerType<? extends Container> type;
    private ContainerType.IFactory<?> factory;

    private <C extends Container> AllContainers(IContainerFactory<C> factory) {
        this.factory = factory;
    }

    public static void register(RegistryEvent.Register<ContainerType<?>> event) {
        for (AllContainers container : AllContainers.values()) {
            container.type = (ContainerType)new ContainerType(container.factory).setRegistryName(new ResourceLocation("create", Lang.asId(container.name())));
            event.getRegistry().register(container.type);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerScreenFactories() {
        AllContainers.bind(SCHEMATIC_TABLE, SchematicTableScreen::new);
        AllContainers.bind(SCHEMATICANNON, SchematicannonScreen::new);
        AllContainers.bind(FLEXCRATE, FlexcrateScreen::new);
        AllContainers.bind(FILTER, FilterScreen::new);
        AllContainers.bind(ATTRIBUTE_FILTER, AttributeFilterScreen::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static <C extends Container, S extends Screen> void bind(AllContainers c, ScreenManager.IScreenFactory<C, S> factory) {
        ScreenManager.func_216911_a(c.type, factory);
    }
}

