/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.compat.jei.ConversionRecipe;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.modules.contraptions.components.crafter.MechanicalCraftingRecipe;
import com.simibubi.create.modules.contraptions.components.crusher.CrushingRecipe;
import com.simibubi.create.modules.contraptions.components.fan.SplashingRecipe;
import com.simibubi.create.modules.contraptions.components.millstone.MillingRecipe;
import com.simibubi.create.modules.contraptions.components.mixer.MixingRecipe;
import com.simibubi.create.modules.contraptions.components.press.PressingRecipe;
import com.simibubi.create.modules.contraptions.components.saw.CuttingRecipe;
import com.simibubi.create.modules.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.modules.contraptions.processing.ProcessingRecipeSerializer;
import com.simibubi.create.modules.curiosities.tools.SandPaperPolishingRecipe;
import com.simibubi.create.modules.curiosities.zapper.blockzapper.BlockzapperUpgradeRecipe;
import java.util.function.Supplier;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum AllRecipes {
    BLOCKZAPPER_UPGRADE(BlockzapperUpgradeRecipe.Serializer::new, (IRecipeType<? extends IRecipe<? extends IInventory>>)IRecipeType.field_222149_a),
    MECHANICAL_CRAFTING(MechanicalCraftingRecipe.Serializer::new),
    CRUSHING(AllRecipes.processingSerializer(CrushingRecipe::new)),
    MILLING(AllRecipes.processingSerializer(MillingRecipe::new)),
    SPLASHING(AllRecipes.processingSerializer(SplashingRecipe::new)),
    PRESSING(AllRecipes.processingSerializer(PressingRecipe::new)),
    CUTTING(AllRecipes.processingSerializer(CuttingRecipe::new)),
    MIXING(AllRecipes.processingSerializer(MixingRecipe::new)),
    SANDPAPER_POLISHING(AllRecipes.processingSerializer(SandPaperPolishingRecipe::new)),
    CONVERSION(AllRecipes.processingSerializer(ConversionRecipe::new));

    public IRecipeSerializer<?> serializer;
    public Supplier<IRecipeSerializer<?>> supplier;
    public IRecipeType<? extends IRecipe<? extends IInventory>> type;

    public <T extends IRecipeType<?>> T getType() {
        return (T)this.type;
    }

    private AllRecipes(Supplier<IRecipeSerializer<?>> supplier) {
        this(supplier, null);
    }

    private AllRecipes(Supplier<IRecipeSerializer<?>> supplier, IRecipeType<? extends IRecipe<? extends IInventory>> existingType) {
        this.supplier = supplier;
        this.type = existingType;
    }

    public static void register(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        ShapedRecipe.setCraftingSize((int)9, (int)9);
        for (AllRecipes r : AllRecipes.values()) {
            if (r.type == null) {
                r.type = AllRecipes.customType(Lang.asId(r.name()));
            }
            r.serializer = r.supplier.get();
            ResourceLocation location = new ResourceLocation("create", Lang.asId(r.name()));
            event.getRegistry().register((IForgeRegistryEntry)r.serializer.setRegistryName(location));
        }
    }

    private static <T extends IRecipe<?>> IRecipeType<T> customType(final String id) {
        return (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)new ResourceLocation("create", id), (Object)new IRecipeType<T>(){

            public String toString() {
                return "create:" + id;
            }
        });
    }

    private static Supplier<IRecipeSerializer<?>> processingSerializer(ProcessingRecipeSerializer.IRecipeFactory<? extends ProcessingRecipe<?>> factory) {
        return () -> new ProcessingRecipeSerializer(factory);
    }
}

