/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.CreateClient;
import com.simibubi.create.config.AllConfigs;
import com.simibubi.create.foundation.behaviour.filtering.FilteringHandler;
import com.simibubi.create.foundation.behaviour.scrollvalue.ScrollValueHandler;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.modules.contraptions.KineticDebugger;
import com.simibubi.create.modules.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.modules.contraptions.components.contraptions.ChassisRangeDisplay;
import com.simibubi.create.modules.contraptions.components.turntable.TurntableHandler;
import com.simibubi.create.modules.contraptions.relays.belt.item.BeltConnectorHandler;
import com.simibubi.create.modules.curiosities.zapper.terrainzapper.TerrainZapperRenderHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    private static final String itemPrefix = "item.create";
    private static final String blockPrefix = "block.create";

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        AnimationTickHolder.tick();
        if (!ClientEvents.isGameActive()) {
            return;
        }
        if (!KineticDebugger.isActive() && KineticTileEntityRenderer.rainbowMode) {
            KineticTileEntityRenderer.rainbowMode = false;
            CreateClient.bufferCache.invalidate();
        }
        ScreenOpener.tick();
        ClientEvents.onGameTick();
    }

    public static void onGameTick() {
        CreateClient.gameTick();
        BeltConnectorHandler.gameTick();
        TerrainZapperRenderHandler.tick();
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderWorldLastEvent event) {
        CreateClient.schematicHandler.render();
        KineticDebugger.renderSourceOutline();
        ChassisRangeDisplay.renderOutlines(event.getPartialTicks());
        TerrainZapperRenderHandler.render();
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        ClientEvents.onRenderHotbar();
    }

    public static void onRenderHotbar() {
        CreateClient.schematicHandler.renderOverlay();
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        boolean pressed;
        int key = event.getKey();
        boolean bl = pressed = event.getAction() != 0;
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        CreateClient.schematicHandler.onKeyInput(key, pressed);
    }

    @SubscribeEvent
    public static void onMouseScrolled(InputEvent.MouseScrollEvent event) {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        double delta = event.getScrollDelta();
        boolean cancelled = CreateClient.schematicHandler.mouseScrolled(delta) || CreateClient.schematicAndQuillHandler.mouseScrolled(delta) || FilteringHandler.onScroll(delta) || ScrollValueHandler.onScroll(delta);
        event.setCanceled(cancelled);
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseInputEvent event) {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        int button = event.getButton();
        boolean pressed = event.getAction() != 0;
        CreateClient.schematicHandler.onMouseInput(button, pressed);
        CreateClient.schematicAndQuillHandler.onMouseInput(button, pressed);
    }

    @SubscribeEvent
    public static void addToItemTooltip(ItemTooltipEvent event) {
        if (!((Boolean)AllConfigs.CLIENT.tooltips.get()).booleanValue()) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        String translationKey = stack.func_77973_b().func_77667_c(stack);
        if (!translationKey.startsWith(itemPrefix) && !translationKey.startsWith(blockPrefix)) {
            return;
        }
        if (TooltipHelper.hasTooltip(stack)) {
            List itemTooltip = event.getToolTip();
            ArrayList<ITextComponent> toolTip = new ArrayList<ITextComponent>();
            toolTip.add((ITextComponent)itemTooltip.remove(0));
            TooltipHelper.getTooltip(stack).addInformation(toolTip);
            itemTooltip.addAll(0, toolTip);
        }
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (!ClientEvents.isGameActive()) {
            return;
        }
        TurntableHandler.gameRenderTick();
    }

    protected static boolean isGameActive() {
        return Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71439_g != null;
    }
}

