/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllContainers;
import com.simibubi.create.AllEntities;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllParticles;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.ResourceReloadHandler;
import com.simibubi.create.foundation.block.IHaveCustomBlockModel;
import com.simibubi.create.foundation.block.connected.IHaveConnectedTextures;
import com.simibubi.create.foundation.block.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.item.IHaveCustomItemModel;
import com.simibubi.create.foundation.utility.SuperByteBufferCache;
import com.simibubi.create.modules.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.modules.contraptions.components.contraptions.ChassisRangeDisplay;
import com.simibubi.create.modules.contraptions.components.contraptions.ContraptionRenderer;
import com.simibubi.create.modules.schematics.ClientSchematicLoader;
import com.simibubi.create.modules.schematics.client.SchematicAndQuillHandler;
import com.simibubi.create.modules.schematics.client.SchematicHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class CreateClient {
    public static ClientSchematicLoader schematicSender;
    public static SchematicHandler schematicHandler;
    public static SchematicAndQuillHandler schematicAndQuillHandler;
    public static SuperByteBufferCache bufferCache;

    public static void addListeners(IEventBus modEventBus) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(CreateClient::clientInit);
            modEventBus.addListener(CreateClient::onModelBake);
            modEventBus.addListener(CreateClient::onModelRegistry);
            modEventBus.addListener(CreateClient::onTextureStitch);
            modEventBus.addListener(AllParticles::registerFactories);
        });
    }

    public static void clientInit(FMLClientSetupEvent event) {
        schematicSender = new ClientSchematicLoader();
        schematicHandler = new SchematicHandler();
        schematicAndQuillHandler = new SchematicAndQuillHandler();
        bufferCache = new SuperByteBufferCache();
        bufferCache.registerCompartment(KineticTileEntityRenderer.KINETIC_TILE);
        bufferCache.registerCompartment(ContraptionRenderer.CONTRAPTION, 20L);
        AllKeys.register();
        AllContainers.registerScreenFactories();
        AllTileEntities.registerRenderers();
        AllItems.registerColorHandlers();
        AllBlocks.registerColorHandlers();
        AllEntities.registerRenderers();
        IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
        if (resourceManager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)resourceManager).func_219534_a((IFutureReloadListener)new ResourceReloadHandler());
        }
    }

    public static void gameTick() {
        schematicSender.tick();
        schematicAndQuillHandler.tick();
        schematicHandler.tick();
        ChassisRangeDisplay.clientTick();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        if (!event.getMap().getBasePath().equals("textures")) {
            return;
        }
        event.addSprite(new ResourceLocation("create", "block/belt_animated"));
        for (AllBlocks allBlocks : AllBlocks.values()) {
            Block block = allBlocks.get();
            if (!(block instanceof IHaveConnectedTextures)) continue;
            for (SpriteShiftEntry spriteShiftEntry : ((IHaveConnectedTextures)block).getBehaviour().getAllCTShifts()) {
                event.addSprite(spriteShiftEntry.getTargetResourceLocation());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelBake(ModelBakeEvent event) {
        Map modelRegistry = event.getModelRegistry();
        AllBlockPartials.onModelBake(event);
        for (AllBlocks allBlocks : AllBlocks.values()) {
            Block block = allBlocks.get();
            if (!(block instanceof IHaveCustomBlockModel)) continue;
            CreateClient.swapModels((Map<ResourceLocation, IBakedModel>)modelRegistry, CreateClient.getAllBlockStateModelLocations(allBlocks), ((IHaveCustomBlockModel)block)::createModel);
        }
        for (Enum enum_ : AllItems.values()) {
            if (!(((AllItems)enum_).get() instanceof IHaveCustomItemModel)) continue;
            CreateClient.swapModels((Map<ResourceLocation, IBakedModel>)modelRegistry, CreateClient.getItemModelLocation((AllItems)enum_), arg_0 -> CreateClient.lambda$onModelBake$2((AllItems)enum_, event, arg_0));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelRegistry(ModelRegistryEvent event) {
        AllBlockPartials.onModelRegistry(event);
        for (AllItems item : AllItems.values()) {
            if (!(item.get() instanceof IHaveCustomItemModel)) continue;
            ((IHaveCustomItemModel)item.get()).createModel(null).getModelLocations().forEach(ModelLoader::addSpecialModel);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static ModelResourceLocation getItemModelLocation(AllItems item) {
        return new ModelResourceLocation(item.get().getRegistryName(), "inventory");
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static List<ModelResourceLocation> getAllBlockStateModelLocations(AllBlocks block) {
        ArrayList<ModelResourceLocation> models = new ArrayList<ModelResourceLocation>();
        block.get().func_176194_O().func_177619_a().forEach(state -> models.add(CreateClient.getBlockModelLocation(block, BlockModelShapes.func_209552_a((Map)state.func_206871_b()))));
        return models;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static ModelResourceLocation getBlockModelLocation(AllBlocks block, String suffix) {
        return new ModelResourceLocation(block.get().getRegistryName(), suffix);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static <T extends IBakedModel> void swapModels(Map<ResourceLocation, IBakedModel> modelRegistry, ModelResourceLocation location, Function<IBakedModel, T> factory) {
        modelRegistry.put((ResourceLocation)location, (IBakedModel)factory.apply(modelRegistry.get(location)));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static <T extends IBakedModel> void swapModels(Map<ResourceLocation, IBakedModel> modelRegistry, List<ModelResourceLocation> locations, Function<IBakedModel, T> factory) {
        locations.forEach(location -> CreateClient.swapModels(modelRegistry, location, factory));
    }

    private static /* synthetic */ CustomRenderedItemModel lambda$onModelBake$2(AllItems item, ModelBakeEvent event, IBakedModel m) {
        return ((IHaveCustomItemModel)item.get()).createModel(m).loadPartials(event);
    }
}

