/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei;

import com.google.common.base.Predicate;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllRecipes;
import com.simibubi.create.compat.jei.SlotMover;
import com.simibubi.create.compat.jei.category.BlastingViaFanCategory;
import com.simibubi.create.compat.jei.category.BlockCuttingCategory;
import com.simibubi.create.compat.jei.category.BlockzapperUpgradeCategory;
import com.simibubi.create.compat.jei.category.CrushingCategory;
import com.simibubi.create.compat.jei.category.MechanicalCraftingCategory;
import com.simibubi.create.compat.jei.category.MillingCategory;
import com.simibubi.create.compat.jei.category.MixingCategory;
import com.simibubi.create.compat.jei.category.MysteriousItemConversionCategory;
import com.simibubi.create.compat.jei.category.PackingCategory;
import com.simibubi.create.compat.jei.category.PolishingCategory;
import com.simibubi.create.compat.jei.category.PressingCategory;
import com.simibubi.create.compat.jei.category.SawingCategory;
import com.simibubi.create.compat.jei.category.SmokingViaFanCategory;
import com.simibubi.create.compat.jei.category.SplashingCategory;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.modules.contraptions.components.mixer.MixingRecipe;
import com.simibubi.create.modules.contraptions.components.press.MechanicalPressTileEntity;
import com.simibubi.create.modules.logistics.block.inventories.FlexcrateScreen;
import com.simibubi.create.modules.schematics.block.SchematicannonScreen;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

@JeiPlugin
public class CreateJEI
implements IModPlugin {
    private static ResourceLocation ID = new ResourceLocation("create", "jei_plugin");
    private MillingCategory millingCategory = new MillingCategory();
    private CrushingCategory crushingCategory = new CrushingCategory();
    private SplashingCategory splashingCategory = new SplashingCategory();
    private SmokingViaFanCategory smokingCategory;
    private PressingCategory pressingCategory = new PressingCategory();
    private BlastingViaFanCategory blastingCategory;
    private BlockzapperUpgradeCategory blockzapperCategory;
    private MixingCategory mixingCategory;
    private SawingCategory sawingCategory;
    private BlockCuttingCategory blockCuttingCategory;
    private PackingCategory packingCategory;
    private PolishingCategory polishingCategory;
    private MysteriousItemConversionCategory mysteryConversionCategory;
    private MechanicalCraftingCategory mechanicalCraftingCategory;

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public CreateJEI() {
        this.smokingCategory = new SmokingViaFanCategory();
        this.blastingCategory = new BlastingViaFanCategory();
        this.blockzapperCategory = new BlockzapperUpgradeCategory();
        this.mixingCategory = new MixingCategory();
        this.sawingCategory = new SawingCategory();
        this.blockCuttingCategory = new BlockCuttingCategory();
        this.packingCategory = new PackingCategory();
        this.polishingCategory = new PolishingCategory();
        this.mysteryConversionCategory = new MysteriousItemConversionCategory();
        this.mechanicalCraftingCategory = new MechanicalCraftingCategory();
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{AllItems.PLACEMENT_HANDGUN.get()});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{this.millingCategory, this.crushingCategory, this.splashingCategory, this.pressingCategory, this.smokingCategory, this.blastingCategory, this.blockzapperCategory, this.mixingCategory, this.sawingCategory, this.blockCuttingCategory, this.packingCategory, this.polishingCategory, this.mysteryConversionCategory, this.mechanicalCraftingCategory});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(CreateJEI.findRecipes(AllRecipes.MILLING), this.millingCategory.getUid());
        registration.addRecipes(CreateJEI.findRecipes(AllRecipes.CRUSHING), this.crushingCategory.getUid());
        registration.addRecipes(CreateJEI.findRecipesByTypeExcluding(AllRecipes.MILLING.getType(), AllRecipes.CRUSHING.getType()), this.crushingCategory.getUid());
        registration.addRecipes(CreateJEI.findRecipes(AllRecipes.SPLASHING), this.splashingCategory.getUid());
        registration.addRecipes(CreateJEI.findRecipes(AllRecipes.PRESSING), this.pressingCategory.getUid());
        registration.addRecipes(CreateJEI.findRecipesById(AllRecipes.BLOCKZAPPER_UPGRADE.serializer.getRegistryName()), this.blockzapperCategory.getUid());
        registration.addRecipes(CreateJEI.findRecipesByType(IRecipeType.field_222152_d), this.smokingCategory.getUid());
        registration.addRecipes(CreateJEI.findRecipesByTypeExcluding(IRecipeType.field_222150_b, IRecipeType.field_222152_d), this.blastingCategory.getUid());
        registration.addRecipes(CreateJEI.findRecipes(AllRecipes.MIXING), this.mixingCategory.getUid());
        registration.addRecipes((Collection)CreateJEI.findRecipes(r -> r.func_199559_b() == IRecipeSerializer.field_222158_b && !MechanicalPressTileEntity.canCompress((NonNullList<Ingredient>)r.func_192400_c())).stream().map(MixingRecipe::of).collect(Collectors.toList()), this.mixingCategory.getUid());
        registration.addRecipes(CreateJEI.findRecipes(AllRecipes.CUTTING), this.sawingCategory.getUid());
        registration.addRecipes(BlockCuttingCategory.CondensedBlockCuttingRecipe.condenseRecipes(CreateJEI.findRecipesByType(IRecipeType.field_222154_f)), this.blockCuttingCategory.getUid());
        registration.addRecipes(CreateJEI.findRecipes(r -> r instanceof ICraftingRecipe && MechanicalPressTileEntity.canCompress((NonNullList<Ingredient>)r.func_192400_c())), this.packingCategory.getUid());
        registration.addRecipes(CreateJEI.findRecipes(AllRecipes.SANDPAPER_POLISHING), this.polishingCategory.getUid());
        registration.addRecipes(MysteriousItemConversionCategory.getRecipes(), this.mysteryConversionCategory.getUid());
        registration.addRecipes(CreateJEI.findRecipes(r -> r.func_222127_g() == AllRecipes.MECHANICAL_CRAFTING.type), this.mechanicalCraftingCategory.getUid());
        registration.addRecipes(CreateJEI.findRecipes(r -> r.func_222127_g() == IRecipeType.field_222149_a && r.func_222127_g() != AllRecipes.MECHANICAL_CRAFTING.type && r instanceof ShapedRecipe), this.mechanicalCraftingCategory.getUid());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        ItemStack fan = new ItemStack((IItemProvider)AllBlocks.ENCASED_FAN.get());
        ItemStack splashingFan = fan.func_77946_l().func_200302_a((ITextComponent)new StringTextComponent(TextFormatting.RESET + Lang.translate("recipe.splashing.fan", new Object[0])));
        ItemStack smokingFan = fan.func_77946_l().func_200302_a((ITextComponent)new StringTextComponent(TextFormatting.RESET + Lang.translate("recipe.smokingViaFan.fan", new Object[0])));
        ItemStack blastingFan = fan.func_77946_l().func_200302_a((ITextComponent)new StringTextComponent(TextFormatting.RESET + Lang.translate("recipe.blastingViaFan.fan", new Object[0])));
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AllBlocks.MILLSTONE.get()), new ResourceLocation[]{this.millingCategory.getUid()});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AllBlocks.CRUSHING_WHEEL.get()), new ResourceLocation[]{this.crushingCategory.getUid()});
        registration.addRecipeCatalyst((Object)splashingFan, new ResourceLocation[]{this.splashingCategory.getUid()});
        registration.addRecipeCatalyst((Object)smokingFan, new ResourceLocation[]{this.smokingCategory.getUid()});
        registration.addRecipeCatalyst((Object)blastingFan, new ResourceLocation[]{this.blastingCategory.getUid()});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AllBlocks.MECHANICAL_PRESS.get()), new ResourceLocation[]{this.pressingCategory.getUid()});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AllItems.PLACEMENT_HANDGUN.get()), new ResourceLocation[]{this.blockzapperCategory.getUid()});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AllBlocks.MECHANICAL_MIXER.get()), new ResourceLocation[]{this.mixingCategory.getUid()});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AllBlocks.BASIN.get()), new ResourceLocation[]{this.mixingCategory.getUid()});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AllBlocks.SAW.get()), new ResourceLocation[]{this.sawingCategory.getUid()});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AllBlocks.SAW.get()), new ResourceLocation[]{this.blockCuttingCategory.getUid()});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Blocks.field_222430_lS), new ResourceLocation[]{this.blockCuttingCategory.getUid()});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AllBlocks.MECHANICAL_PRESS.get()), new ResourceLocation[]{this.packingCategory.getUid()});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AllBlocks.BASIN.get()), new ResourceLocation[]{this.packingCategory.getUid()});
        registration.addRecipeCatalyst((Object)AllItems.SAND_PAPER.asStack(), new ResourceLocation[]{this.polishingCategory.getUid()});
        registration.addRecipeCatalyst((Object)AllItems.RED_SAND_PAPER.asStack(), new ResourceLocation[]{this.polishingCategory.getUid()});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AllBlocks.MECHANICAL_CRAFTER.get()), new ResourceLocation[]{this.mechanicalCraftingCategory.getUid()});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(FlexcrateScreen.class, new SlotMover());
        registration.addGuiContainerHandler(SchematicannonScreen.class, new SlotMover());
    }

    private static List<IRecipe<?>> findRecipes(AllRecipes recipe) {
        return CreateJEI.findRecipesByType(recipe.type);
    }

    private static List<IRecipe<?>> findRecipes(Predicate<IRecipe<?>> pred) {
        return Minecraft.func_71410_x().field_71441_e.func_199532_z().func_199510_b().stream().filter(pred).collect(Collectors.toList());
    }

    private static List<IRecipe<?>> findRecipesByType(IRecipeType<?> type) {
        return Minecraft.func_71410_x().field_71441_e.func_199532_z().func_199510_b().stream().filter(r -> r.func_222127_g() == type).collect(Collectors.toList());
    }

    private static List<IRecipe<?>> findRecipesById(ResourceLocation id) {
        return Minecraft.func_71410_x().field_71441_e.func_199532_z().func_199510_b().stream().filter(r -> r.func_199559_b().getRegistryName().equals((Object)id)).collect(Collectors.toList());
    }

    private static List<IRecipe<?>> findRecipesByTypeExcluding(IRecipeType<?> type, IRecipeType<?> excludingType) {
        List<IRecipe<?>> byType = CreateJEI.findRecipesByType(type);
        List<IRecipe<?>> byExcludingType = CreateJEI.findRecipesByType(excludingType);
        byType.removeIf(recipe -> {
            for (IRecipe r : byExcludingType) {
                ItemStack[] matchingStacks = ((Ingredient)recipe.func_192400_c().get(0)).func_193365_a();
                if (matchingStacks.length == 0) {
                    return true;
                }
                if (!((Ingredient)r.func_192400_c().get(0)).test(matchingStacks[0])) continue;
                return true;
            }
            return false;
        });
        return byType;
    }
}

