/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.simibubi.create.ScreenResources;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.modules.contraptions.processing.ProcessingOutput;
import com.simibubi.create.modules.contraptions.processing.ProcessingRecipe;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public abstract class CreateRecipeCategory<T extends IRecipe<?>>
implements IRecipeCategory<T> {
    private ResourceLocation uid;
    private String name;
    private IDrawable icon;
    private IDrawable background;

    public CreateRecipeCategory(String id, IDrawable icon, IDrawable background) {
        this.uid = new ResourceLocation("create", id);
        this.name = id;
        this.background = background;
        this.icon = icon;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    public String getTitle() {
        return Lang.translate("recipe." + this.name, new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    protected static ScreenResources getRenderedSlot(IRecipe<?> recipe, int index) {
        ScreenResources jeiSlot = ScreenResources.JEI_SLOT;
        if (!(recipe instanceof ProcessingRecipe)) {
            return jeiSlot;
        }
        ProcessingRecipe processingRecipe = (ProcessingRecipe)recipe;
        List<ProcessingOutput> rollableResults = processingRecipe.getRollableResults();
        if (rollableResults.size() <= index) {
            return jeiSlot;
        }
        if (processingRecipe.getRollableResults().get(index).getChance() == 1.0f) {
            return jeiSlot;
        }
        return ScreenResources.JEI_CHANCE_SLOT;
    }

    protected static IDrawable emptyBackground(int width, int height) {
        return new EmptyBackground(width, height);
    }

    protected static IDrawable doubleItemIcon(IItemProvider item1, IItemProvider item2) {
        return new DoubleItemIcon(() -> new ItemStack(item1), () -> new ItemStack(item2));
    }

    protected static IDrawable itemIcon(IItemProvider item) {
        return new DoubleItemIcon(() -> new ItemStack(item), () -> ItemStack.field_190927_a);
    }

    protected static void addStochasticTooltip(IGuiItemStackGroup itemStacks, List<ProcessingOutput> results) {
        itemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (input) {
                return;
            }
            ProcessingOutput output = (ProcessingOutput)results.get(slotIndex - 1);
            if (output.getChance() != 1.0f) {
                tooltip.add(1, TextFormatting.GOLD + Lang.translate("recipe.processing.chance", (int)(output.getChance() * 100.0f)));
            }
        });
    }

    protected static void addCatalystTooltip(IGuiItemStackGroup itemStacks, Map<Integer, Float> catalystIndices) {
        itemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (!input) {
                return;
            }
            if (!catalystIndices.containsKey(slotIndex)) {
                return;
            }
            Float chance = (Float)catalystIndices.get(slotIndex);
            tooltip.add(1, TextFormatting.YELLOW + Lang.translate("recipe.processing.catalyst", new Object[0]));
            tooltip.add(2, TextFormatting.GOLD + Lang.translate("recipe.processing.chanceToReturn", (int)(chance.floatValue() * 100.0f)));
        });
    }
}

