/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.ScreenResources;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedMixer;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.modules.contraptions.components.mixer.MixingRecipe;
import com.simibubi.create.modules.contraptions.processing.ProcessingIngredient;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;

public class MixingCategory
extends CreateRecipeCategory<MixingRecipe> {
    private AnimatedMixer mixer = new AnimatedMixer();

    public MixingCategory() {
        super("mixing", MixingCategory.doubleItemIcon((IItemProvider)AllBlocks.MECHANICAL_MIXER.get(), (IItemProvider)AllBlocks.BASIN.get()), MixingCategory.emptyBackground(177, 70));
    }

    public Class<? extends MixingRecipe> getRecipeClass() {
        return MixingRecipe.class;
    }

    public void setIngredients(MixingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, MixingRecipe recipe, IIngredients ingredients) {
        int i;
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        NonNullList<Ingredient> recipeIngredients = recipe.func_192400_c();
        List<Pair<Ingredient, MutableInt>> actualIngredients = ItemHelper.condenseIngredients(recipeIngredients);
        HashMap<Integer, Float> catalystIndices = new HashMap<Integer, Float>(9);
        block0: for (int i2 = 0; i2 < actualIngredients.size(); ++i2) {
            for (ProcessingIngredient processingIngredient : recipe.getRollableIngredients()) {
                if (!processingIngredient.isCatalyst() || !ItemHelper.matchIngredients(processingIngredient.getIngredient(), (Ingredient)actualIngredients.get(i2).getKey())) continue;
                catalystIndices.put(i2, Float.valueOf(processingIngredient.getOutputChance()));
                continue block0;
            }
        }
        int size = actualIngredients.size();
        int xOffset = size < 3 ? (3 - size) * 19 / 2 : 0;
        for (i = 0; i < size; ++i) {
            Pair<Ingredient, MutableInt> ingredient = actualIngredients.get(i);
            itemStacks.init(i, true, 16 + xOffset + i % 3 * 19, 50 - i / 3 * 19);
            List<ItemStack> asList = Arrays.asList(((Ingredient)ingredient.getKey()).func_193365_a());
            itemStacks.set(i, asList.stream().map(stack -> {
                stack = stack.func_77946_l();
                stack.func_190920_e(((MutableInt)ingredient.getRight()).getValue().intValue());
                return stack;
            }).collect(Collectors.toList()));
        }
        itemStacks.init(i, false, 141, 50);
        itemStacks.set(i, recipe.func_77571_b().getStack());
        MixingCategory.addCatalystTooltip(itemStacks, catalystIndices);
    }

    public void draw(MixingRecipe recipe, double mouseX, double mouseY) {
        List<Pair<Ingredient, MutableInt>> actualIngredients = ItemHelper.condenseIngredients(recipe.func_192400_c());
        int size = actualIngredients.size();
        int xOffset = size < 3 ? (3 - size) * 19 / 2 : 0;
        for (int i = 0; i < size; ++i) {
            ScreenResources jeiSlot = ScreenResources.JEI_SLOT;
            for (ProcessingIngredient processingIngredient : recipe.getRollableIngredients()) {
                if (!processingIngredient.isCatalyst() || !ItemHelper.matchIngredients(processingIngredient.getIngredient(), (Ingredient)actualIngredients.get(i).getKey())) continue;
                jeiSlot = ScreenResources.JEI_CATALYST_SLOT;
                break;
            }
            jeiSlot.draw(16 + xOffset + i % 3 * 19, 50 - i / 3 * 19);
        }
        ScreenResources.JEI_SLOT.draw(141, 50);
        ScreenResources.JEI_DOWN_ARROW.draw(136, 32);
        ScreenResources.JEI_SHADOW.draw(81, 57);
        this.mixer.draw(this.getBackground().getWidth() / 2 + 20, 8);
    }
}

