/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.config;

import com.simibubi.create.config.CClient;
import com.simibubi.create.config.CCommon;
import com.simibubi.create.config.CServer;
import com.simibubi.create.config.ConfigBase;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class AllConfigs {
    static List<Pair<ConfigBase, ModConfig.Type>> configs = new ArrayList<Pair<ConfigBase, ModConfig.Type>>();
    public static CClient CLIENT = AllConfigs.register(CClient::new, ModConfig.Type.CLIENT);
    public static CCommon COMMON = AllConfigs.register(CCommon::new, ModConfig.Type.COMMON);
    public static CServer SERVER = AllConfigs.register(CServer::new, ModConfig.Type.SERVER);

    private static <T extends ConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            ConfigBase config = (ConfigBase)factory.get();
            config.registerAll((ForgeConfigSpec.Builder)builder);
            return config;
        });
        ConfigBase config = (ConfigBase)specPair.getLeft();
        config.specification = (ForgeConfigSpec)specPair.getRight();
        configs.add((Pair<ConfigBase, ModConfig.Type>)Pair.of((Object)config, (Object)side));
        return (T)config;
    }

    public static void registerAll() {
        ModLoadingContext ctx = ModLoadingContext.get();
        for (Pair<ConfigBase, ModConfig.Type> pair : configs) {
            ctx.registerConfig((ModConfig.Type)pair.getValue(), ((ConfigBase)pair.getKey()).specification);
        }
    }

    public static void onLoad(ModConfig.Loading event) {
        for (Pair<ConfigBase, ModConfig.Type> pair : configs) {
            if (((ConfigBase)pair.getKey()).specification != event.getConfig().getSpec()) continue;
            ((ConfigBase)pair.getKey()).onLoad();
        }
    }

    public static void onReload(ModConfig.ConfigReloading event) {
        for (Pair<ConfigBase, ModConfig.Type> pair : configs) {
            if (((ConfigBase)pair.getKey()).specification != event.getConfig().getSpec()) continue;
            ((ConfigBase)pair.getKey()).onReload();
        }
    }
}

