/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.config;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.config.ConfigBase;
import com.simibubi.create.config.StressConfigDefaults;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.modules.contraptions.base.KineticBlock;
import com.simibubi.create.modules.contraptions.components.flywheel.engine.EngineBlock;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;

public class CStress
extends ConfigBase {
    public Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> capacities = new HashMap<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>>();
    public Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> impacts = new HashMap<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>>();

    @Override
    protected void registerAll(ForgeConfigSpec.Builder builder) {
        builder.comment(new String[]{"", Comments.su, Comments.impact}).push("impact");
        for (AllBlocks block : AllBlocks.values()) {
            if (!(block.get() instanceof KineticBlock)) continue;
            this.initStressEntry(block, builder);
        }
        builder.pop();
        builder.comment(new String[]{"", Comments.su, Comments.capacity}).push("capacity");
        for (AllBlocks block : AllBlocks.values()) {
            if (!(block.get() instanceof KineticBlock) && !(block.get() instanceof EngineBlock)) continue;
            this.initStressCapacityEntry(block, builder);
        }
        builder.pop();
    }

    private void initStressEntry(AllBlocks block, ForgeConfigSpec.Builder builder) {
        String name = Lang.asId(block.name());
        double defaultStressImpact = StressConfigDefaults.getDefaultStressImpact(block);
        this.impacts.put(block.get().getRegistryName(), (ForgeConfigSpec.ConfigValue<Double>)builder.define(name, (Object)defaultStressImpact));
    }

    private void initStressCapacityEntry(AllBlocks block, ForgeConfigSpec.Builder builder) {
        double defaultStressCapacity = StressConfigDefaults.getDefaultStressCapacity(block);
        if (defaultStressCapacity == -1.0) {
            return;
        }
        String name = Lang.asId(block.name());
        this.capacities.put(block.get().getRegistryName(), (ForgeConfigSpec.ConfigValue<Double>)builder.define(name, (Object)defaultStressCapacity));
    }

    @Override
    public String getName() {
        return "stressValues.v1";
    }

    private static class Comments {
        static String su = "[in Stress Units]";
        static String impact = "Configure the individual stress impact of mechanical blocks. Note that this cost is doubled for every speed increase it receives.";
        static String capacity = "Configure how much stress a source can accommodate for.";

        private Comments() {
        }
    }
}

