/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.advancement;

import com.simibubi.create.foundation.advancement.CriterionTriggerBase;
import com.simibubi.create.foundation.advancement.ITriggerable;
import com.simibubi.create.foundation.advancement.KineticBlockTrigger;
import com.simibubi.create.foundation.advancement.SimpleTrigger;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AllTriggers {
    private static List<CriterionTriggerBase<?>> triggers = new LinkedList();
    public static KineticBlockTrigger KINETIC_BLOCK = AllTriggers.add(new KineticBlockTrigger("kinetic_block"));
    public static SimpleTrigger ROTATION = AllTriggers.simple("rotation");
    public static SimpleTrigger OVERSTRESSED = AllTriggers.simple("overstressed");
    public static SimpleTrigger SHIFTING_GEARS = AllTriggers.simple("shifting_gears");
    public static SimpleTrigger CONNECT_BELT = AllTriggers.simple("connect_belt");
    public static SimpleTrigger BONK = AllTriggers.simple("bonk");
    public static SimpleTrigger WATER_WHEEL = AllTriggers.simple("water_wheel");
    public static SimpleTrigger LAVA_WHEEL = AllTriggers.simple("lava_wheel");
    public static SimpleTrigger DEPLOYER_BOOP = AllTriggers.simple("deployer");
    public static SimpleTrigger ABSORBED_LIGHT = AllTriggers.simple("light_absorbed");
    public static SimpleTrigger SPEED_READ = AllTriggers.simple("speed_read");
    public static SimpleTrigger BASIN_THROW = AllTriggers.simple("basin");
    public static SimpleTrigger PRESS_COMPACT = AllTriggers.simple("compact");
    public static SimpleTrigger UPGRADED_ZAPPER = AllTriggers.simple("upgraded_zapper");
    public static SimpleTrigger MIXER_MIX = AllTriggers.simple("mixer");

    private static SimpleTrigger simple(String id) {
        return AllTriggers.add(new SimpleTrigger(id));
    }

    private static <T extends CriterionTriggerBase<?>> T add(T instance) {
        triggers.add(instance);
        return instance;
    }

    public static void register() {
        triggers.forEach(CriteriaTriggers::func_192118_a);
    }

    public static void triggerFor(ITriggerable trigger, PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            trigger.trigger((ServerPlayerEntity)player);
        }
    }

    public static void triggerForNearbyPlayers(ITriggerable trigger, World world, BlockPos pos, int range) {
        AllTriggers.triggerForNearbyPlayers(trigger, world, pos, range, player -> true);
    }

    public static void triggerForNearbyPlayers(ITriggerable trigger, World world, BlockPos pos, int range, Predicate<PlayerEntity> playerFilter) {
        if (world == null) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        List<ServerPlayerEntity> players = AllTriggers.getPlayersInRange(world, pos, range);
        players.stream().filter(playerFilter).forEach(trigger::trigger);
    }

    public static List<ServerPlayerEntity> getPlayersInRange(World world, BlockPos pos, int range) {
        List players = world.func_217357_a(ServerPlayerEntity.class, new AxisAlignedBB(pos).func_186662_g((double)range));
        return players;
    }
}

