/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.behaviour;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.ScreenResources;
import com.simibubi.create.foundation.behaviour.ValueBoxRenderer;
import com.simibubi.create.foundation.behaviour.scrollvalue.INamedIconOptions;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.modules.logistics.item.filter.FilterItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class ValueBox {
    String label = "Value Box";
    String sublabel = "";
    String scrollTooltip = "";
    Vec3d labelOffset = Vec3d.field_186680_a;
    int passiveColor;
    int highlightColor;
    AxisAlignedBB bb = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public ValueBox(String label, AxisAlignedBB bb) {
        this.label = label;
        this.bb = bb;
    }

    public ValueBox offsetLabel(Vec3d offset) {
        this.labelOffset = offset;
        return this;
    }

    public ValueBox subLabel(String sublabel) {
        this.sublabel = sublabel;
        return this;
    }

    public ValueBox scrollTooltip(String scrollTip) {
        this.scrollTooltip = scrollTip;
        return this;
    }

    public ValueBox withColors(int passive, int highlight) {
        this.passiveColor = passive;
        this.highlightColor = highlight;
        return this;
    }

    public void render(boolean highlighted) {
    }

    public static class IconValueBox
    extends ValueBox {
        ScreenResources icon;

        public IconValueBox(String label, INamedIconOptions iconValue, AxisAlignedBB bb) {
            super(label, bb);
            this.subLabel(Lang.translate(iconValue.getTranslationKey(), new Object[0]));
            this.icon = iconValue.getIcon();
        }

        @Override
        public void render(boolean highlighted) {
            super.render(highlighted);
            double scale = 4.0;
            GlStateManager.scaled((double)scale, (double)scale, (double)1.0);
            GlStateManager.translated((double)-8.0, (double)-8.0, (double)1.5);
            this.icon.draw(0, 0);
            GlStateManager.color4f((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
            GlStateManager.translated((double)0.5, (double)0.5, (double)-1.0);
            this.icon.draw(0, 0);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static class TextValueBox
    extends ValueBox {
        String text;

        public TextValueBox(String label, AxisAlignedBB bb, String text) {
            super(label, bb);
            this.text = text;
        }

        @Override
        public void render(boolean highlighted) {
            boolean singleDigit;
            super.render(highlighted);
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            double scale = 4.0;
            GlStateManager.scaled((double)scale, (double)scale, (double)1.0);
            GlStateManager.translated((double)-4.0, (double)-4.0, (double)5.0);
            int stringWidth = font.func_78256_a(this.text);
            font.getClass();
            float numberScale = 9.0f / (float)stringWidth;
            boolean bl = singleDigit = stringWidth < 10;
            if (singleDigit) {
                numberScale /= 2.0f;
            }
            font.getClass();
            float verticalMargin = (float)(stringWidth - 9) / 2.0f;
            GlStateManager.scaled((double)numberScale, (double)numberScale, (double)numberScale);
            GlStateManager.translated((double)(singleDigit ? (double)(stringWidth / 2) : 0.0), (double)(singleDigit ? (double)(-verticalMargin) : (double)verticalMargin), (double)0.0);
            ValueBoxRenderer.renderText(font, this.text, 0xEDEDED, 0x4F4F4F);
        }
    }

    public static class ItemValueBox
    extends ValueBox {
        ItemStack stack;
        int count;

        public ItemValueBox(String label, AxisAlignedBB bb, ItemStack stack, int count) {
            super(label, bb);
            this.stack = stack;
            this.count = count;
        }

        @Override
        public void render(boolean highlighted) {
            super.render(highlighted);
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            String countString = this.count == 0 ? "*" : this.count + "";
            GlStateManager.translated((double)17.5, (double)-5.0, (double)7.0);
            boolean isFilter = this.stack.func_77973_b() instanceof FilterItem;
            if (isFilter) {
                GlStateManager.translated((double)3.0, (double)8.0, (double)7.25);
            } else {
                GlStateManager.translated((double)(-7 - font.func_78256_a(countString)), (double)10.0, (double)10.25);
            }
            double scale = 1.5;
            GlStateManager.rotated((double)0.0, (double)1.0, (double)0.0, (double)0.0);
            GlStateManager.scaled((double)scale, (double)scale, (double)scale);
            font.func_211126_b(countString, 0.0f, 0.0f, isFilter ? 0xFFFFFF : 0xEDEDED);
            GlStateManager.translated((double)0.0, (double)0.0, (double)-0.0625);
            font.func_211126_b(countString, 0.875f, 0.875f, 0x4F4F4F);
        }
    }
}

