/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.behaviour;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.foundation.behaviour.ValueBox;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.TessellatorHelper;
import com.simibubi.create.modules.contraptions.relays.elementary.ShaftBlock;
import com.simibubi.create.modules.logistics.item.filter.FilterItem;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class ValueBoxRenderer {
    public static void renderBox(ValueBox box, boolean highlighted) {
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.disableTexture();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        GlStateManager.lineWidth((float)(highlighted ? 3.0f : 2.0f));
        Vec3d color = highlighted ? ColorHelper.getRGB(box.highlightColor) : ColorHelper.getRGB(box.passiveColor);
        AxisAlignedBB bb = box.bb;
        WorldRenderer.func_189698_a((BufferBuilder)bufferbuilder, (double)bb.field_72340_a, (double)bb.field_72338_b, (double)bb.field_72339_c, (double)bb.field_72336_d, (double)bb.field_72337_e, (double)bb.field_72334_f, (float)((float)color.field_72450_a), (float)((float)color.field_72448_b), (float)((float)color.field_72449_c), (float)1.0f);
        GlStateManager.lineWidth((float)1.0f);
        TessellatorHelper.draw();
        GlStateManager.enableTexture();
        float fontScale = -0.015625f;
        Vec3d shift = box.labelOffset;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        GlStateManager.scaled((double)fontScale, (double)fontScale, (double)fontScale);
        if (highlighted) {
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)17.5, (double)-5.0, (double)7.0);
            GlStateManager.translated((double)shift.field_72450_a, (double)shift.field_72448_b, (double)shift.field_72449_c);
            ValueBoxRenderer.renderText(box, font, box.label);
            if (!box.sublabel.isEmpty()) {
                GlStateManager.translated((double)0.0, (double)10.0, (double)0.0);
                ValueBoxRenderer.renderText(box, font, box.sublabel);
            }
            if (!box.scrollTooltip.isEmpty()) {
                GlStateManager.translated((double)0.0, (double)10.0, (double)0.0);
                ValueBoxRenderer.renderText(font, box.scrollTooltip, 0x998899, 0x111111);
            }
            GlStateManager.popMatrix();
        }
        box.render(highlighted);
        GlStateManager.disableBlend();
        GlStateManager.disableAlphaTest();
    }

    public static void renderText(ValueBox box, FontRenderer font, String text) {
        ValueBoxRenderer.renderText(font, text, box.highlightColor, ColorHelper.mixColors(box.passiveColor, 0, 0.75f));
    }

    public static void renderText(FontRenderer font, String text, int color, int shadowColor) {
        font.func_211126_b(text, 0.0f, 0.0f, color);
        GlStateManager.translated((double)0.0, (double)0.0, (double)-0.25);
        font.func_211126_b(text, 1.0f, 1.0f, shadowColor);
        GlStateManager.translated((double)0.0, (double)0.0, (double)0.25);
    }

    public static void renderItemIntoValueBox(ItemStack filter) {
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        IBakedModel modelWithOverrides = itemRenderer.func_204206_b(filter);
        boolean blockItem = modelWithOverrides.func_177556_c();
        float scale = (!blockItem ? 0.5f : 1.0f) - 0.015625f;
        float zOffset = (!blockItem ? -0.225f : 0.0f) + ValueBoxRenderer.customZOffset(filter.func_77973_b());
        GlStateManager.scaled((double)scale, (double)scale, (double)scale);
        GlStateManager.translated((double)0.0, (double)0.0, (double)zOffset);
        itemRenderer.func_181564_a(filter, ItemCameraTransforms.TransformType.FIXED);
    }

    private static float customZOffset(Item item) {
        float NUDGE = -0.1f;
        if (item instanceof FilterItem) {
            return NUDGE;
        }
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).func_179223_d();
            if (block instanceof ShaftBlock) {
                return NUDGE;
            }
            if (block instanceof FenceBlock) {
                return NUDGE;
            }
            if (block.func_203417_a(BlockTags.field_200027_d)) {
                return NUDGE;
            }
            if (block == Blocks.field_185764_cQ) {
                return NUDGE;
            }
        }
        return 0.0f;
    }
}

