/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.behaviour.base;

import com.simibubi.create.foundation.behaviour.base.IBehaviourType;
import com.simibubi.create.foundation.behaviour.base.TileEntityBehaviour;
import com.simibubi.create.foundation.block.SyncedTileEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;

public abstract class SmartTileEntity
extends SyncedTileEntity
implements ITickableTileEntity {
    private Map<IBehaviourType<?>, TileEntityBehaviour> behaviours = new HashMap();
    private boolean initialized = false;
    private boolean firstNbtRead = true;
    private int lazyTickRate;
    private int lazyTickCounter;

    public SmartTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.setLazyTickRate(10);
        ArrayList<TileEntityBehaviour> list = new ArrayList<TileEntityBehaviour>();
        this.addBehaviours(list);
        list.forEach(b -> this.behaviours.put(b.getType(), (TileEntityBehaviour)b));
    }

    public abstract void addBehaviours(List<TileEntityBehaviour> var1);

    public void addBehavioursDeferred(List<TileEntityBehaviour> behaviours) {
    }

    public void func_73660_a() {
        if (!this.initialized && this.func_145830_o()) {
            this.initialize();
            this.initialized = true;
        }
        if (this.lazyTickCounter-- <= 0) {
            this.lazyTickCounter = this.lazyTickRate;
            this.lazyTick();
        }
        this.behaviours.values().forEach(TileEntityBehaviour::tick);
    }

    public void initialize() {
        this.behaviours.values().forEach(TileEntityBehaviour::initialize);
        this.lazyTick();
    }

    public void updateClient(CompoundNBT compound) {
        this.behaviours.values().forEach(tb -> tb.updateClient(compound));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.behaviours.values().forEach(tb -> tb.writeNBT(compound));
        return super.func_189515_b(compound);
    }

    @Override
    public CompoundNBT writeToClient(CompoundNBT compound) {
        this.behaviours.values().forEach(tb -> tb.writeToClient(compound));
        return super.writeToClient(compound);
    }

    public void func_145839_a(CompoundNBT compound) {
        if (this.firstNbtRead) {
            this.firstNbtRead = false;
            ArrayList<TileEntityBehaviour> list = new ArrayList<TileEntityBehaviour>();
            this.addBehavioursDeferred(list);
            list.forEach(b -> this.behaviours.put(b.getType(), (TileEntityBehaviour)b));
        }
        super.func_145839_a(compound);
        this.forEachBehaviour(tb -> tb.readNBT(compound));
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.updateClient(compound);
        }
    }

    public void func_145843_s() {
        this.forEachBehaviour(TileEntityBehaviour::remove);
        super.func_145843_s();
    }

    public void setLazyTickRate(int slowTickRate) {
        this.lazyTickRate = slowTickRate;
        this.lazyTickCounter = slowTickRate;
    }

    public void lazyTick() {
    }

    protected void forEachBehaviour(Consumer<TileEntityBehaviour> action) {
        this.behaviours.values().forEach(tb -> {
            if (!tb.isPaused()) {
                action.accept((TileEntityBehaviour)tb);
            }
        });
    }

    protected void putBehaviour(TileEntityBehaviour behaviour) {
        this.behaviours.put(behaviour.getType(), behaviour);
        behaviour.initialize();
    }

    protected void removeBehaviour(IBehaviourType<?> type) {
        TileEntityBehaviour remove = this.behaviours.remove(type);
        if (remove != null) {
            remove.remove();
        }
    }

    protected <T extends TileEntityBehaviour> T getBehaviour(IBehaviourType<T> type) {
        if (this.behaviours.containsKey(type)) {
            return (T)this.behaviours.get(type);
        }
        return null;
    }
}

