/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.behaviour.filtering;

import com.simibubi.create.AllKeys;
import com.simibubi.create.foundation.behaviour.base.TileEntityBehaviour;
import com.simibubi.create.foundation.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.RaycastHelper;
import com.simibubi.create.modules.logistics.item.filter.FilterItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FilteringHandler {
    @SubscribeEvent
    public static void onBlockActivated(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        PlayerEntity player = event.getPlayer();
        Hand hand = event.getHand();
        if (player.func_70093_af()) {
            return;
        }
        FilteringBehaviour behaviour = TileEntityBehaviour.get((IEnviromentBlockReader)world, pos, FilteringBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        if (!behaviour.isActive()) {
            return;
        }
        BlockRayTraceResult ray = RaycastHelper.rayTraceRange(world, player, 10.0);
        if (ray == null) {
            return;
        }
        if (behaviour.testHit(ray.func_216347_e())) {
            if (event.getSide() != LogicalSide.CLIENT) {
                ItemStack heldItem = player.func_184586_b(hand).func_77946_l();
                if (!player.func_184812_l_()) {
                    if (behaviour.getFilter().func_77973_b() instanceof FilterItem) {
                        player.field_71071_by.func_191975_a(world, behaviour.getFilter());
                    }
                    if (heldItem.func_77973_b() instanceof FilterItem) {
                        player.func_184586_b(hand).func_190918_g(1);
                    }
                }
                if (heldItem.func_77973_b() instanceof FilterItem) {
                    heldItem.func_190920_e(1);
                }
                behaviour.setFilter(heldItem);
            }
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
            world.func_184133_a(null, pos, SoundEvents.field_187620_cL, SoundCategory.BLOCKS, 0.25f, 0.1f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean onScroll(double delta) {
        RayTraceResult objectMouseOver = Minecraft.func_71410_x().field_71476_x;
        if (!(objectMouseOver instanceof BlockRayTraceResult)) {
            return false;
        }
        BlockRayTraceResult result = (BlockRayTraceResult)objectMouseOver;
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        BlockPos blockPos = result.func_216350_a();
        FilteringBehaviour filtering = TileEntityBehaviour.get((IEnviromentBlockReader)world, blockPos, FilteringBehaviour.TYPE);
        if (filtering == null) {
            return false;
        }
        if (mc.field_71439_g.func_70093_af()) {
            return false;
        }
        if (!mc.field_71439_g.func_175142_cm()) {
            return false;
        }
        if (!filtering.isCountVisible()) {
            return false;
        }
        if (!filtering.testHit(objectMouseOver.func_216347_e())) {
            return false;
        }
        ItemStack filterItem = filtering.getFilter();
        if (filterItem.func_190926_b()) {
            return false;
        }
        filtering.ticksUntilScrollPacket = 10;
        int maxAmount = filterItem.func_77973_b() instanceof FilterItem ? 64 : filterItem.func_77976_d();
        filtering.scrollableValue = (int)MathHelper.func_151237_a((double)((double)filtering.scrollableValue + delta * (double)(AllKeys.ctrlDown() ? 16 : 1)), (double)0.0, (double)maxAmount);
        return true;
    }
}

