/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.behaviour.filtering;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.foundation.behaviour.ValueBox;
import com.simibubi.create.foundation.behaviour.ValueBoxRenderer;
import com.simibubi.create.foundation.behaviour.base.SmartTileEntity;
import com.simibubi.create.foundation.behaviour.base.TileEntityBehaviour;
import com.simibubi.create.foundation.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.TessellatorHelper;
import com.simibubi.create.modules.logistics.item.filter.FilterItem;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class FilteringRenderer {
    @SubscribeEvent
    public static void renderBlockHighlight(DrawBlockHighlightEvent event) {
        RayTraceResult target = event.getTarget();
        if (target == null || !(target instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult result = (BlockRayTraceResult)target;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        BlockPos pos = result.func_216350_a();
        BlockState state = world.func_180495_p(pos);
        FilteringBehaviour behaviour = TileEntityBehaviour.get((IEnviromentBlockReader)world, pos, FilteringBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        if (!behaviour.isActive()) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
            return;
        }
        TessellatorHelper.prepareForDrawing();
        GlStateManager.translated((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        behaviour.slotPositioning.renderTransformed(state, () -> {
            boolean showCount;
            ValueBox box;
            AxisAlignedBB bb = new AxisAlignedBB(Vec3d.field_186680_a, Vec3d.field_186680_a).func_186662_g(0.25);
            String label = Lang.translate("logistics.filter", new Object[0]);
            ItemStack filter = behaviour.getFilter();
            if (filter.func_77973_b() instanceof FilterItem) {
                label = "";
            }
            ValueBox valueBox = box = (showCount = behaviour.isCountVisible()) ? new ValueBox.ItemValueBox(label, bb, filter, behaviour.scrollableValue) : new ValueBox(label, bb);
            if (showCount) {
                box.scrollTooltip("[" + Lang.translate("action.scroll", new Object[0]) + "]");
            }
            box.offsetLabel(behaviour.textShift).withColors(0x7777BB, 0xCCBBFF);
            ValueBoxRenderer.renderBox(box, behaviour.testHit(target.func_216347_e()));
        });
        TessellatorHelper.cleanUpAfterDrawing();
    }

    public static void renderOnTileEntity(SmartTileEntity tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        if (tileEntityIn == null || tileEntityIn.func_145837_r()) {
            return;
        }
        FilteringBehaviour behaviour = TileEntityBehaviour.get(tileEntityIn, FilteringBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        if (!behaviour.isActive()) {
            return;
        }
        if (behaviour.getFilter().func_190926_b()) {
            return;
        }
        BlockState state = tileEntityIn.func_195044_w();
        TessellatorHelper.prepareForDrawing();
        BlockPos pos = tileEntityIn.func_174877_v();
        GlStateManager.translated((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        behaviour.slotPositioning.renderTransformed(state, () -> ValueBoxRenderer.renderItemIntoValueBox(behaviour.getFilter()));
        TessellatorHelper.cleanUpAfterDrawing();
    }
}

