/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.behaviour.inventory;

import com.simibubi.create.config.AllConfigs;
import com.simibubi.create.foundation.behaviour.base.IBehaviourType;
import com.simibubi.create.foundation.behaviour.base.SmartTileEntity;
import com.simibubi.create.foundation.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.behaviour.inventory.InventoryManagementBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class ExtractingBehaviour
extends InventoryManagementBehaviour {
    public static IBehaviourType<ExtractingBehaviour> TYPE = new IBehaviourType<ExtractingBehaviour>(){};
    private Function<ItemStack, Integer> customAmountFilter = stack -> 64;
    private Predicate<ItemStack> customFilter = stack -> true;
    private Consumer<ItemStack> callback;

    public ExtractingBehaviour(SmartTileEntity te, Supplier<List<Pair<BlockPos, Direction>>> attachments, Consumer<ItemStack> onExtract) {
        super(te, attachments);
        this.setCallback(onExtract);
    }

    public ExtractingBehaviour withAmountThreshold(Function<ItemStack, Integer> filter) {
        this.customAmountFilter = filter;
        return this;
    }

    public ExtractingBehaviour withAdditionalFilter(Predicate<ItemStack> filter) {
        this.customFilter = filter;
        return this;
    }

    public boolean extract() {
        return this.extract(this.getAmountToExtract());
    }

    public int getAmountToExtract() {
        int amount = -1;
        FilteringBehaviour filter = ExtractingBehaviour.get(this.tileEntity, FilteringBehaviour.TYPE);
        if (filter != null && !filter.anyAmount()) {
            amount = filter.getAmount();
        }
        return amount;
    }

    public boolean extract(int exactAmount) {
        if (this.getWorld().field_72995_K) {
            return false;
        }
        if (((Boolean)AllConfigs.SERVER.control.freezeExtractors.get()).booleanValue()) {
            return false;
        }
        Predicate<ItemStack> test = this.getFilterTest();
        for (IItemHandler inv : this.getInventories()) {
            ItemStack extract = ItemStack.field_190927_a;
            extract = exactAmount != -1 ? ItemHelper.extract(inv, test, exactAmount, false) : ItemHelper.extract(inv, test, this.customAmountFilter, false);
            if (extract.func_190926_b()) continue;
            this.callback.accept(extract);
            return true;
        }
        return false;
    }

    public Predicate<ItemStack> getFilterTest() {
        Predicate<ItemStack> test = this.customFilter;
        FilteringBehaviour filter = ExtractingBehaviour.get(this.tileEntity, FilteringBehaviour.TYPE);
        if (filter != null) {
            test = this.customFilter.and(filter::test);
        }
        return test;
    }

    @Override
    public IBehaviourType<?> getType() {
        return TYPE;
    }

    public void setCallback(Consumer<ItemStack> callback) {
        this.callback = callback;
    }
}

