/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.behaviour.linked;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.foundation.behaviour.ValueBox;
import com.simibubi.create.foundation.behaviour.ValueBoxRenderer;
import com.simibubi.create.foundation.behaviour.base.SmartTileEntity;
import com.simibubi.create.foundation.behaviour.base.TileEntityBehaviour;
import com.simibubi.create.foundation.behaviour.linked.LinkBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.TessellatorHelper;
import java.util.function.Consumer;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class LinkRenderer {
    @SubscribeEvent
    public static void renderBlockHighlight(DrawBlockHighlightEvent event) {
        RayTraceResult target = event.getTarget();
        if (target == null || !(target instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult result = (BlockRayTraceResult)target;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        BlockPos pos = result.func_216350_a();
        BlockState state = world.func_180495_p(pos);
        LinkBehaviour behaviour = TileEntityBehaviour.get((IEnviromentBlockReader)world, pos, LinkBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        TessellatorHelper.prepareForDrawing();
        GlStateManager.translated((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        String freq1 = Lang.translate("logistics.firstFrequency", new Object[0]);
        String freq2 = Lang.translate("logistics.secondFrequency", new Object[0]);
        LinkRenderer.renderEachSlot(state, behaviour, first -> {
            AxisAlignedBB bb = new AxisAlignedBB(Vec3d.field_186680_a, Vec3d.field_186680_a).func_186662_g(0.25);
            String label = first != false ? freq2 : freq1;
            ValueBox box = new ValueBox(label, bb).withColors(0x992266, 0xFF55AA).offsetLabel(behaviour.textShift);
            ValueBoxRenderer.renderBox(box, behaviour.testHit((Boolean)first, target.func_216347_e()));
        });
        TessellatorHelper.cleanUpAfterDrawing();
    }

    public static void renderOnTileEntity(SmartTileEntity tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        if (tileEntityIn == null || tileEntityIn.func_145837_r()) {
            return;
        }
        LinkBehaviour behaviour = TileEntityBehaviour.get(tileEntityIn, LinkBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        BlockState state = tileEntityIn.func_195044_w();
        TessellatorHelper.prepareForDrawing();
        BlockPos pos = tileEntityIn.func_174877_v();
        GlStateManager.translated((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        LinkRenderer.renderEachSlot(state, behaviour, first -> ValueBoxRenderer.renderItemIntoValueBox(first != false ? behaviour.frequencyFirst.getStack() : behaviour.frequencyLast.getStack()));
        TessellatorHelper.cleanUpAfterDrawing();
    }

    private static void renderEachSlot(BlockState state, LinkBehaviour behaviour, Consumer<Boolean> render) {
        behaviour.firstSlot.renderTransformed(state, () -> render.accept(true));
        behaviour.secondSlot.renderTransformed(state, () -> render.accept(false));
    }
}

