/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.behaviour.scrollvalue;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.foundation.behaviour.ValueBox;
import com.simibubi.create.foundation.behaviour.ValueBoxRenderer;
import com.simibubi.create.foundation.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.behaviour.base.SmartTileEntity;
import com.simibubi.create.foundation.behaviour.base.TileEntityBehaviour;
import com.simibubi.create.foundation.behaviour.scrollvalue.BulkScrollValueBehaviour;
import com.simibubi.create.foundation.behaviour.scrollvalue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.TessellatorHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ScrollValueRenderer {
    @SubscribeEvent
    public static void renderBlockHighlight(DrawBlockHighlightEvent event) {
        RayTraceResult target = event.getTarget();
        if (target == null || !(target instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult result = (BlockRayTraceResult)target;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        BlockPos pos = result.func_216350_a();
        Direction face = result.func_216354_b();
        ScrollValueBehaviour behaviour = TileEntityBehaviour.get((IEnviromentBlockReader)world, pos, ScrollValueBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        if (behaviour.needsWrench && !AllItems.WRENCH.typeOf(Minecraft.func_71410_x().field_71439_g.func_184614_ca())) {
            return;
        }
        boolean highlight = behaviour.testHit(target.func_216347_e());
        TessellatorHelper.prepareForDrawing();
        if (behaviour instanceof BulkScrollValueBehaviour && AllKeys.ctrlDown()) {
            BulkScrollValueBehaviour bulkScrolling = (BulkScrollValueBehaviour)behaviour;
            for (SmartTileEntity smartTileEntity : bulkScrolling.getBulk()) {
                GlStateManager.pushMatrix();
                ScrollValueBehaviour other = TileEntityBehaviour.get(smartTileEntity, ScrollValueBehaviour.TYPE);
                if (other != null) {
                    ScrollValueRenderer.render(world, smartTileEntity.func_174877_v(), face, other, highlight);
                }
                GlStateManager.popMatrix();
            }
        } else {
            ScrollValueRenderer.render(world, pos, face, behaviour, highlight);
        }
        TessellatorHelper.cleanUpAfterDrawing();
        GlStateManager.enableAlphaTest();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    protected static void render(ClientWorld world, BlockPos pos, Direction face, ScrollValueBehaviour behaviour, boolean highlight) {
        GlStateManager.translated((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        BlockState state = world.func_180495_p(pos);
        if (behaviour.slotPositioning instanceof ValueBoxTransform.Sided) {
            ((ValueBoxTransform.Sided)behaviour.slotPositioning).fromSide(face);
        }
        behaviour.slotPositioning.renderTransformed(state, () -> {
            ValueBox box;
            AxisAlignedBB bb = new AxisAlignedBB(Vec3d.field_186680_a, Vec3d.field_186680_a).func_186662_g(0.5).func_191195_a(0.0, 0.0, -0.5).func_72317_d(0.0, 0.0, -0.125);
            String label = behaviour.label;
            if (behaviour instanceof ScrollOptionBehaviour) {
                box = new ValueBox.IconValueBox(label, ((ScrollOptionBehaviour)behaviour).getIconForSelected(), bb);
            } else {
                box = new ValueBox.TextValueBox(label, bb, behaviour.formatValue());
                if (behaviour.unit != null) {
                    box.subLabel("(" + behaviour.unit.apply(behaviour.scrollableValue) + ")");
                }
            }
            box.scrollTooltip("[" + Lang.translate("action.scroll", new Object[0]) + "]");
            box.offsetLabel(behaviour.textShift.func_72441_c(20.0, -10.0, 0.0)).withColors(12490507, 16770910);
            ValueBoxRenderer.renderBox(box, highlight);
        });
    }
}

