/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block.connected;

import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import java.util.function.BiPredicate;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;

public abstract class ConnectedTextureBehaviour {
    public abstract CTSpriteShiftEntry get(BlockState var1, Direction var2);

    public abstract Iterable<CTSpriteShiftEntry> getAllCTShifts();

    protected boolean reverseUVs(BlockState state, Direction face) {
        return false;
    }

    protected boolean reverseUVsHorizontally(BlockState state, Direction face) {
        return this.reverseUVs(state, face);
    }

    protected boolean reverseUVsVertically(BlockState state, Direction face) {
        return this.reverseUVs(state, face);
    }

    public boolean connectsTo(BlockState state, BlockState other, IEnviromentBlockReader reader, BlockPos pos, BlockPos otherPos, Direction face) {
        BlockPos blockingPos = otherPos.func_177972_a(face);
        if (face.func_176740_k().func_196052_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) == face.func_176740_k().func_196052_a(otherPos.func_177958_n(), otherPos.func_177956_o(), otherPos.func_177952_p()) && this.connectsTo(state, reader.func_180495_p(blockingPos), reader, pos, blockingPos, face)) {
            return false;
        }
        return state.func_177230_c() == other.func_177230_c();
    }

    CTContext buildContext(IEnviromentBlockReader reader, BlockPos pos, BlockState state, Direction face) {
        Direction.Axis axis = face.func_176740_k();
        boolean positive = face.func_176743_c() == Direction.AxisDirection.POSITIVE;
        Direction h = axis == Direction.Axis.X ? Direction.SOUTH : Direction.WEST;
        Direction v = axis.func_176722_c() ? Direction.UP : Direction.NORTH;
        Direction direction = h = positive ? h.func_176734_d() : h;
        if (face == Direction.DOWN) {
            v = v.func_176734_d();
            h = h.func_176734_d();
        }
        Direction horizontal = h;
        Direction vertical = v;
        BiPredicate<Integer, Integer> connection = (x, y) -> {
            BlockPos p = pos.func_177967_a(horizontal, x.intValue()).func_177967_a(vertical, y.intValue());
            return this.connectsTo(state, reader.func_180495_p(p), reader, pos, p, face);
        };
        boolean flipH = this.reverseUVsHorizontally(state, face);
        boolean flipV = this.reverseUVsVertically(state, face);
        int sh = flipH ? -1 : 1;
        int sv = flipV ? -1 : 1;
        CTContext context = new CTContext();
        context.up = connection.test(0, sv);
        context.down = connection.test(0, -sv);
        context.left = connection.test(-sh, 0);
        context.right = connection.test(sh, 0);
        context.topLeft = connection.test(-sh, sv);
        context.topRight = connection.test(sh, sv);
        context.bottomLeft = connection.test(-sh, -sv);
        context.bottomRight = connection.test(sh, -sv);
        return context;
    }

    class CTContext {
        boolean up;
        boolean down;
        boolean left;
        boolean right;
        boolean topLeft;
        boolean topRight;
        boolean bottomLeft;
        boolean bottomRight;

        CTContext() {
        }
    }
}

