/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block.render;

import com.simibubi.create.foundation.block.IHaveColoredVertices;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class ColoredVertexModel
extends BakedModelWrapper<IBakedModel> {
    private IHaveColoredVertices colorer;
    private static ModelProperty<BlockPos> POSITION_PROPERTY = new ModelProperty();

    public ColoredVertexModel(IBakedModel originalModel, IHaveColoredVertices colorer) {
        super(originalModel);
        this.colorer = colorer;
    }

    public IModelData getModelData(IEnviromentBlockReader world, BlockPos pos, BlockState state, IModelData tileData) {
        return new ModelDataMap.Builder().withInitial(POSITION_PROPERTY, (Object)pos).build();
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(super.getQuads(state, side, rand, extraData));
        if (!extraData.hasProperty(POSITION_PROPERTY)) {
            return quads;
        }
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad quad = (BakedQuad)quads.get(i);
            BakedQuad newQuad = new BakedQuad(Arrays.copyOf(quad.func_178209_a(), quad.func_178209_a().length), quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat());
            VertexFormat format = quad.getFormat();
            int[] vertexData = newQuad.func_178209_a();
            BlockPos data = (BlockPos)extraData.getData(POSITION_PROPERTY);
            for (int vertex = 0; vertex < vertexData.length; vertex += format.func_181719_f()) {
                int color;
                int colorOffset = format.func_177340_e() / 4;
                float x = Float.intBitsToFloat(vertexData[vertex]);
                float y = Float.intBitsToFloat(vertexData[vertex + 1]);
                float z = Float.intBitsToFloat(vertexData[vertex + 2]);
                vertexData[vertex + colorOffset] = color = this.colorer.getColor(x + (float)data.func_177958_n(), y + (float)data.func_177956_o(), z + (float)data.func_177952_p());
            }
            quads.set(i, newQuad);
        }
        return quads;
    }
}

