/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block.render;

import com.simibubi.create.foundation.block.render.WrappedBakedModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import org.apache.commons.lang3.tuple.Pair;

public abstract class CustomRenderedItemModel
extends WrappedBakedModel {
    protected String basePath;
    protected Map<String, IBakedModel> partials = new HashMap<String, IBakedModel>();
    protected ItemCameraTransforms.TransformType currentPerspective;
    protected ItemStackTileEntityRenderer renderer;

    public CustomRenderedItemModel(IBakedModel template, String basePath) {
        super(template);
        this.basePath = basePath;
        this.renderer = this.createRenderer();
    }

    public final List<ResourceLocation> getModelLocations() {
        return this.partials.keySet().stream().map(this::getPartialModelLocation).collect(Collectors.toList());
    }

    public ItemStackTileEntityRenderer getRenderer() {
        return this.renderer;
    }

    public abstract ItemStackTileEntityRenderer createRenderer();

    @Override
    public boolean func_188618_c() {
        return true;
    }

    @Override
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        this.currentPerspective = cameraTransformType;
        return super.handlePerspective(cameraTransformType);
    }

    protected void addPartials(String ... partials) {
        this.partials.clear();
        for (String name : partials) {
            this.partials.put(name, null);
        }
    }

    public CustomRenderedItemModel loadPartials(ModelBakeEvent event) {
        for (String name : this.partials.keySet()) {
            this.partials.put(name, this.loadModel(event, name));
        }
        return this;
    }

    private IBakedModel loadModel(ModelBakeEvent event, String name) {
        return event.getModelLoader().func_217845_a(this.getPartialModelLocation(name), (ISprite)ModelRotation.X0_Y0);
    }

    private ResourceLocation getPartialModelLocation(String name) {
        return new ResourceLocation("create", "item/" + this.basePath + "/" + name);
    }

    public ItemCameraTransforms.TransformType getCurrentPerspective() {
        return this.currentPerspective;
    }

    public IBakedModel getPartial(String name) {
        return this.partials.get(name);
    }
}

